/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.auth;

import com.trilead.ssh2.auth.AgentProxy;
import java.io.File;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;

public class SVNSSHAuthentication
extends SVNAuthentication {
    private char[] myPassword;
    private char[] myPassphrase;
    private File myPrivateKeyFile;
    private AgentProxy myAgentProxy;
    private int myPortNumber;
    private char[] myPrivateKeyValue;

    public static SVNSSHAuthentication newInstance(String string, char[] cArray, int n2, boolean bl2, SVNURL sVNURL, boolean bl3) {
        return new SVNSSHAuthentication(string, cArray, null, null, null, null, n2, bl2, sVNURL, bl3);
    }

    public static SVNSSHAuthentication newInstance(String string, File file, char[] cArray, int n2, boolean bl2, SVNURL sVNURL, boolean bl3) {
        return new SVNSSHAuthentication(string, null, file, null, cArray, null, n2, bl2, sVNURL, bl3);
    }

    public static SVNSSHAuthentication newInstance(String string, char[] cArray, char[] cArray2, int n2, boolean bl2, SVNURL sVNURL, boolean bl3) {
        return new SVNSSHAuthentication(string, null, null, cArray, cArray2, null, n2, bl2, sVNURL, bl3);
    }

    public static SVNSSHAuthentication newInstance(String string, AgentProxy agentProxy, int n2, SVNURL sVNURL, boolean bl2) {
        return new SVNSSHAuthentication(string, null, null, null, null, agentProxy, n2, false, sVNURL, bl2);
    }

    public SVNSSHAuthentication(String string, String string2, int n2, boolean bl2) {
        this(string, string2 == null ? new char[]{} : string2.toCharArray(), null, null, null, null, n2, bl2, null, false);
    }

    public SVNSSHAuthentication(String string, String string2, int n2, boolean bl2, SVNURL sVNURL, boolean bl3) {
        this(string, string2 == null ? new char[]{} : string2.toCharArray(), null, null, null, null, n2, bl2, sVNURL, bl3);
    }

    public SVNSSHAuthentication(String string, File file, String string2, int n2, boolean bl2) {
        this(string, null, file, string2 != null ? string2.toCharArray() : null, null, null, n2, bl2, null, false);
    }

    public SVNSSHAuthentication(String string, File file, String string2, int n2, boolean bl2, SVNURL sVNURL, boolean bl3) {
        this(string, null, file, null, string2 != null ? string2.toCharArray() : null, null, n2, bl2, sVNURL, bl3);
    }

    public SVNSSHAuthentication(String string, char[] cArray, String string2, int n2, boolean bl2) {
        this(string, null, null, cArray, string2 != null ? string2.toCharArray() : null, null, n2, bl2, null, false);
    }

    public SVNSSHAuthentication(String string, char[] cArray, String string2, int n2, boolean bl2, SVNURL sVNURL, boolean bl3) {
        this(string, null, null, cArray, string2 != null ? string2.toCharArray() : null, null, n2, bl2, sVNURL, bl3);
    }

    public SVNSSHAuthentication(String string, AgentProxy agentProxy, int n2, SVNURL sVNURL, boolean bl2) {
        this(string, null, null, null, null, agentProxy, n2, false, sVNURL, bl2);
    }

    private SVNSSHAuthentication(String string, char[] cArray, File file, char[] cArray2, char[] cArray3, AgentProxy agentProxy, int n2, boolean bl2, SVNURL sVNURL, boolean bl3) {
        super("svn.ssh", string, bl2, sVNURL, bl3);
        this.myAgentProxy = agentProxy;
        this.myPassword = cArray;
        this.myPassphrase = cArray3;
        this.myPrivateKeyFile = file;
        this.myPrivateKeyValue = cArray2;
        this.myPortNumber = n2;
    }

    public String getPassword() {
        return this.myPassword != null ? new String(this.myPassword) : null;
    }

    public char[] getPasswordValue() {
        return this.myPassword;
    }

    public String getPassphrase() {
        return this.myPassphrase != null ? new String(this.myPassphrase) : null;
    }

    public char[] getPassphraseValue() {
        return this.myPassphrase;
    }

    public File getPrivateKeyFile() {
        return this.myPrivateKeyFile;
    }

    public char[] getPrivateKey() {
        return this.myPrivateKeyValue;
    }

    public int getPortNumber() {
        return this.myPortNumber;
    }

    public boolean hasPrivateKey() {
        return this.myPrivateKeyFile != null || this.myPrivateKeyValue != null;
    }

    public AgentProxy getAgentProxy() {
        return this.myAgentProxy;
    }

    @Override
    public void dismissSensitiveData() {
        super.dismissSensitiveData();
        SVNEncodingUtil.clearArray(this.myPassphrase);
        SVNEncodingUtil.clearArray(this.myPassword);
        SVNEncodingUtil.clearArray(this.myPrivateKeyValue);
    }

    @Override
    public SVNAuthentication copy() {
        return new SVNSSHAuthentication(this.getUserName(), this.copyOf(this.myPassword), this.myPrivateKeyFile, this.copyOf(this.myPrivateKeyValue), this.copyOf(this.myPassphrase), this.myAgentProxy, this.myPortNumber, this.isStorageAllowed(), this.getURL(), this.isPartial());
    }
}

