/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.auth;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManagerExt;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.ISVNProxyManagerEx;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNRepository;

public class BasicAuthenticationManager
implements ISVNAuthenticationManager,
ISVNProxyManagerEx,
ISVNSSHHostVerifier {
    private List myPasswordAuthentications;
    private List mySSHAuthentications;
    private List myUserNameAuthentications;
    private List mySSLAuthentications;
    private int mySSHIndex;
    private int myPasswordIndex;
    private int myUserNameIndex;
    private int mySSLIndex;
    private String myProxyHost;
    private int myProxyPort;
    private String myProxyUserName;
    private char[] myProxyPassword;
    private boolean myIsAuthenticationForced;

    public static BasicAuthenticationManager newInstance(String string, char[] cArray) {
        return BasicAuthenticationManager.newInstance(new SVNAuthentication[]{SVNPasswordAuthentication.newInstance(string, cArray, false, null, false), SVNSSHAuthentication.newInstance(string, cArray, -1, false, null, false), SVNUserNameAuthentication.newInstance(string, false, null, false)});
    }

    public static BasicAuthenticationManager newInstance(String string, File file, char[] cArray, int n2) {
        return BasicAuthenticationManager.newInstance(new SVNAuthentication[]{SVNSSHAuthentication.newInstance(string, file, cArray, n2, false, null, false), SVNUserNameAuthentication.newInstance(string, false, null, false)});
    }

    public static BasicAuthenticationManager newInstance(SVNAuthentication[] sVNAuthenticationArray) {
        return new BasicAuthenticationManager(sVNAuthenticationArray);
    }

    public static void acknowledgeAuthentication(boolean bl2, String string, String string2, SVNErrorMessage sVNErrorMessage, SVNAuthentication sVNAuthentication, SVNURL sVNURL, ISVNAuthenticationManager iSVNAuthenticationManager) {
        if (iSVNAuthenticationManager instanceof ISVNAuthenticationManagerExt) {
            ((ISVNAuthenticationManagerExt)iSVNAuthenticationManager).acknowledgeAuthentication(bl2, string, string2, sVNErrorMessage, sVNAuthentication, sVNURL);
        } else {
            iSVNAuthenticationManager.acknowledgeAuthentication(bl2, string, string2, sVNErrorMessage, sVNAuthentication);
        }
    }

    public BasicAuthenticationManager(String string, String string2) {
        this(new SVNAuthentication[]{SVNPasswordAuthentication.newInstance(string, string2 != null ? string2.toCharArray() : null, false, null, false), SVNSSHAuthentication.newInstance(string, string2 != null ? string2.toCharArray() : null, -1, false, null, false), SVNUserNameAuthentication.newInstance(string, false, null, false)});
    }

    public BasicAuthenticationManager(String string, File file, String string2, int n2) {
        this(new SVNAuthentication[]{SVNSSHAuthentication.newInstance(string, file, string2 != null ? string2.toCharArray() : null, n2, false, null, false), SVNUserNameAuthentication.newInstance(string, false, null, false)});
    }

    public BasicAuthenticationManager(SVNAuthentication[] sVNAuthenticationArray) {
        this.setAuthentications(sVNAuthenticationArray);
    }

    public void setAuthentications(SVNAuthentication[] sVNAuthenticationArray) {
        this.dismissSensitiveData();
        this.myPasswordAuthentications = new ArrayList();
        this.mySSHAuthentications = new ArrayList();
        this.myUserNameAuthentications = new ArrayList();
        this.mySSLAuthentications = new ArrayList();
        this.myPasswordIndex = 0;
        this.mySSHIndex = 0;
        this.mySSLIndex = 0;
        this.myUserNameIndex = 0;
        for (int i2 = 0; sVNAuthenticationArray != null && i2 < sVNAuthenticationArray.length; ++i2) {
            SVNAuthentication sVNAuthentication = sVNAuthenticationArray[i2];
            if (sVNAuthentication instanceof SVNPasswordAuthentication) {
                this.myPasswordAuthentications.add(sVNAuthentication);
                continue;
            }
            if (sVNAuthentication instanceof SVNSSHAuthentication) {
                this.mySSHAuthentications.add(sVNAuthentication);
                continue;
            }
            if (sVNAuthentication instanceof SVNUserNameAuthentication) {
                this.myUserNameAuthentications.add(sVNAuthentication);
                continue;
            }
            if (!(sVNAuthentication instanceof SVNSSLAuthentication)) continue;
            this.mySSLAuthentications.add(sVNAuthentication);
        }
    }

    public void setProxy(String string, int n2, String string2, String string3) {
        this.setProxy(string, n2, string2, string3 != null ? string3.toCharArray() : null);
    }

    public void setProxy(String string, int n2, String string2, char[] cArray) {
        this.myProxyHost = string;
        this.myProxyPort = n2 >= 0 ? n2 : 3128;
        this.myProxyUserName = string2;
        this.myProxyPassword = cArray;
    }

    @Override
    public SVNAuthentication getFirstAuthentication(String string, String string2, SVNURL sVNURL) {
        if ("svn.ssh".equals(string) && this.mySSHAuthentications.size() > 0) {
            this.mySSHIndex = 0;
            return (SVNAuthentication)this.mySSHAuthentications.get(0);
        }
        if ("svn.simple".equals(string) && this.myPasswordAuthentications.size() > 0) {
            this.myPasswordIndex = 0;
            return (SVNAuthentication)this.myPasswordAuthentications.get(0);
        }
        if ("svn.username".equals(string) && this.myUserNameAuthentications.size() > 0) {
            this.myUserNameIndex = 0;
            return (SVNAuthentication)this.myUserNameAuthentications.get(0);
        }
        if ("svn.ssl.client-passphrase".equals(string) && this.mySSLAuthentications.size() > 0) {
            this.mySSLIndex = 0;
            return (SVNAuthentication)this.mySSLAuthentications.get(0);
        }
        if ("svn.username".equals(string)) {
            if (sVNURL.getUserInfo() != null && !"".equals(sVNURL.getUserInfo())) {
                return SVNUserNameAuthentication.newInstance(sVNURL.getUserInfo(), false, sVNURL, false);
            }
            return SVNUserNameAuthentication.newInstance(null, false, sVNURL, false);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", string2);
        return null;
    }

    @Override
    public SVNAuthentication getNextAuthentication(String string, String string2, SVNURL sVNURL) {
        if ("svn.ssh".equals(string) && this.mySSHIndex + 1 < this.mySSHAuthentications.size()) {
            ++this.mySSHIndex;
            return (SVNAuthentication)this.mySSHAuthentications.get(this.mySSHIndex);
        }
        if ("svn.simple".equals(string) && this.myPasswordIndex + 1 < this.myPasswordAuthentications.size()) {
            ++this.myPasswordIndex;
            return (SVNAuthentication)this.myPasswordAuthentications.get(this.myPasswordIndex);
        }
        if ("svn.username".equals(string) && this.myUserNameIndex + 1 < this.myUserNameAuthentications.size()) {
            ++this.myUserNameIndex;
            return (SVNAuthentication)this.myUserNameAuthentications.get(this.myUserNameIndex);
        }
        if ("svn.ssl.client-passphrase".equals(string) && this.mySSLIndex + 1 < this.mySSLAuthentications.size()) {
            ++this.mySSLIndex;
            return (SVNAuthentication)this.mySSLAuthentications.get(this.mySSLIndex);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", string2);
        return null;
    }

    @Override
    public void setAuthenticationProvider(ISVNAuthenticationProvider iSVNAuthenticationProvider) {
    }

    @Override
    public ISVNProxyManager getProxyManager(SVNURL sVNURL) {
        return this;
    }

    @Override
    public TrustManager getTrustManager(SVNURL sVNURL) {
        return null;
    }

    @Override
    public void acknowledgeAuthentication(boolean bl2, String string, String string2, SVNErrorMessage sVNErrorMessage, SVNAuthentication sVNAuthentication) {
    }

    @Override
    public void acknowledgeTrustManager(TrustManager trustManager) {
    }

    @Override
    public boolean isAuthenticationForced() {
        return this.myIsAuthenticationForced;
    }

    public void setAuthenticationForced(boolean bl2) {
        this.myIsAuthenticationForced = bl2;
    }

    @Override
    public String getProxyHost() {
        return this.myProxyHost;
    }

    @Override
    public int getProxyPort() {
        return this.myProxyPort;
    }

    @Override
    public String getProxyUserName() {
        return this.myProxyUserName;
    }

    @Override
    public String getProxyPassword() {
        return this.myProxyPassword != null ? new String(this.myProxyPassword) : null;
    }

    @Override
    public char[] getProxyPasswordValue() {
        return this.myProxyPassword;
    }

    @Override
    public void acknowledgeProxyContext(boolean bl2, SVNErrorMessage sVNErrorMessage) {
    }

    @Override
    public int getReadTimeout(SVNRepository sVNRepository) {
        String string = sVNRepository.getLocation().getProtocol();
        if ("http".equals(string) || "https".equals(string)) {
            return 3600000;
        }
        return 0;
    }

    @Override
    public int getConnectTimeout(SVNRepository sVNRepository) {
        String string = sVNRepository.getLocation().getProtocol();
        if ("http".equals(string) || "https".equals(string)) {
            return 60000;
        }
        return 0;
    }

    @Override
    public void verifyHostKey(String string, int n2, String string2, byte[] byArray) {
    }

    public void dismissSensitiveData() {
        this.dismissSensitiveData(this.myPasswordAuthentications);
        this.dismissSensitiveData(this.mySSHAuthentications);
        this.dismissSensitiveData(this.myUserNameAuthentications);
        this.dismissSensitiveData(this.mySSLAuthentications);
        this.myPasswordIndex = 0;
        this.mySSHIndex = 0;
        this.mySSLIndex = 0;
        this.myUserNameIndex = 0;
    }

    private void dismissSensitiveData(List list) {
        if (list == null) {
            return;
        }
        for (SVNAuthentication sVNAuthentication : list) {
            sVNAuthentication.dismissSensitiveData();
        }
        list.clear();
    }
}

