/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNURL {
    private static final Map DEFAULT_PORTS = new SVNHashMap();
    private String myURL;
    private String myProtocol;
    private String myHost;
    private String myPath;
    private String myUserName;
    private int myPort;
    private String myEncodedPath;
    private boolean myIsDefaultPort;

    public static SVNURL create(String string, String string2, String string3, int n2, String string4, boolean bl2) {
        Object object;
        if (string3 == null && !"file".equalsIgnoreCase(string) || string3 != null && string3.indexOf(64) >= 0) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Invalid host name ''{0}''", (Object)string3), SVNLogType.DEFAULT);
        }
        string4 = string4 == null ? "/" : string4;
        string4 = !bl2 ? SVNEncodingUtil.uriEncode(string4) : SVNEncodingUtil.autoURIEncode(string4);
        if (string4.length() > 0 && string4.charAt(0) != '/') {
            string4 = "/" + string4;
        }
        if (string4.length() > 0 && string4.charAt(string4.length() - 1) == '/') {
            string4 = string4.substring(0, string4.length() - 1);
        }
        string = string == null ? "http" : string.toLowerCase();
        String string5 = null;
        if (string2 != null && string2.indexOf(47) >= 0) {
            string5 = "Malformed URL: user info part could not include '/' symbol";
        } else if (string3 == null && !"file".equals(string)) {
            string5 = "Malformed URL: host could not be NULL";
        } else if (!"file".equals(string) && string3.indexOf(47) >= 0) {
            string5 = "Malformed URL: host could not include '/' symbol";
        }
        if (string5 != null) {
            object = SVNErrorMessage.create(SVNErrorCode.BAD_URL, string5);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        object = SVNURL.composeURL(string, string2, string3, n2, string4);
        return new SVNURL((String)object, true);
    }

    @Deprecated
    public static SVNURL parseURIDecoded(String string) {
        return new SVNURL(string, false);
    }

    public static SVNURL parseURIEncoded(String string) {
        return new SVNURL(string, true);
    }

    public static SVNURL fromFile(File file) {
        if (file == null) {
            return null;
        }
        String string = file.getAbsoluteFile().getAbsolutePath();
        String string2 = null;
        if (SVNFileUtil.isWindows && string.startsWith("//") || string.startsWith("\\\\")) {
            string = string.replace(File.separatorChar, '/');
            int n2 = (string = string.substring("//".length())).indexOf("/") > 0 ? string.indexOf("/") : string.length();
            string2 = string.substring(0, n2);
            string = string.substring(string2.length());
        } else {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return SVNURL.create("file", null, string2, -1, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDefaultPortNumber(String string) {
        Integer n2;
        if (string == null) {
            return -1;
        }
        if ("file".equals(string = string.toLowerCase())) {
            return -1;
        }
        Map map = DEFAULT_PORTS;
        synchronized (map) {
            n2 = (Integer)DEFAULT_PORTS.get(string);
        }
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProtocol(String string, int n2) {
        if (string != null) {
            Map map = DEFAULT_PORTS;
            synchronized (map) {
                if (n2 >= 0) {
                    DEFAULT_PORTS.put(string, n2);
                } else {
                    DEFAULT_PORTS.remove(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNURL(String string, boolean bl2) {
        Serializable serializable;
        Object object;
        int n2;
        if (string == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL cannot be NULL");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n2 = string.indexOf("://")) <= 0) {
            object = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Malformed URL ''{0}''", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        this.myProtocol = string.substring(0, n2);
        this.myProtocol = this.myProtocol.toLowerCase();
        object = DEFAULT_PORTS;
        synchronized (object) {
            if (!DEFAULT_PORTS.containsKey(this.myProtocol) && !this.myProtocol.startsWith("svn+")) {
                serializable = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL protocol is not supported ''{0}''", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.DEFAULT);
            }
        }
        if ("file".equals(this.myProtocol)) {
            Serializable serializable2;
            object = SVNURL.norlmalizeURLPath(string, string.substring("file://".length()));
            int n3 = ((String)object).indexOf(47);
            if (n3 == -1 && ((String)object).length() > 0) {
                serializable2 = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Local URL ''{0}'' contains only a hostname, no path", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)serializable2, SVNLogType.DEFAULT);
            }
            this.myPath = n3 == -1 ? "" : ((String)object).substring(n3);
            this.myHost = ((String)object).equals(this.myPath) ? "" : ((String)object).substring(0, n3);
            serializable2 = null;
            try {
                serializable2 = new URL(this.myProtocol + "://" + (String)object);
            }
            catch (MalformedURLException malformedURLException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Malformed URL: ''{0}'': {1}", string, malformedURLException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, malformedURLException, SVNLogType.DEFAULT);
                return;
            }
            if (bl2) {
                this.myPath = this.myPath.replace('\\', '/');
                this.myEncodedPath = SVNEncodingUtil.autoURIEncode(this.myPath);
                SVNEncodingUtil.assertURISafe(this.myEncodedPath);
                this.myPath = SVNEncodingUtil.uriDecode(this.myEncodedPath);
                if (!this.myPath.startsWith("/")) {
                    this.myPath = "/" + this.myPath;
                }
            } else {
                this.myEncodedPath = SVNEncodingUtil.uriEncode(this.myPath);
                this.myPath = this.myPath.replace('\\', '/');
                if (!this.myPath.startsWith("/")) {
                    this.myPath = "/" + this.myPath;
                }
            }
            this.myUserName = ((URL)serializable2).getUserInfo();
            this.myPort = ((URL)serializable2).getPort();
        } else {
            Object object2;
            object = "http" + string.substring(n2);
            try {
                serializable = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Malformed URL: ''{0}'': {1}", string, malformedURLException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, malformedURLException, SVNLogType.DEFAULT);
                return;
            }
            this.myHost = ((URL)serializable).getHost();
            if ("".equals(this.myHost)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Malformed URL: ''{0}''", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
                return;
            }
            String string2 = SVNURL.norlmalizeURLPath(string, SVNURL.getPath((URL)serializable));
            if (bl2) {
                this.myEncodedPath = SVNEncodingUtil.autoURIEncode(string2);
                SVNEncodingUtil.assertURISafe(this.myEncodedPath);
                this.myPath = SVNEncodingUtil.uriDecode(this.myEncodedPath);
            } else {
                object2 = string.substring(n2 + "://".length());
                object2 = ((String)object2).indexOf("/") < 0 ? "" : ((String)object2).substring(((String)object2).indexOf("/") + 1);
                this.myPath = object2;
                if (!this.myPath.startsWith("/")) {
                    this.myPath = "/" + this.myPath;
                }
                this.myEncodedPath = SVNEncodingUtil.uriEncode(this.myPath);
            }
            this.myUserName = ((URL)serializable).getUserInfo();
            this.myPort = ((URL)serializable).getPort();
            boolean bl3 = this.myIsDefaultPort = this.myPort < 0;
            if (this.myPort < 0) {
                Map map = DEFAULT_PORTS;
                synchronized (map) {
                    object2 = (Integer)DEFAULT_PORTS.get(this.myProtocol);
                }
                int n4 = this.myPort = object2 != null ? (Integer)object2 : 0;
            }
        }
        if (this.myEncodedPath.equals("/")) {
            this.myEncodedPath = "";
            this.myPath = "";
        }
        if (this.myHost != null) {
            this.myHost = this.myHost.toLowerCase();
        }
    }

    public String getProtocol() {
        return this.myProtocol;
    }

    public String getHost() {
        return this.myHost;
    }

    public int getPort() {
        return this.myPort;
    }

    public boolean hasPort() {
        return !this.myIsDefaultPort;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getURIEncodedPath() {
        return this.myEncodedPath;
    }

    public String getUserInfo() {
        return this.myUserName;
    }

    public String toString() {
        if (this.myURL == null) {
            this.myURL = SVNURL.composeURL(this.getProtocol(), this.getUserInfo(), this.getHost(), this.myIsDefaultPort ? -1 : this.getPort(), this.getURIEncodedPath());
        }
        return this.myURL;
    }

    public String toDecodedString() {
        return SVNURL.composeURL(this.getProtocol(), this.getUserInfo(), this.getHost(), this.myIsDefaultPort ? -1 : this.getPort(), this.getPath());
    }

    public SVNURL appendPath(String string, boolean bl2) {
        if (string == null || "".equals(string)) {
            return this;
        }
        string = !bl2 ? SVNEncodingUtil.uriEncode(string) : SVNEncodingUtil.autoURIEncode(string);
        String string2 = this.getURIEncodedPath();
        string2 = "".equals(string2) ? "/" + string : SVNPathUtil.append(string2, string);
        String string3 = SVNURL.composeURL(this.getProtocol(), this.getUserInfo(), this.getHost(), this.myIsDefaultPort ? -1 : this.getPort(), string2);
        return SVNURL.parseURIEncoded(string3);
    }

    public SVNURL setPath(String string, boolean bl2) {
        if (string == null || "".equals(string)) {
            string = "/";
        }
        string = !bl2 ? SVNEncodingUtil.uriEncode(string) : SVNEncodingUtil.autoURIEncode(string);
        String string2 = SVNURL.composeURL(this.getProtocol(), this.getUserInfo(), this.getHost(), this.myIsDefaultPort ? -1 : this.getPort(), string);
        return SVNURL.parseURIEncoded(string2);
    }

    public SVNURL removePathTail() {
        String string = SVNPathUtil.removeTail(this.myEncodedPath);
        String string2 = SVNURL.composeURL(this.getProtocol(), this.getUserInfo(), this.getHost(), this.myIsDefaultPort ? -1 : this.getPort(), string);
        return SVNURL.parseURIEncoded(string2);
    }

    public boolean equals(Object object) {
        boolean bl2;
        if (object == null || object.getClass() != SVNURL.class) {
            return false;
        }
        SVNURL sVNURL = (SVNURL)object;
        boolean bl3 = bl2 = this.myProtocol.equals(sVNURL.myProtocol) && this.myPort == sVNURL.myPort && this.myHost.equals(sVNURL.myHost) && this.myPath.equals(sVNURL.myPath) && this.hasPort() == sVNURL.hasPort();
        bl2 = this.myUserName == null ? (bl2 &= sVNURL.myUserName == null) : (bl2 &= this.myUserName.equals(sVNURL.myUserName));
        return bl2;
    }

    public int hashCode() {
        int n2 = this.myProtocol.hashCode() + this.myHost.hashCode() * 27 + this.myPath.hashCode() * 31 + this.myPort * 17;
        if (this.myUserName != null) {
            n2 += 37 * this.myUserName.hashCode();
        }
        return n2;
    }

    private static String composeURL(String string, String string2, String string3, int n2, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("://");
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append("@");
        }
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        if (n2 >= 0) {
            stringBuffer.append(":");
            stringBuffer.append(n2);
        }
        if (string4 != null && !string4.startsWith("/")) {
            string4 = '/' + string4;
        }
        if ("/".equals(string4) && !"file".equals(string)) {
            string4 = "";
        }
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    private static String norlmalizeURLPath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if ("".equals(string3) || ".".equals(string3)) continue;
            if ("..".equals(string3)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL ''{0}'' contains '..' element", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
                continue;
            }
            stringBuffer.append("/");
            stringBuffer.append(string3);
        }
        if (!string2.startsWith("/") && stringBuffer.length() > 0) {
            stringBuffer = stringBuffer.delete(0, 1);
        }
        return stringBuffer.toString();
    }

    private static String getPath(URL uRL) {
        String string = uRL.getPath();
        String string2 = uRL.getRef();
        if (string2 != null) {
            if (string == null) {
                string = "";
            }
            string = string + '#' + string2;
        }
        return string;
    }

    static {
        DEFAULT_PORTS.put("svn", 3690);
        DEFAULT_PORTS.put("svn+ssh", 22);
        DEFAULT_PORTS.put("http", 80);
        DEFAULT_PORTS.put("https", 443);
        DEFAULT_PORTS.put("file", 0);
    }
}

