/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;

public class SVNPropertyValue
implements Serializable {
    private static final long serialVersionUID = 4845L;
    private String myValue;
    private byte[] myData;

    public static SVNPropertyValue create(String string, byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return null;
        }
        if (SVNProperty.isSVNProperty(string)) {
            String string2;
            try {
                string2 = new String(byArray, n2, n3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = new String(byArray, n2, n3);
            }
            return new SVNPropertyValue(string2);
        }
        return new SVNPropertyValue(byArray, n2, n3);
    }

    public static SVNPropertyValue create(String string, byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return SVNPropertyValue.create(string, byArray, 0, byArray.length);
    }

    public static SVNPropertyValue create(String string) {
        if (string == null) {
            return null;
        }
        return new SVNPropertyValue(string);
    }

    public static SVNPropertyValue create(char[] cArray, String string) {
        if (cArray == null) {
            return null;
        }
        return new SVNPropertyValue(cArray, string);
    }

    public static byte[] getPropertyAsBytes(SVNPropertyValue sVNPropertyValue) {
        if (sVNPropertyValue == null) {
            return null;
        }
        if (sVNPropertyValue.isString()) {
            try {
                return sVNPropertyValue.getString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return sVNPropertyValue.getString().getBytes();
            }
        }
        return sVNPropertyValue.getBytes();
    }

    public static String getPropertyAsString(SVNPropertyValue sVNPropertyValue) {
        if (sVNPropertyValue == null) {
            return null;
        }
        if (sVNPropertyValue.isBinary()) {
            try {
                return new String(sVNPropertyValue.getBytes(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(sVNPropertyValue.getBytes());
            }
        }
        return sVNPropertyValue.getString();
    }

    public static char[] getPropertyAsChars(SVNPropertyValue sVNPropertyValue) {
        if (sVNPropertyValue == null) {
            return null;
        }
        if (sVNPropertyValue.isBinary()) {
            return SVNEncodingUtil.getChars(sVNPropertyValue.getBytes(), "UTF-8");
        }
        return sVNPropertyValue.getString().toCharArray();
    }

    public boolean isBinary() {
        return this.myData != null;
    }

    public byte[] getBytes() {
        return this.myData;
    }

    public boolean isString() {
        return this.myValue != null;
    }

    public String getString() {
        return this.myValue;
    }

    public String toString() {
        if (this.isBinary()) {
            return "property is binary";
        }
        return this.getString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof SVNPropertyValue) {
            SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)object;
            if (this.isString()) {
                return this.myValue.equals(SVNPropertyValue.getPropertyAsString(sVNPropertyValue));
            }
            if (this.isBinary()) {
                return Arrays.equals(this.myData, SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue));
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.myValue != null) {
            return this.myValue.hashCode();
        }
        if (this.myData != null) {
            return this.myData.hashCode();
        }
        return super.hashCode();
    }

    private SVNPropertyValue(byte[] byArray, int n2, int n3) {
        this.myData = new byte[n3];
        System.arraycopy(byArray, n2, this.myData, 0, n3);
    }

    private SVNPropertyValue(String string) {
        this.myValue = string;
    }

    private SVNPropertyValue(char[] cArray, String string) {
        this.myData = SVNEncodingUtil.getBytes(cArray, string == null ? "UTF-8" : string);
    }

    public static boolean areEqual(SVNPropertyValue sVNPropertyValue, SVNPropertyValue sVNPropertyValue2) {
        if (sVNPropertyValue == null) {
            return sVNPropertyValue2 == null;
        }
        if (sVNPropertyValue2 == null) {
            return false;
        }
        byte[] byArray = SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue);
        byte[] byArray2 = SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue2);
        return Arrays.equals(byArray, byArray2);
    }

    public void clear() {
        SVNEncodingUtil.clearArray(this.myData);
        this.myValue = null;
    }
}

