/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;

public class SVNProperties
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map myProperties;

    public static SVNProperties wrap(Map map) {
        if (map == null) {
            return new SVNProperties();
        }
        SVNHashMap sVNHashMap = new SVNHashMap();
        for (Object k2 : map.keySet()) {
            if (!(k2 instanceof String)) continue;
            Object v2 = map.get(k2);
            SVNPropertyValue sVNPropertyValue = null;
            if (v2 instanceof String) {
                sVNPropertyValue = SVNPropertyValue.create((String)v2);
            } else if (v2 instanceof byte[]) {
                sVNPropertyValue = SVNPropertyValue.create(k2.toString(), (byte[])v2);
            } else if (v2 instanceof SVNPropertyValue) {
                sVNPropertyValue = (SVNPropertyValue)v2;
            }
            if (sVNPropertyValue == null) continue;
            sVNHashMap.put(k2, sVNPropertyValue);
        }
        return new SVNProperties(sVNHashMap);
    }

    public static SVNProperties unmodifiableProperties(SVNProperties sVNProperties) {
        Map map = sVNProperties.myProperties;
        map = Collections.unmodifiableMap(map);
        return new SVNProperties(map);
    }

    public SVNProperties() {
        this.myProperties = new SVNHashMap();
    }

    public SVNProperties(SVNProperties sVNProperties) {
        this.myProperties = new SVNHashMap(sVNProperties.myProperties);
    }

    private SVNProperties(Map map) {
        this.myProperties = map;
    }

    public Map asMap() {
        if (this.myProperties == null) {
            return Collections.unmodifiableMap(Collections.EMPTY_MAP);
        }
        return Collections.unmodifiableMap(this.myProperties);
    }

    public void put(String string, SVNPropertyValue sVNPropertyValue) {
        this.myProperties.put(string, sVNPropertyValue);
    }

    public void put(String string, String string2) {
        this.myProperties.put(string, SVNPropertyValue.create(string2));
    }

    public void put(String string, char[] cArray, String string2) {
        this.myProperties.put(string, SVNPropertyValue.create(cArray, string2));
    }

    public void put(String string, byte[] byArray) {
        this.myProperties.put(string, SVNPropertyValue.create(string, byArray));
    }

    public String getStringValue(String string) {
        SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)this.myProperties.get(string);
        return sVNPropertyValue == null ? null : sVNPropertyValue.getString();
    }

    public byte[] getBinaryValue(String string) {
        SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)this.myProperties.get(string);
        return sVNPropertyValue == null ? null : sVNPropertyValue.getBytes();
    }

    public SVNPropertyValue getSVNPropertyValue(String string) {
        return (SVNPropertyValue)this.myProperties.get(string);
    }

    public SVNPropertyValue remove(String string) {
        return (SVNPropertyValue)this.myProperties.remove(string);
    }

    public void putAll(SVNProperties sVNProperties) {
        this.myProperties.putAll(sVNProperties.myProperties);
    }

    public boolean isEmpty() {
        return this.myProperties.isEmpty();
    }

    public void clear() {
        this.myProperties.clear();
    }

    public void removeNullValues() {
        Iterator iterator = this.myProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.myProperties.get(string) != null) continue;
            iterator.remove();
        }
    }

    public int size() {
        return this.myProperties.size();
    }

    public boolean containsName(String string) {
        return this.myProperties.containsKey(string);
    }

    public Set nameSet() {
        return this.myProperties.keySet();
    }

    public boolean containsValue(SVNPropertyValue sVNPropertyValue) {
        return this.myProperties.containsValue(sVNPropertyValue);
    }

    public Collection values() {
        return this.myProperties.values();
    }

    public SVNProperties getRegularProperties() {
        SVNProperties sVNProperties = new SVNProperties();
        for (String string : this.nameSet()) {
            if (!SVNProperty.isRegularProperty(string)) continue;
            sVNProperties.put(string, this.getSVNPropertyValue(string));
        }
        return sVNProperties;
    }

    public SVNProperties compareTo(SVNProperties sVNProperties) {
        SVNProperties sVNProperties2 = new SVNProperties();
        if (this.isEmpty()) {
            sVNProperties2.putAll(sVNProperties);
            return sVNProperties2;
        }
        Set set = this.nameSet();
        Set set2 = sVNProperties.nameSet();
        TreeSet treeSet = new TreeSet(set);
        treeSet.removeAll(set2);
        for (String string : treeSet) {
            sVNProperties2.put(string, (byte[])null);
        }
        treeSet = new TreeSet(set2);
        treeSet.removeAll(set);
        for (String string : treeSet) {
            sVNProperties2.put(string, sVNProperties.getSVNPropertyValue(string));
        }
        treeSet = new TreeSet(set2);
        treeSet.retainAll(set);
        for (String string : treeSet) {
            SVNPropertyValue sVNPropertyValue;
            SVNPropertyValue sVNPropertyValue2 = this.getSVNPropertyValue(string);
            if (SVNPropertyValue.areEqual(sVNPropertyValue2, sVNPropertyValue = sVNProperties.getSVNPropertyValue(string))) continue;
            sVNProperties2.put(string, sVNPropertyValue);
        }
        return sVNProperties2;
    }

    public int hashCode() {
        return 31 + (this.myProperties == null ? 0 : this.myProperties.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SVNProperties sVNProperties = (SVNProperties)object;
        return !(this.myProperties == null ? sVNProperties.myProperties != null : !this.myProperties.equals(sVNProperties.myProperties));
    }

    public Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        SVNProperties sVNProperties = new SVNProperties();
        sVNProperties.putAll(this);
        return sVNProperties;
    }

    public String toString() {
        if (this.myProperties != null) {
            return this.myProperties.toString();
        }
        return "";
    }

    public void dispose() {
        if (this.myProperties != null) {
            for (SVNPropertyValue sVNPropertyValue : this.myProperties.values()) {
                sVNPropertyValue.clear();
            }
        }
    }
}

