/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class SVNNodeKind
implements Serializable,
Comparable {
    private static final long serialVersionUID = 5851L;
    public static final SVNNodeKind NONE = new SVNNodeKind(2);
    public static final SVNNodeKind FILE = new SVNNodeKind(1);
    public static final SVNNodeKind DIR = new SVNNodeKind(0);
    public static final SVNNodeKind UNKNOWN = new SVNNodeKind(3);
    private int myID;

    private SVNNodeKind(int n2) {
        this.myID = n2;
    }

    public static SVNNodeKind getNodeKindById(int n2) {
        if (n2 == FILE.getID()) {
            return FILE;
        }
        if (n2 == DIR.getID()) {
            return DIR;
        }
        if (n2 == NONE.getID()) {
            return NONE;
        }
        return UNKNOWN;
    }

    public static SVNNodeKind parseKind(String string) {
        if ("file".equals(string)) {
            return FILE;
        }
        if ("dir".equals(string)) {
            return DIR;
        }
        if ("none".equals(string) || string == null) {
            return NONE;
        }
        return UNKNOWN;
    }

    public String toString() {
        if (this == NONE) {
            return "none";
        }
        if (this == FILE) {
            return "file";
        }
        if (this == DIR) {
            return "dir";
        }
        return "unknown";
    }

    public int compareTo(Object object) {
        if (object == null || object.getClass() != SVNNodeKind.class) {
            return -1;
        }
        int n2 = ((SVNNodeKind)object).myID;
        return this.myID > n2 ? 1 : (this.myID < n2 ? -1 : 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeInt(this.myID);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.myID = objectInputStream.readInt();
    }

    private Object readResolve() {
        return SVNNodeKind.fromID(this.myID);
    }

    private static SVNNodeKind fromID(int n2) {
        if (SVNNodeKind.DIR.myID == n2) {
            return DIR;
        }
        if (SVNNodeKind.FILE.myID == n2) {
            return FILE;
        }
        if (SVNNodeKind.NONE.myID == n2) {
            return NONE;
        }
        return UNKNOWN;
    }

    public int getID() {
        return this.myID;
    }
}

