/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeRangeList {
    public static String MERGE_INFO_NONINHERITABLE_STRING = "*";
    private SVNMergeRange[] myRanges;

    public SVNMergeRangeList(long l2, long l3, boolean bl2) {
        this(new SVNMergeRange(l2, l3, bl2));
    }

    public SVNMergeRangeList(SVNMergeRange sVNMergeRange) {
        this(new SVNMergeRange[]{sVNMergeRange});
    }

    public SVNMergeRangeList(SVNMergeRange[] sVNMergeRangeArray) {
        this.myRanges = sVNMergeRangeArray == null ? new SVNMergeRange[]{} : sVNMergeRangeArray;
    }

    public void setRanges(SVNMergeRange[] sVNMergeRangeArray) {
        this.myRanges = sVNMergeRangeArray;
    }

    public void setInheritable(boolean bl2) {
        if (this.myRanges != null) {
            for (int i2 = 0; i2 < this.myRanges.length; ++i2) {
                this.myRanges[i2].setInheritable(bl2);
            }
        }
    }

    public SVNMergeRange[] getRanges() {
        return this.myRanges;
    }

    public List getRangesAsList() {
        ArrayList<SVNMergeRange> arrayList = new ArrayList<SVNMergeRange>();
        for (int i2 = 0; i2 < this.myRanges.length; ++i2) {
            SVNMergeRange sVNMergeRange = this.myRanges[i2];
            arrayList.add(sVNMergeRange);
        }
        return arrayList;
    }

    public void pushRange(long l2, long l3, boolean bl2) {
        SVNMergeRange[] sVNMergeRangeArray = new SVNMergeRange[this.myRanges.length + 1];
        sVNMergeRangeArray[sVNMergeRangeArray.length - 1] = new SVNMergeRange(l2, l3, bl2);
        System.arraycopy(this.myRanges, 0, sVNMergeRangeArray, 0, this.myRanges.length);
        this.myRanges = sVNMergeRangeArray;
    }

    public int getSize() {
        return this.myRanges.length;
    }

    public boolean isEmpty() {
        return this.myRanges.length == 0;
    }

    public SVNMergeRangeList dup() {
        SVNMergeRange[] sVNMergeRangeArray = new SVNMergeRange[this.myRanges.length];
        for (int i2 = 0; i2 < this.myRanges.length; ++i2) {
            SVNMergeRange sVNMergeRange = this.myRanges[i2];
            sVNMergeRangeArray[i2] = sVNMergeRange.dup();
        }
        return new SVNMergeRangeList(sVNMergeRangeArray);
    }

    public SVNMergeRangeList merge(SVNMergeRangeList sVNMergeRangeList) {
        SVNMergeRange sVNMergeRange;
        int n2 = 0;
        int n3 = 0;
        SVNMergeRange sVNMergeRange2 = null;
        LinkedList linkedList = new LinkedList();
        while (n2 < this.myRanges.length && n3 < sVNMergeRangeList.myRanges.length) {
            sVNMergeRange = this.myRanges[n2];
            SVNMergeRange sVNMergeRange3 = sVNMergeRangeList.myRanges[n3];
            int n4 = sVNMergeRange.compareTo(sVNMergeRange3);
            if (n4 == 0) {
                if (sVNMergeRange.isInheritable() || sVNMergeRange3.isInheritable()) {
                    sVNMergeRange.setInheritable(true);
                }
                sVNMergeRange2 = this.combineWithLastRange(linkedList, sVNMergeRange2, sVNMergeRange, true, false);
                ++n2;
                ++n3;
                continue;
            }
            if (n4 < 0) {
                sVNMergeRange2 = this.combineWithLastRange(linkedList, sVNMergeRange2, sVNMergeRange, true, false);
                ++n2;
                continue;
            }
            sVNMergeRange2 = this.combineWithLastRange(linkedList, sVNMergeRange2, sVNMergeRange3, true, false);
            ++n3;
        }
        SVNErrorManager.assertionFailure(n2 >= this.myRanges.length || n3 >= sVNMergeRangeList.myRanges.length, "expected to reach the end of at least one range list", SVNLogType.DEFAULT);
        while (n2 < this.myRanges.length) {
            sVNMergeRange = this.myRanges[n2];
            sVNMergeRange2 = this.combineWithLastRange(linkedList, sVNMergeRange2, sVNMergeRange, true, false);
            ++n2;
        }
        while (n3 < sVNMergeRangeList.myRanges.length) {
            sVNMergeRange = sVNMergeRangeList.myRanges[n3];
            sVNMergeRange2 = this.combineWithLastRange(linkedList, sVNMergeRange2, sVNMergeRange, true, false);
            ++n3;
        }
        return SVNMergeRangeList.fromCollection(linkedList);
    }

    public String toString() {
        String string = "";
        for (int i2 = 0; i2 < this.myRanges.length; ++i2) {
            SVNMergeRange sVNMergeRange = this.myRanges[i2];
            string = string + sVNMergeRange.toString();
            if (i2 >= this.myRanges.length - 1) continue;
            string = string + ',';
        }
        return string;
    }

    public SVNMergeRangeList diff(SVNMergeRangeList sVNMergeRangeList, boolean bl2) {
        return this.removeOrIntersect(sVNMergeRangeList, true, bl2);
    }

    public SVNMergeRangeList intersect(SVNMergeRangeList sVNMergeRangeList, boolean bl2) {
        return this.removeOrIntersect(sVNMergeRangeList, false, bl2);
    }

    public boolean includes(long l2) {
        for (int i2 = 0; i2 < this.myRanges.length; ++i2) {
            SVNMergeRange sVNMergeRange = this.myRanges[i2];
            if (l2 <= sVNMergeRange.getStartRevision() || l2 > sVNMergeRange.getEndRevision()) continue;
            return true;
        }
        return false;
    }

    public SVNMergeRangeList reverse() {
        if (this.myRanges.length != 0) {
            for (int i2 = 0; i2 < this.myRanges.length / 2; ++i2) {
                int n2 = this.myRanges.length - i2 - 1;
                SVNMergeRange sVNMergeRange = this.myRanges[i2];
                this.myRanges[i2] = this.myRanges[n2].swapEndPoints();
                this.myRanges[n2] = sVNMergeRange.swapEndPoints();
            }
            if (this.myRanges.length % 2 == 1) {
                this.myRanges[this.myRanges.length / 2].swapEndPoints();
            }
        }
        return this;
    }

    public SVNMergeRangeList getInheritableRangeList(long l2, long l3) {
        return this.getInheritableRangeList(l2, l3, true);
    }

    public SVNMergeRangeList getInheritableRangeList(long l2, long l3, boolean bl2) {
        LinkedList<SVNMergeRange> linkedList = new LinkedList<SVNMergeRange>();
        if (this.myRanges.length > 0) {
            if (!SVNRevision.isValidRevisionNumber(l2) || !SVNRevision.isValidRevisionNumber(l3) || l3 < l2) {
                for (int i2 = 0; i2 < this.myRanges.length; ++i2) {
                    SVNMergeRange sVNMergeRange = this.myRanges[i2];
                    if (sVNMergeRange.isInheritable() != bl2) continue;
                    SVNMergeRange sVNMergeRange2 = new SVNMergeRange(sVNMergeRange.getStartRevision(), sVNMergeRange.getEndRevision(), true);
                    linkedList.add(sVNMergeRange2);
                }
            } else {
                SVNMergeRange sVNMergeRange = new SVNMergeRange(l2, l3, false);
                SVNMergeRangeList sVNMergeRangeList = new SVNMergeRangeList(sVNMergeRange);
                return this.diff(sVNMergeRangeList, true);
            }
        }
        SVNMergeRange[] sVNMergeRangeArray = linkedList.toArray(new SVNMergeRange[linkedList.size()]);
        return new SVNMergeRangeList(sVNMergeRangeArray);
    }

    public static SVNMergeRangeList fromCollection(Collection collection) {
        return new SVNMergeRangeList(collection.toArray(new SVNMergeRange[collection.size()]));
    }

    private SVNMergeRangeList removeOrIntersect(SVNMergeRangeList sVNMergeRangeList, boolean bl2, boolean bl3) {
        SVNMergeRange sVNMergeRange;
        LinkedList<SVNMergeRange> linkedList = new LinkedList<SVNMergeRange>();
        SVNMergeRange sVNMergeRange2 = null;
        SVNMergeRange sVNMergeRange3 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        SVNMergeRange sVNMergeRange4 = new SVNMergeRange(-1L, -1L, false);
        while (n2 < this.myRanges.length && n3 < sVNMergeRangeList.myRanges.length) {
            SVNMergeRange sVNMergeRange5;
            sVNMergeRange = sVNMergeRangeList.myRanges[n3];
            if (n2 != n4) {
                sVNMergeRange5 = this.myRanges[n2];
                sVNMergeRange4 = sVNMergeRange3 = sVNMergeRange5.dup();
                n4 = n2;
            }
            if (sVNMergeRange.contains(sVNMergeRange3, bl3)) {
                if (!bl2) {
                    sVNMergeRange2 = this.combineWithLastRange(linkedList, sVNMergeRange2, sVNMergeRange3, true, bl3);
                }
                ++n2;
                if (sVNMergeRange3.getStartRevision() != sVNMergeRange.getStartRevision() || sVNMergeRange3.getEndRevision() != sVNMergeRange.getEndRevision()) continue;
                ++n3;
                continue;
            }
            if (sVNMergeRange.intersects(sVNMergeRange3, bl3)) {
                if (sVNMergeRange3.getStartRevision() < sVNMergeRange.getStartRevision()) {
                    sVNMergeRange5 = null;
                    sVNMergeRange5 = bl2 ? new SVNMergeRange(sVNMergeRange3.getStartRevision(), sVNMergeRange.getStartRevision(), sVNMergeRange3.isInheritable()) : new SVNMergeRange(sVNMergeRange.getStartRevision(), Math.min(sVNMergeRange3.getEndRevision(), sVNMergeRange.getEndRevision()), sVNMergeRange3.isInheritable());
                    sVNMergeRange2 = this.combineWithLastRange(linkedList, sVNMergeRange2, sVNMergeRange5, true, bl3);
                }
                if (sVNMergeRange3.getEndRevision() > sVNMergeRange.getEndRevision()) {
                    if (!bl2) {
                        sVNMergeRange5 = new SVNMergeRange(Math.max(sVNMergeRange3.getStartRevision(), sVNMergeRange.getStartRevision()), sVNMergeRange.getEndRevision(), sVNMergeRange3.isInheritable());
                        sVNMergeRange2 = this.combineWithLastRange(linkedList, sVNMergeRange2, sVNMergeRange5, true, bl3);
                    }
                    sVNMergeRange4.setStartRevision(sVNMergeRange.getEndRevision());
                    sVNMergeRange4.setEndRevision(sVNMergeRange3.getEndRevision());
                    continue;
                }
                ++n2;
                continue;
            }
            if (sVNMergeRange.compareTo(sVNMergeRange3) < 0) {
                ++n3;
                continue;
            }
            if (bl2 && (sVNMergeRange2 == null || !sVNMergeRange2.canCombine(sVNMergeRange3, bl3))) {
                sVNMergeRange2 = sVNMergeRange3.dup();
                linkedList.add(sVNMergeRange2);
            }
            ++n2;
        }
        if (bl2) {
            if (n2 == n4 && n2 < this.myRanges.length) {
                sVNMergeRange2 = this.combineWithLastRange(linkedList, sVNMergeRange2, sVNMergeRange4, true, bl3);
                ++n2;
            }
            while (n2 < this.myRanges.length) {
                sVNMergeRange = this.myRanges[n2];
                sVNMergeRange2 = this.combineWithLastRange(linkedList, sVNMergeRange2, sVNMergeRange, true, bl3);
                ++n2;
            }
        }
        return SVNMergeRangeList.fromCollection(linkedList);
    }

    public SVNMergeRangeList remove(SVNMergeRangeList sVNMergeRangeList, boolean bl2) {
        return this.removeOrIntersect(sVNMergeRangeList, true, bl2);
    }

    private SVNMergeRange combineWithLastRange(Collection collection, SVNMergeRange sVNMergeRange, SVNMergeRange sVNMergeRange2, boolean bl2, boolean bl3) {
        SVNMergeRange sVNMergeRange3 = null;
        SVNMergeRange sVNMergeRange4 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        if (sVNMergeRange != null) {
            if (sVNMergeRange.getStartRevision() <= sVNMergeRange2.getEndRevision() && sVNMergeRange2.getStartRevision() <= sVNMergeRange.getEndRevision()) {
                bl4 = true;
            }
            if (sVNMergeRange.isInheritable() == sVNMergeRange2.isInheritable()) {
                bl5 = true;
            }
        }
        if (sVNMergeRange == null || !bl4 || !bl5 && bl3) {
            sVNMergeRange3 = bl2 ? sVNMergeRange2.dup() : sVNMergeRange2;
        } else {
            long l2 = -1L;
            if (bl5) {
                sVNMergeRange.setStartRevision(Math.min(sVNMergeRange.getStartRevision(), sVNMergeRange2.getStartRevision()));
                sVNMergeRange.setEndRevision(Math.max(sVNMergeRange.getEndRevision(), sVNMergeRange2.getEndRevision()));
                sVNMergeRange.setInheritable(sVNMergeRange.isInheritable() || sVNMergeRange2.isInheritable());
            } else if (sVNMergeRange.getStartRevision() == sVNMergeRange2.getStartRevision()) {
                if (sVNMergeRange.getEndRevision() == sVNMergeRange2.getEndRevision()) {
                    sVNMergeRange.setInheritable(true);
                } else if (sVNMergeRange.getEndRevision() > sVNMergeRange2.getEndRevision()) {
                    if (!sVNMergeRange.isInheritable()) {
                        l2 = sVNMergeRange.getEndRevision();
                        sVNMergeRange.setEndRevision(sVNMergeRange2.getEndRevision());
                        sVNMergeRange.setInheritable(true);
                        sVNMergeRange3 = bl2 ? sVNMergeRange2.dup() : sVNMergeRange2;
                        sVNMergeRange3.setEndRevision(l2);
                        sVNMergeRange = sVNMergeRange3;
                    }
                } else if (sVNMergeRange2.isInheritable()) {
                    sVNMergeRange.setInheritable(true);
                    sVNMergeRange.setEndRevision(sVNMergeRange2.getEndRevision());
                } else {
                    sVNMergeRange3 = bl2 ? sVNMergeRange2.dup() : sVNMergeRange2;
                    sVNMergeRange3.setStartRevision(sVNMergeRange.getEndRevision());
                }
            } else if (sVNMergeRange.getEndRevision() == sVNMergeRange2.getEndRevision()) {
                if (sVNMergeRange.getStartRevision() < sVNMergeRange2.getStartRevision()) {
                    if (!sVNMergeRange.isInheritable()) {
                        sVNMergeRange.setEndRevision(sVNMergeRange2.getStartRevision());
                        sVNMergeRange3 = bl2 ? sVNMergeRange2.dup() : sVNMergeRange2;
                        sVNMergeRange = sVNMergeRange3;
                    }
                } else {
                    sVNMergeRange.setStartRevision(sVNMergeRange2.getStartRevision());
                    sVNMergeRange.setEndRevision(sVNMergeRange2.getEndRevision());
                    sVNMergeRange.setInheritable(sVNMergeRange2.isInheritable());
                    sVNMergeRange3 = bl2 ? sVNMergeRange2.dup() : sVNMergeRange2;
                    sVNMergeRange3.setStartRevision(sVNMergeRange.getEndRevision());
                    sVNMergeRange3.setInheritable(true);
                }
            } else if (sVNMergeRange.getStartRevision() < sVNMergeRange2.getStartRevision()) {
                if (sVNMergeRange.getEndRevision() <= sVNMergeRange2.getEndRevision() || !sVNMergeRange.isInheritable()) {
                    l2 = sVNMergeRange.getEndRevision();
                    if (!sVNMergeRange.isInheritable()) {
                        sVNMergeRange.setEndRevision(sVNMergeRange2.getStartRevision());
                    } else {
                        sVNMergeRange2.setStartRevision(sVNMergeRange.getEndRevision());
                    }
                    sVNMergeRange3 = bl2 ? sVNMergeRange2.dup() : sVNMergeRange2;
                    if (l2 > sVNMergeRange2.getEndRevision()) {
                        sVNMergeRange4 = new SVNMergeRange(sVNMergeRange2.getEndRevision(), l2, sVNMergeRange.isInheritable());
                    }
                    sVNMergeRange2.setInheritable(true);
                }
            } else if (sVNMergeRange.getEndRevision() < sVNMergeRange2.getEndRevision()) {
                if (sVNMergeRange4 == null) {
                    sVNMergeRange4 = new SVNMergeRange(sVNMergeRange.getEndRevision(), sVNMergeRange2.getEndRevision(), sVNMergeRange2.isInheritable());
                }
                l2 = sVNMergeRange.getStartRevision();
                sVNMergeRange.setStartRevision(sVNMergeRange2.getStartRevision());
                sVNMergeRange.setEndRevision(l2);
                sVNMergeRange.setInheritable(sVNMergeRange2.isInheritable());
                sVNMergeRange2.setStartRevision(l2);
                sVNMergeRange2.setEndRevision(sVNMergeRange4.getStartRevision());
                sVNMergeRange2.setInheritable(true);
            } else {
                if (sVNMergeRange4 == null) {
                    sVNMergeRange4 = new SVNMergeRange(sVNMergeRange2.getEndRevision(), sVNMergeRange.getEndRevision(), sVNMergeRange.isInheritable());
                }
                l2 = sVNMergeRange.getStartRevision();
                sVNMergeRange.setStartRevision(sVNMergeRange2.getStartRevision());
                sVNMergeRange.setEndRevision(l2);
                sVNMergeRange.setInheritable(sVNMergeRange2.isInheritable());
                sVNMergeRange2.setStartRevision(l2);
                sVNMergeRange2.setEndRevision(sVNMergeRange4.getStartRevision());
                sVNMergeRange2.setInheritable(true);
            }
        }
        if (sVNMergeRange3 != null) {
            collection.add(sVNMergeRange3);
            sVNMergeRange = sVNMergeRange3;
        }
        if (sVNMergeRange4 != null) {
            collection.add(sVNMergeRange4);
            sVNMergeRange = sVNMergeRange4;
        }
        return sVNMergeRange;
    }

    public SVNMergeRangeList mergeRevision(long l2) {
        if (this.getSize() > 0 && this.getRanges()[this.getSize() - 1].getEndRevision() == l2 - 1L) {
            this.getRanges()[this.getSize() - 1].setEndRevision(l2);
            return this;
        }
        this.pushRange(l2 - 1L, l2, true);
        return this;
    }
}

