/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import org.tmatesoft.svn.core.SVNMergeRangeList;

public class SVNMergeRange
implements Comparable {
    private long myStartRevision;
    private long myEndRevision;
    private boolean myIsInheritable;

    public SVNMergeRange(long l2, long l3, boolean bl2) {
        this.myStartRevision = l2;
        this.myEndRevision = l3;
        this.myIsInheritable = bl2;
    }

    public long getEndRevision() {
        return this.myEndRevision;
    }

    public long getStartRevision() {
        return this.myStartRevision;
    }

    public void setEndRevision(long l2) {
        this.myEndRevision = l2;
    }

    public void setStartRevision(long l2) {
        this.myStartRevision = l2;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (object == null || object.getClass() != SVNMergeRange.class) {
            return 1;
        }
        SVNMergeRange sVNMergeRange = (SVNMergeRange)object;
        if (sVNMergeRange.myStartRevision == this.myStartRevision && sVNMergeRange.myEndRevision == this.myEndRevision) {
            return 0;
        }
        if (sVNMergeRange.myStartRevision == this.myStartRevision) {
            return this.myEndRevision < sVNMergeRange.myEndRevision ? -1 : 1;
        }
        return this.myStartRevision < sVNMergeRange.myStartRevision ? -1 : 1;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public SVNMergeRange combine(SVNMergeRange sVNMergeRange, boolean bl2) {
        if (this.canCombine(sVNMergeRange, bl2)) {
            this.myStartRevision = Math.min(this.myStartRevision, sVNMergeRange.getStartRevision());
            this.myEndRevision = Math.max(this.myEndRevision, sVNMergeRange.getEndRevision());
            this.myIsInheritable = this.myIsInheritable || sVNMergeRange.myIsInheritable;
            return this;
        }
        return sVNMergeRange;
    }

    public boolean canCombine(SVNMergeRange sVNMergeRange, boolean bl2) {
        return sVNMergeRange != null && this.myStartRevision <= sVNMergeRange.getEndRevision() && sVNMergeRange.getStartRevision() <= this.myEndRevision && (!bl2 || bl2 && this.myIsInheritable == sVNMergeRange.myIsInheritable);
    }

    public boolean contains(SVNMergeRange sVNMergeRange, boolean bl2) {
        return sVNMergeRange != null && this.myStartRevision <= sVNMergeRange.myStartRevision && sVNMergeRange.myEndRevision <= this.myEndRevision && (!bl2 || !this.myIsInheritable == !sVNMergeRange.myIsInheritable);
    }

    public boolean intersects(SVNMergeRange sVNMergeRange, boolean bl2) {
        return sVNMergeRange != null && this.myStartRevision + 1L <= sVNMergeRange.myEndRevision && sVNMergeRange.myStartRevision + 1L <= this.myEndRevision && (!bl2 || !this.myIsInheritable == !sVNMergeRange.myIsInheritable);
    }

    public SVNMergeRange swapEndPoints() {
        long l2 = this.myStartRevision;
        this.myStartRevision = this.myEndRevision;
        this.myEndRevision = l2;
        return this;
    }

    public boolean isInheritable() {
        return this.myIsInheritable;
    }

    public void setInheritable(boolean bl2) {
        this.myIsInheritable = bl2;
    }

    public SVNMergeRange dup() {
        return new SVNMergeRange(this.myStartRevision, this.myEndRevision, this.myIsInheritable);
    }

    public String toString() {
        String string = "";
        string = this.myStartRevision == this.myEndRevision - 1L ? string + String.valueOf(this.myEndRevision) : string + String.valueOf(this.myStartRevision + 1L) + "-" + String.valueOf(this.myEndRevision);
        if (!this.isInheritable()) {
            string = string + SVNMergeRangeList.MERGE_INFO_NONINHERITABLE_STRING;
        }
        return string;
    }
}

