/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;

public class SVNLogEntry
implements Serializable {
    private static final long serialVersionUID = 4845L;
    public static SVNLogEntry EMPTY_ENTRY = new SVNLogEntry(Collections.EMPTY_MAP, -1L, null, false);
    private long myRevision;
    private Map myChangedPaths;
    private SVNProperties myRevisionProperties;
    private boolean myHasChildren;
    private boolean myIsSubtractiveMerge;
    private boolean myIsNonInheritable;

    public SVNLogEntry(Map map, long l2, String string, Date date, String string2) {
        this.myRevision = l2;
        this.myRevisionProperties = new SVNProperties();
        this.myChangedPaths = map;
        if (string != null) {
            this.myRevisionProperties.put("svn:author", string);
        }
        if (date != null) {
            this.myRevisionProperties.put("svn:date", SVNDate.formatDate(date));
        }
        if (string2 != null) {
            this.myRevisionProperties.put("svn:log", string2);
        }
    }

    public SVNLogEntry(Map map, long l2, SVNProperties sVNProperties, boolean bl2) {
        this.myRevision = l2;
        this.myChangedPaths = map;
        this.myRevisionProperties = sVNProperties != null ? sVNProperties : new SVNProperties();
        this.myHasChildren = bl2;
    }

    public void setHasChildren(boolean bl2) {
        this.myHasChildren = bl2;
    }

    public Map getChangedPaths() {
        return this.myChangedPaths;
    }

    public String getAuthor() {
        return this.myRevisionProperties.getStringValue("svn:author");
    }

    public Date getDate() {
        String string = this.myRevisionProperties.getStringValue("svn:date");
        return string == null ? null : SVNDate.parseDate(string);
    }

    public String getMessage() {
        return this.myRevisionProperties.getStringValue("svn:log");
    }

    public SVNProperties getRevisionProperties() {
        return this.myRevisionProperties;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (int)(this.myRevision ^ this.myRevision >>> 32);
        n3 = 31 * n3 + (this.myChangedPaths == null ? 0 : this.myChangedPaths.hashCode());
        n3 = 31 * n3 + (this.myRevisionProperties == null ? 0 : this.myRevisionProperties.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SVNLogEntry sVNLogEntry = (SVNLogEntry)object;
        return this.myRevision == sVNLogEntry.myRevision && SVNLogEntry.compare(this.myRevisionProperties, sVNLogEntry.myRevisionProperties) && SVNLogEntry.compare(this.myChangedPaths, sVNLogEntry.myChangedPaths);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.myRevision);
        for (Object object : this.myRevisionProperties.nameSet()) {
            SVNPropertyValue sVNPropertyValue = this.myRevisionProperties.getSVNPropertyValue((String)object);
            stringBuffer.append('\n');
            stringBuffer.append((String)object);
            stringBuffer.append('=');
            stringBuffer.append(sVNPropertyValue);
        }
        if (this.myChangedPaths != null && !this.myChangedPaths.isEmpty()) {
            Iterator<Object> iterator = this.myChangedPaths.values().iterator();
            while (iterator.hasNext()) {
                Object object;
                stringBuffer.append('\n');
                object = (SVNLogEntryPath)iterator.next();
                stringBuffer.append(((SVNLogEntryPath)object).toString());
            }
        }
        return stringBuffer.toString();
    }

    public boolean hasChildren() {
        return this.myHasChildren;
    }

    static boolean compare(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public void setSubtractiveMerge(boolean bl2) {
        this.myIsSubtractiveMerge = bl2;
    }

    public boolean isSubtractiveMerge() {
        return this.myIsSubtractiveMerge;
    }

    public void setNonInheriable(boolean bl2) {
        this.myIsNonInheritable = bl2;
    }

    public boolean isNonInheritable() {
        return this.myIsNonInheritable;
    }
}

