/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;

public class SVNException
extends Exception {
    private static final long serialVersionUID = 4845L;
    private SVNErrorMessage myErrorMessage;

    public SVNException(SVNErrorMessage sVNErrorMessage) {
        this(sVNErrorMessage, sVNErrorMessage.getCause());
    }

    public SVNException(SVNErrorMessage sVNErrorMessage, Throwable throwable) {
        super(throwable != null ? throwable : sVNErrorMessage.getCause());
        if (throwable == null) {
            throwable = sVNErrorMessage.getCause();
        }
        if (throwable instanceof SVNException) {
            SVNErrorMessage sVNErrorMessage2 = ((SVNException)throwable).getErrorMessage();
            SVNErrorMessage sVNErrorMessage3 = sVNErrorMessage;
            while (sVNErrorMessage3.hasChildErrorMessage()) {
                sVNErrorMessage3 = sVNErrorMessage3.getChildErrorMessage();
            }
            if (sVNErrorMessage3 != sVNErrorMessage2) {
                sVNErrorMessage3.setChildErrorMessage(sVNErrorMessage2);
            }
        }
        this.myErrorMessage = sVNErrorMessage;
        if (this.getCause() == null && sVNErrorMessage != null) {
            sVNErrorMessage.initCause(this);
        }
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    @Override
    public String getMessage() {
        SVNErrorMessage sVNErrorMessage = this.getErrorMessage();
        if (sVNErrorMessage != null) {
            return sVNErrorMessage.getFullMessage();
        }
        return super.getMessage();
    }

    public boolean isEnoent() {
        SVNErrorCode sVNErrorCode = this.getErrorMessage().getErrorCode();
        return sVNErrorCode == SVNErrorCode.ENTRY_NOT_FOUND || sVNErrorCode == SVNErrorCode.FS_NOT_FOUND || sVNErrorCode == SVNErrorCode.FS_NOT_OPEN || sVNErrorCode == SVNErrorCode.FS_NOT_FILE;
    }
}

