/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashSet;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.wc.SVNBasicClient;

public class SVNErrorMessage
implements Serializable {
    private static final long serialVersionUID = 4845L;
    public static final int TYPE_ERROR = 0;
    public static final int TYPE_WARNING = 1;
    private Object[] myObjects;
    private String myMessage;
    private SVNErrorCode myErrorCode;
    private int myType;
    private SVNErrorMessage myChildErrorMessage;
    private Throwable myThrowable;
    private boolean dontShowErrorCode;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    public static SVNErrorMessage UNKNOWN_ERROR_MESSAGE = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);

    public static SVNErrorMessage create(SVNErrorCode sVNErrorCode) {
        return SVNErrorMessage.create(sVNErrorCode, "", 0);
    }

    public static SVNErrorMessage create(SVNErrorCode sVNErrorCode, String string) {
        return SVNErrorMessage.create(sVNErrorCode, string, 0);
    }

    public static SVNErrorMessage create(SVNErrorCode sVNErrorCode, Throwable throwable) {
        if (throwable != null) {
            return new SVNErrorMessage(sVNErrorCode, throwable.getMessage(), new Object[0], throwable, 0);
        }
        return SVNErrorMessage.create(sVNErrorCode);
    }

    public static SVNErrorMessage create(SVNErrorCode sVNErrorCode, String string, Object object) {
        return SVNErrorMessage.create(sVNErrorCode, string, object, 0);
    }

    public static SVNErrorMessage create(SVNErrorCode sVNErrorCode, String string, Object ... objectArray) {
        return SVNErrorMessage.create(sVNErrorCode, string, objectArray, 0);
    }

    public static SVNErrorMessage create(SVNErrorCode sVNErrorCode, String string, int n2) {
        return SVNErrorMessage.create(sVNErrorCode, string, null, n2, null);
    }

    public static SVNErrorMessage create(SVNErrorCode sVNErrorCode, String string, Object object, int n2) {
        Object[] objectArray;
        SVNErrorCode sVNErrorCode2 = sVNErrorCode == null ? SVNErrorCode.BASE : sVNErrorCode;
        String string2 = string == null ? "" : string;
        if (object == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "NULL";
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = object;
        }
        return new SVNErrorMessage(sVNErrorCode2, string2, objectArray, null, n2);
    }

    public static SVNErrorMessage create(SVNErrorCode sVNErrorCode, String string, Object[] objectArray, int n2) {
        return SVNErrorMessage.create(sVNErrorCode, string, objectArray, n2, null);
    }

    public static SVNErrorMessage create(SVNErrorCode sVNErrorCode, String string, Object[] objectArray, int n2, Throwable throwable) {
        return new SVNErrorMessage(sVNErrorCode == null ? SVNErrorCode.BASE : sVNErrorCode, string == null ? "" : string, objectArray == null ? EMPTY_ARRAY : objectArray, throwable, n2);
    }

    protected SVNErrorMessage(SVNErrorCode sVNErrorCode, String string, Object[] objectArray, Throwable throwable, int n2) {
        this.myErrorCode = sVNErrorCode;
        if (string != null && string.startsWith("svn: ")) {
            string = string.substring("svn: ".length());
        }
        this.myMessage = string;
        this.myObjects = objectArray;
        this.myType = n2;
        this.myThrowable = throwable;
    }

    public int getType() {
        return this.myType;
    }

    public SVNErrorCode getErrorCode() {
        return this.myErrorCode;
    }

    public String getMessage() {
        return this.toString();
    }

    public String getFullMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (SVNErrorMessage sVNErrorMessage = this; sVNErrorMessage != null; sVNErrorMessage = sVNErrorMessage.getChildErrorMessage()) {
            stringBuffer.append(sVNErrorMessage.getMessage());
            if (!sVNErrorMessage.hasChildErrorMessage()) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String getMessageTemplate() {
        return this.myMessage;
    }

    public Object[] getRelatedObjects() {
        return this.myObjects;
    }

    public SVNErrorMessage getChildErrorMessage() {
        return this.myChildErrorMessage;
    }

    public boolean hasChildErrorMessage() {
        return this.myChildErrorMessage != null;
    }

    public Throwable getCause() {
        return this.myThrowable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getType() == 1 && this.getErrorCode() == SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED) {
            stringBuffer.append("Warning: ");
        } else if (this.getType() == 1) {
            stringBuffer.append("svn: warning: ");
            if (this.isErrorCodeShouldShown()) {
                stringBuffer.append("W").append(this.myErrorCode.getCode()).append(": ");
            }
        } else {
            stringBuffer.append("svn: ");
            if (this.isErrorCodeShouldShown()) {
                stringBuffer.append("E").append(this.myErrorCode.getCode()).append(": ");
            }
        }
        if ("".equals(this.myMessage)) {
            stringBuffer.append(this.myErrorCode.getDescription());
        } else {
            stringBuffer.append(this.myObjects.length > 0 ? MessageFormat.format(this.myMessage, this.myObjects) : this.myMessage);
        }
        return stringBuffer.toString();
    }

    public boolean isErrorCodeShouldShown() {
        return !this.dontShowErrorCode && SVNBasicClient.isWC17Supported() && this.getErrorCode() != SVNErrorCode.EXTERNAL_PROGRAM;
    }

    public void setChildErrorMessage(SVNErrorMessage sVNErrorMessage) {
        if (this == sVNErrorMessage) {
            return;
        }
        SVNErrorMessage sVNErrorMessage2 = this;
        for (SVNErrorMessage sVNErrorMessage3 = sVNErrorMessage; sVNErrorMessage3 != null; sVNErrorMessage3 = sVNErrorMessage3.getChildErrorMessage()) {
            if (this == sVNErrorMessage3) {
                sVNErrorMessage2.setChildErrorMessage(null);
                break;
            }
            sVNErrorMessage2 = sVNErrorMessage3;
        }
        this.myChildErrorMessage = sVNErrorMessage;
    }

    public SVNErrorMessage wrap(String string) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(this.getErrorCode(), string);
        sVNErrorMessage.setChildErrorMessage(this);
        return sVNErrorMessage;
    }

    public SVNErrorMessage wrap(String string, Object object) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(this.getErrorCode(), string, object);
        sVNErrorMessage.setChildErrorMessage(this);
        return sVNErrorMessage;
    }

    public SVNErrorMessage wrap(String string, Object[] objectArray) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(this.getErrorCode(), string, objectArray);
        sVNErrorMessage.setChildErrorMessage(this);
        return sVNErrorMessage;
    }

    public boolean isWarning() {
        return this.myType == 1;
    }

    public boolean setType(int n2) {
        if (n2 == 0) {
            this.myType = 0;
            return true;
        }
        if (n2 == 1) {
            this.myType = 1;
            return true;
        }
        return false;
    }

    public SVNErrorMessage getRootErrorMessage() {
        SVNErrorMessage sVNErrorMessage = this;
        while (sVNErrorMessage.myChildErrorMessage != null) {
            sVNErrorMessage = sVNErrorMessage.myChildErrorMessage;
        }
        return sVNErrorMessage;
    }

    public boolean isDontShowErrorCode() {
        return this.dontShowErrorCode;
    }

    public void setDontShowErrorCode(boolean bl2) {
        this.dontShowErrorCode = bl2;
    }

    public SVNErrorMessage findChildWithErrorCode(SVNErrorCode sVNErrorCode) {
        HashSet<SVNErrorMessage> hashSet = new HashSet<SVNErrorMessage>();
        for (SVNErrorMessage sVNErrorMessage = this; sVNErrorMessage != null; sVNErrorMessage = sVNErrorMessage.getChildErrorMessage()) {
            if (hashSet.contains(sVNErrorMessage)) {
                return null;
            }
            if (sVNErrorMessage.getErrorCode() == sVNErrorCode) {
                return sVNErrorMessage;
            }
            hashSet.add(sVNErrorMessage);
        }
        return null;
    }

    public boolean hasChildWithErrorCode(SVNErrorCode sVNErrorCode) {
        return this.findChildWithErrorCode(sVNErrorCode) != null;
    }

    public void initCause(Throwable throwable) {
        if (this.myThrowable == null) {
            this.myThrowable = throwable;
        }
    }
}

