/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

public class SVNDepth
implements Comparable {
    public static final SVNDepth UNKNOWN = new SVNDepth(-2, "unknown");
    public static final SVNDepth EXCLUDE = new SVNDepth(-1, "exclude");
    public static final SVNDepth EMPTY = new SVNDepth(0, "empty");
    public static final SVNDepth FILES = new SVNDepth(1, "files");
    public static final SVNDepth IMMEDIATES = new SVNDepth(2, "immediates");
    public static final SVNDepth INFINITY = new SVNDepth(3, "infinity");
    private int myId;
    private String myName;

    private SVNDepth(int n2, String string) {
        this.myId = n2;
        this.myName = string;
    }

    public int getId() {
        return this.myId;
    }

    public String getName() {
        return this.myName;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isRecursive() {
        return this == INFINITY || this == UNKNOWN;
    }

    public int compareTo(Object object) {
        if (object == null || object.getClass() != SVNDepth.class) {
            return -1;
        }
        SVNDepth sVNDepth = (SVNDepth)object;
        return this.myId == sVNDepth.myId ? 0 : (this.myId > sVNDepth.myId ? 1 : -1);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public static String asString(SVNDepth sVNDepth) {
        if (sVNDepth != null) {
            return sVNDepth.getName();
        }
        return "INVALID-DEPTH";
    }

    public static boolean recurseFromDepth(SVNDepth sVNDepth) {
        return sVNDepth == null || sVNDepth == INFINITY || sVNDepth == UNKNOWN;
    }

    public static SVNDepth fromRecurse(boolean bl2) {
        return bl2 ? INFINITY : FILES;
    }

    public static SVNDepth fromString(String string) {
        if (EMPTY.getName().equals(string)) {
            return EMPTY;
        }
        if (EXCLUDE.getName().equals(string)) {
            return EXCLUDE;
        }
        if (FILES.getName().equals(string)) {
            return FILES;
        }
        if (IMMEDIATES.getName().equals(string)) {
            return IMMEDIATES;
        }
        if (INFINITY.getName().equals(string)) {
            return INFINITY;
        }
        return UNKNOWN;
    }

    public static SVNDepth fromID(int n2) {
        switch (n2) {
            case 3: {
                return INFINITY;
            }
            case 2: {
                return IMMEDIATES;
            }
            case 1: {
                return FILES;
            }
            case 0: {
                return EMPTY;
            }
            case -1: {
                return EXCLUDE;
            }
        }
        return UNKNOWN;
    }

    public static SVNDepth getInfinityOrEmptyDepth(boolean bl2) {
        return bl2 ? INFINITY : EMPTY;
    }

    public static SVNDepth getInfinityOrFilesDepth(boolean bl2) {
        return bl2 ? INFINITY : FILES;
    }

    public static SVNDepth getInfinityOrImmediatesDepth(boolean bl2) {
        return bl2 ? INFINITY : IMMEDIATES;
    }

    public static SVNDepth getUnknownOrEmptyDepth(boolean bl2) {
        return bl2 ? UNKNOWN : EMPTY;
    }

    public static SVNDepth getUnknownOrFilesDepth(boolean bl2) {
        return bl2 ? UNKNOWN : FILES;
    }

    public static SVNDepth getUnknownOrImmediatesDepth(boolean bl2) {
        return bl2 ? UNKNOWN : IMMEDIATES;
    }
}

