/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.util.Date;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;

public class SVNCommitInfo {
    public static final SVNCommitInfo NULL = new SVNCommitInfo(-1L, null, null, null);
    private long myNewRevision;
    private Date myDate;
    private String myAuthor;
    private SVNErrorMessage myErrorMessage;

    public SVNCommitInfo(long l2, String string, Date date) {
        this(l2, string, date, null);
    }

    public SVNCommitInfo(long l2, String string, Date date, SVNErrorMessage sVNErrorMessage) {
        this.myNewRevision = l2;
        this.myAuthor = string;
        this.myDate = date;
        this.myErrorMessage = sVNErrorMessage;
    }

    public long getNewRevision() {
        return this.myNewRevision;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public Date getDate() {
        return this.myDate;
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    public SVNException getError() {
        if (this.myErrorMessage != null) {
            return new SVNException(this.getErrorMessage());
        }
        return null;
    }

    public String toString() {
        if (this == NULL) {
            return "EMPTY COMMIT";
        }
        if (this.myErrorMessage == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("r");
            stringBuffer.append(this.myNewRevision);
            if (this.myAuthor != null) {
                stringBuffer.append(" by '");
                stringBuffer.append(this.myAuthor);
                stringBuffer.append("'");
            }
            if (this.myDate != null) {
                stringBuffer.append(" at ");
                stringBuffer.append(this.myDate);
            }
            return stringBuffer.toString();
        }
        return this.myErrorMessage.getFullMessage();
    }
}

