/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.line.QSequenceLineMedia;
import de.regnis.q.sequence.line.QSequenceLineRAFileData;
import de.regnis.q.sequence.line.QSequenceLineResult;
import de.regnis.q.sequence.line.simplifier.QSequenceLineDummySimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineEOLUnifyingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineTeeSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceReducingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceSkippingSimplifier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.tmatesoft.svn.core.SVNAnnotationGenerator$BlameChunk;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorInputStream;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAnnotationGenerator
implements ISVNFileRevisionHandler {
    private File myTmpDirectory;
    private boolean myIsTmpDirCreated;
    private String myPath;
    private long myCurrentRevision;
    private SVNProperties myCurrentRevisionProperties;
    private String myCurrentAuthor;
    private Date myCurrentDate;
    private boolean myIsCurrentResultOfMerge;
    private String myCurrentPath;
    private File myPreviousFile;
    private File myPreviousOriginalFile;
    private File myCurrentFile;
    private List myMergeBlameChunks;
    private List myBlameChunks;
    private SVNDeltaProcessor myDeltaProcessor;
    private ISVNEventHandler myCancelBaton;
    private long myStartRevision;
    private long myEndRevision;
    private boolean myIsForce;
    private boolean myIncludeMergedRevisions;
    private SVNDiffOptions myDiffOptions;
    private QSequenceLineSimplifier mySimplifier;
    private ISVNAnnotateHandler myFileHandler;
    private String myEncoding;
    private boolean myIsLastRevisionReported;
    private boolean myIsBackwards;
    private long myLatestRevision;
    private SVNProperties myLatestRevisionProperties;

    public SVNAnnotationGenerator(String string, File file, long l2, ISVNEventHandler iSVNEventHandler) {
        this(string, file, l2, false, iSVNEventHandler);
    }

    public SVNAnnotationGenerator(String string, File file, long l2, boolean bl2, ISVNEventHandler iSVNEventHandler) {
        this(string, file, l2, bl2, new SVNDiffOptions(), iSVNEventHandler);
    }

    public SVNAnnotationGenerator(String string, File file, long l2, boolean bl2, SVNDiffOptions sVNDiffOptions, ISVNEventHandler iSVNEventHandler) {
        this(string, file, l2, bl2, false, sVNDiffOptions, null, null, iSVNEventHandler);
    }

    public SVNAnnotationGenerator(String string, File file, long l2, boolean bl2, boolean bl3, SVNDiffOptions sVNDiffOptions, String string2, ISVNAnnotateHandler iSVNAnnotateHandler, ISVNEventHandler iSVNEventHandler) {
        this.myTmpDirectory = file;
        this.myCancelBaton = iSVNEventHandler;
        this.myPath = string;
        this.myIsForce = bl2;
        if (!this.myTmpDirectory.isDirectory()) {
            this.myTmpDirectory.mkdirs();
            this.myIsTmpDirCreated = true;
        }
        this.myMergeBlameChunks = new ArrayList();
        this.myBlameChunks = new ArrayList();
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myStartRevision = l2;
        this.myDiffOptions = sVNDiffOptions == null ? new SVNDiffOptions() : sVNDiffOptions;
        this.myIncludeMergedRevisions = bl3;
        this.myFileHandler = iSVNAnnotateHandler;
        this.myEncoding = string2;
    }

    public void setBackwards(boolean bl2) {
        this.myIsBackwards = bl2;
    }

    public void setEndRevision(long l2) {
        this.myEndRevision = l2;
    }

    @Override
    public void openRevision(SVNFileRevision sVNFileRevision) {
        String string;
        SVNProperties sVNProperties = sVNFileRevision.getPropertiesDelta();
        String string2 = string = sVNProperties != null ? sVNProperties.getStringValue("svn:mime-type") : null;
        if (!this.myIsForce && SVNProperty.isBinaryMimeType(string)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_BINARY_FILE, "Cannot calculate blame information for binary file ''{0}''", (Object)this.myPath);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        this.myCurrentRevisionProperties = null;
        if (this.myIsBackwards) {
            this.myCurrentRevision = this.myLatestRevision;
            this.myCurrentRevisionProperties = this.myLatestRevisionProperties;
            if (sVNFileRevision.getRevision() >= Math.min(this.myStartRevision, this.myEndRevision)) {
                this.myLatestRevision = sVNFileRevision.getRevision();
                this.myLatestRevisionProperties = sVNFileRevision.getRevisionProperties();
            }
        } else if (sVNFileRevision.isResultOfMerge() || sVNFileRevision.getRevision() >= Math.min(this.myStartRevision, this.myEndRevision)) {
            assert (sVNFileRevision.getRevision() <= 1L + Math.max(this.myStartRevision, this.myEndRevision));
            this.myCurrentRevision = sVNFileRevision.getRevision();
            this.myCurrentRevisionProperties = sVNFileRevision.getRevisionProperties();
        } else {
            this.myCurrentRevision = -1L;
        }
        boolean bl2 = sVNFileRevision.getRevision() >= this.myStartRevision;
        SVNProperties sVNProperties2 = this.myCurrentRevisionProperties;
        if (this.myCancelBaton != null) {
            File file = SVNPathUtil.isURL(this.myPath) ? null : new File(this.myPath);
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.NONE, null, this.myCurrentRevision, SVNEventAction.ANNOTATE, null, null, null, sVNProperties2, null);
            if (file == null) {
                sVNEvent.setURL(SVNURL.parseURIEncoded(this.myPath));
            }
            this.myCancelBaton.handleEvent(sVNEvent, -1.0);
            this.myCancelBaton.checkCancelled();
        }
        this.myCurrentAuthor = bl2 && sVNProperties2 != null && sVNProperties2.getStringValue("svn:author") != null ? sVNProperties2.getStringValue("svn:author") : null;
        this.myCurrentDate = bl2 && sVNProperties2 != null && sVNProperties2.getStringValue("svn:date") != null ? SVNDate.parseDate(sVNFileRevision.getRevisionProperties().getStringValue("svn:date")) : null;
        this.myIsCurrentResultOfMerge = sVNFileRevision.isResultOfMerge();
        if (this.myIncludeMergedRevisions) {
            this.myCurrentPath = sVNFileRevision.getPath();
        }
    }

    @Override
    public void closeRevision(String string) {
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        if (this.myCurrentFile == null) {
            this.myCurrentFile = SVNFileUtil.createUniqueFile(this.myTmpDirectory, "annotate", ".tmp", false);
        }
        this.myDeltaProcessor.applyTextDelta(this.myPreviousFile, this.myCurrentFile, false);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        return this.myDeltaProcessor.textDeltaChunk(sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        boolean bl2;
        this.myIsLastRevisionReported = false;
        this.myDeltaProcessor.textDeltaEnd();
        if (this.myIncludeMergedRevisions) {
            this.myMergeBlameChunks = this.addFileBlame(this.myPreviousFile, this.myCurrentFile, this.myMergeBlameChunks);
            if (!this.myIsCurrentResultOfMerge) {
                this.myBlameChunks = this.addFileBlame(this.myPreviousOriginalFile, this.myCurrentFile, this.myBlameChunks);
                if (this.myPreviousOriginalFile == null) {
                    this.myPreviousOriginalFile = this.myCurrentFile;
                    this.myCurrentFile = null;
                } else {
                    SVNFileUtil.rename(this.myCurrentFile, this.myPreviousOriginalFile);
                }
                this.myPreviousFile = this.myPreviousOriginalFile;
            } else if (this.myPreviousFile != null && this.myPreviousFile != this.myPreviousOriginalFile) {
                SVNFileUtil.rename(this.myCurrentFile, this.myPreviousFile);
            } else {
                this.myPreviousFile = this.myCurrentFile;
                this.myCurrentFile = null;
            }
        } else {
            this.myBlameChunks = this.addFileBlame(this.myPreviousFile, this.myCurrentFile, this.myBlameChunks);
            if (this.myPreviousFile == null) {
                this.myPreviousFile = this.myCurrentFile;
                this.myCurrentFile = null;
            } else {
                SVNFileUtil.rename(this.myCurrentFile, this.myPreviousFile);
            }
        }
        if (this.myFileHandler != null && (bl2 = this.myFileHandler.handleRevision(this.myCurrentDate, this.myCurrentDate != null ? this.myCurrentRevision : -1L, this.myCurrentAuthor, this.myPreviousFile))) {
            this.myIsLastRevisionReported = true;
            this.reportAnnotations(this.myFileHandler, this.myEncoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileBlame(InputStream inputStream) {
        if (this.myCurrentFile == null) {
            this.myCurrentFile = SVNFileUtil.createUniqueFile(this.myTmpDirectory, "annotate", ".tmp", false);
        }
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(this.myCurrentFile);
            SVNTranslator.copy(inputStream, outputStream);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
        this.myBlameChunks = this.addFileBlame(this.myPreviousFile, this.myCurrentFile, this.myBlameChunks);
        if (this.myPreviousFile == null) {
            this.myPreviousFile = this.myCurrentFile;
            this.myCurrentFile = null;
        } else {
            SVNFileUtil.rename(this.myCurrentFile, this.myPreviousFile);
        }
    }

    public boolean isLastRevisionReported() {
        return this.myIsLastRevisionReported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportAnnotations(ISVNAnnotateHandler iSVNAnnotateHandler, String string) {
        Object object;
        if (iSVNAnnotateHandler == null) {
            return;
        }
        SVNErrorManager.assertionFailure(this.myPreviousFile != null, null, SVNLogType.WC);
        int n2 = -1;
        if (this.myIncludeMergedRevisions) {
            if (this.myBlameChunks.isEmpty()) {
                object = new SVNAnnotationGenerator$BlameChunk(null);
                ((SVNAnnotationGenerator$BlameChunk)object).blockStart = 0;
                ((SVNAnnotationGenerator$BlameChunk)object).author = this.myCurrentAuthor;
                ((SVNAnnotationGenerator$BlameChunk)object).date = this.myCurrentDate;
                ((SVNAnnotationGenerator$BlameChunk)object).revision = this.myCurrentRevision;
                ((SVNAnnotationGenerator$BlameChunk)object).path = this.myCurrentPath;
                this.myBlameChunks.add(object);
            }
            this.normalizeBlames(this.myBlameChunks, this.myMergeBlameChunks);
            n2 = 0;
        }
        string = string == null ? System.getProperty("file.encoding") : string;
        object = Charset.forName(string).newDecoder();
        SVNTranslatorInputStream sVNTranslatorInputStream = null;
        try {
            sVNTranslatorInputStream = new SVNTranslatorInputStream(SVNFileUtil.openFileForReading(this.myPreviousFile), SVNProperty.EOL_LF_BYTES, true, null, false);
            StringBuffer stringBuffer = new StringBuffer();
            block4: for (int i2 = 0; i2 < this.myBlameChunks.size(); ++i2) {
                SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk;
                SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk2 = (SVNAnnotationGenerator$BlameChunk)this.myBlameChunks.get(i2);
                String string2 = null;
                long l2 = -1L;
                Date date = null;
                String string3 = null;
                if (n2 >= 0) {
                    sVNAnnotationGenerator$BlameChunk = (SVNAnnotationGenerator$BlameChunk)this.myMergeBlameChunks.get(n2++);
                    string2 = sVNAnnotationGenerator$BlameChunk.author;
                    l2 = sVNAnnotationGenerator$BlameChunk.revision;
                    date = sVNAnnotationGenerator$BlameChunk.date;
                    string3 = sVNAnnotationGenerator$BlameChunk.path;
                }
                sVNAnnotationGenerator$BlameChunk = null;
                if (i2 < this.myBlameChunks.size() - 1) {
                    sVNAnnotationGenerator$BlameChunk = (SVNAnnotationGenerator$BlameChunk)this.myBlameChunks.get(i2 + 1);
                }
                for (int i3 = sVNAnnotationGenerator$BlameChunk2.blockStart; sVNAnnotationGenerator$BlameChunk == null || i3 < sVNAnnotationGenerator$BlameChunk.blockStart; ++i3) {
                    this.myCancelBaton.checkCancelled();
                    stringBuffer.setLength(0);
                    String string4 = SVNFileUtil.readLineFromStream(sVNTranslatorInputStream, stringBuffer, (CharsetDecoder)object);
                    boolean bl2 = false;
                    if (string4 == null) {
                        bl2 = true;
                        if (stringBuffer.length() > 0) {
                            string4 = stringBuffer.toString();
                        }
                    }
                    if (!bl2 || string4 != null) {
                        iSVNAnnotateHandler.handleLine(sVNAnnotationGenerator$BlameChunk2.date, sVNAnnotationGenerator$BlameChunk2.revision, sVNAnnotationGenerator$BlameChunk2.author, string4, date, l2, string2, string3, i3);
                    }
                    if (bl2) continue block4;
                }
            }
            iSVNAnnotateHandler.handleEOF();
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(sVNTranslatorInputStream);
                throw throwable;
            }
            SVNFileUtil.closeFile(sVNTranslatorInputStream);
        }
        SVNFileUtil.closeFile(sVNTranslatorInputStream);
    }

    public void dispose() {
        this.myIsCurrentResultOfMerge = false;
        if (this.myCurrentFile != null) {
            SVNFileUtil.deleteAll(this.myCurrentFile, true);
        }
        if (this.myPreviousFile != null) {
            SVNFileUtil.deleteAll(this.myPreviousFile, true);
            this.myPreviousFile = null;
        }
        if (this.myPreviousOriginalFile != null) {
            SVNFileUtil.deleteAll(this.myPreviousOriginalFile, true);
            this.myPreviousOriginalFile = null;
        }
        if (this.myIsTmpDirCreated) {
            SVNFileUtil.deleteAll(this.myTmpDirectory, true);
        }
        this.myBlameChunks.clear();
        this.myMergeBlameChunks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List addFileBlame(File file, File file2, List list) {
        RandomAccessFile randomAccessFile;
        block15: {
            if (file == null) {
                SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk = new SVNAnnotationGenerator$BlameChunk(null);
                sVNAnnotationGenerator$BlameChunk.author = this.myCurrentAuthor;
                sVNAnnotationGenerator$BlameChunk.revision = this.myCurrentDate != null ? this.myCurrentRevision : -1L;
                sVNAnnotationGenerator$BlameChunk.date = this.myCurrentDate;
                sVNAnnotationGenerator$BlameChunk.blockStart = 0;
                sVNAnnotationGenerator$BlameChunk.path = this.myCurrentPath;
                list.add(sVNAnnotationGenerator$BlameChunk);
                return list;
            }
            RandomAccessFile randomAccessFile2 = null;
            randomAccessFile = null;
            try {
                randomAccessFile2 = new RandomAccessFile(file, "r");
                randomAccessFile = new RandomAccessFile(file2, "r");
                try (QSequenceLineResult qSequenceLineResult = QSequenceLineMedia.createBlocks(new QSequenceLineRAFileData(randomAccessFile2), new QSequenceLineRAFileData(randomAccessFile), this.createSimplifier());){
                    List list2 = qSequenceLineResult.getBlocks();
                    for (int i2 = 0; i2 < list2.size(); ++i2) {
                        QSequenceDifferenceBlock qSequenceDifferenceBlock = (QSequenceDifferenceBlock)list2.get(i2);
                        if (qSequenceDifferenceBlock.getLeftSize() > 0) {
                            this.deleteBlameChunk(qSequenceDifferenceBlock.getRightFrom(), qSequenceDifferenceBlock.getLeftSize(), list);
                        }
                        if (qSequenceDifferenceBlock.getRightSize() <= 0) continue;
                        this.insertBlameChunk(this.myCurrentRevision, this.myCurrentAuthor, this.myCurrentDate, this.myCurrentPath, qSequenceDifferenceBlock.getRightFrom(), qSequenceDifferenceBlock.getRightSize(), list);
                    }
                }
                if (randomAccessFile2 == null) break block15;
            }
            catch (Throwable throwable) {
                block16: {
                    try {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Exception while generating annotation: {0}", (Object)throwable.getMessage());
                        SVNErrorManager.error(sVNErrorMessage, throwable, SVNLogType.DEFAULT);
                        if (randomAccessFile2 == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (randomAccessFile2 != null) {
                            SVNFileUtil.closeFile(randomAccessFile2);
                        }
                        if (randomAccessFile != null) {
                            SVNFileUtil.closeFile(randomAccessFile);
                        }
                        throw throwable2;
                    }
                    SVNFileUtil.closeFile(randomAccessFile2);
                }
                if (randomAccessFile != null) {
                    SVNFileUtil.closeFile(randomAccessFile);
                }
            }
            SVNFileUtil.closeFile(randomAccessFile2);
        }
        if (randomAccessFile != null) {
            SVNFileUtil.closeFile(randomAccessFile);
        }
        return list;
    }

    private void insertBlameChunk(long l2, String string, Date date, String string2, int n2, int n3, List list) {
        int[] nArray = new int[1];
        SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk = this.findBlameChunk(list, n2, nArray);
        int n4 = -1;
        if (sVNAnnotationGenerator$BlameChunk.blockStart == n2) {
            SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk2 = new SVNAnnotationGenerator$BlameChunk(null);
            sVNAnnotationGenerator$BlameChunk2.copy(sVNAnnotationGenerator$BlameChunk);
            sVNAnnotationGenerator$BlameChunk2.blockStart = n2 + n3;
            list.add(nArray[0] + 1, sVNAnnotationGenerator$BlameChunk2);
            sVNAnnotationGenerator$BlameChunk.author = string;
            sVNAnnotationGenerator$BlameChunk.revision = l2;
            sVNAnnotationGenerator$BlameChunk.date = date;
            sVNAnnotationGenerator$BlameChunk.path = string2;
            n4 = nArray[0] + 2;
        } else {
            SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk3 = new SVNAnnotationGenerator$BlameChunk(null);
            sVNAnnotationGenerator$BlameChunk3.author = string;
            sVNAnnotationGenerator$BlameChunk3.revision = l2;
            sVNAnnotationGenerator$BlameChunk3.date = date;
            sVNAnnotationGenerator$BlameChunk3.path = string2;
            sVNAnnotationGenerator$BlameChunk3.blockStart = n2;
            SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk4 = new SVNAnnotationGenerator$BlameChunk(null);
            sVNAnnotationGenerator$BlameChunk4.copy(sVNAnnotationGenerator$BlameChunk);
            sVNAnnotationGenerator$BlameChunk4.blockStart = n2 + n3;
            list.add(nArray[0] + 1, sVNAnnotationGenerator$BlameChunk3);
            list.add(nArray[0] + 2, sVNAnnotationGenerator$BlameChunk4);
            n4 = nArray[0] + 3;
        }
        this.adjustBlameChunks(list, n4, n3);
    }

    private void deleteBlameChunk(int n2, int n3, List list) {
        SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk;
        int n4;
        int[] nArray = new int[1];
        SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk2 = this.findBlameChunk(list, n2, nArray);
        int n5 = nArray[0];
        SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk3 = this.findBlameChunk(list, n2 + n3, nArray);
        int n6 = nArray[0];
        if (sVNAnnotationGenerator$BlameChunk2 != sVNAnnotationGenerator$BlameChunk3) {
            n4 = n6 - n5 - 1;
            for (int i2 = 0; i2 < n4; ++i2) {
                list.remove(n5 + 1);
            }
            n6 -= n4;
            sVNAnnotationGenerator$BlameChunk3.blockStart = n2;
            if (sVNAnnotationGenerator$BlameChunk2.blockStart == n2) {
                sVNAnnotationGenerator$BlameChunk2.copy(sVNAnnotationGenerator$BlameChunk3);
                list.remove(n6);
                --n6;
                sVNAnnotationGenerator$BlameChunk3 = sVNAnnotationGenerator$BlameChunk2;
            }
        }
        n4 = n6 < list.size() - 1 ? n6 + 1 : -1;
        SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk4 = sVNAnnotationGenerator$BlameChunk = n4 > 0 ? (SVNAnnotationGenerator$BlameChunk)list.get(n4) : null;
        if (sVNAnnotationGenerator$BlameChunk != null && sVNAnnotationGenerator$BlameChunk.blockStart == sVNAnnotationGenerator$BlameChunk3.blockStart + n3) {
            sVNAnnotationGenerator$BlameChunk3.copy(sVNAnnotationGenerator$BlameChunk);
            list.remove(sVNAnnotationGenerator$BlameChunk);
            --n4;
            sVNAnnotationGenerator$BlameChunk = sVNAnnotationGenerator$BlameChunk3;
        }
        if (sVNAnnotationGenerator$BlameChunk != null) {
            this.adjustBlameChunks(list, n4, -n3);
        }
    }

    private void adjustBlameChunks(List list, int n2, int n3) {
        for (int i2 = n2; i2 < list.size(); ++i2) {
            SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk = (SVNAnnotationGenerator$BlameChunk)list.get(i2);
            sVNAnnotationGenerator$BlameChunk.blockStart += n3;
        }
    }

    private SVNAnnotationGenerator$BlameChunk findBlameChunk(List list, int n2, int[] nArray) {
        SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk = null;
        nArray[0] = -1;
        for (SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk2 : list) {
            if (sVNAnnotationGenerator$BlameChunk2.blockStart > n2) break;
            sVNAnnotationGenerator$BlameChunk = sVNAnnotationGenerator$BlameChunk2;
            nArray[0] = nArray[0] + 1;
        }
        return sVNAnnotationGenerator$BlameChunk;
    }

    private void normalizeBlames(List list, List list2) {
        SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk;
        SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk2;
        SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk3;
        int n2;
        int n3 = 0;
        for (n2 = 0; n3 < list.size() - 1 && n2 < list2.size() - 1; ++n3, ++n2) {
            SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk4;
            sVNAnnotationGenerator$BlameChunk3 = (SVNAnnotationGenerator$BlameChunk)list.get(n3);
            sVNAnnotationGenerator$BlameChunk2 = (SVNAnnotationGenerator$BlameChunk)list2.get(n2);
            SVNErrorManager.assertionFailure(sVNAnnotationGenerator$BlameChunk3.blockStart == sVNAnnotationGenerator$BlameChunk2.blockStart, null, SVNLogType.WC);
            sVNAnnotationGenerator$BlameChunk = (SVNAnnotationGenerator$BlameChunk)list.get(n3 + 1);
            SVNAnnotationGenerator$BlameChunk sVNAnnotationGenerator$BlameChunk5 = (SVNAnnotationGenerator$BlameChunk)list2.get(n2 + 1);
            if (sVNAnnotationGenerator$BlameChunk.blockStart < sVNAnnotationGenerator$BlameChunk5.blockStart) {
                sVNAnnotationGenerator$BlameChunk4 = new SVNAnnotationGenerator$BlameChunk(null);
                sVNAnnotationGenerator$BlameChunk4.copy(sVNAnnotationGenerator$BlameChunk2);
                sVNAnnotationGenerator$BlameChunk4.blockStart = sVNAnnotationGenerator$BlameChunk.blockStart;
                list2.add(n2 + 1, sVNAnnotationGenerator$BlameChunk4);
                sVNAnnotationGenerator$BlameChunk5 = sVNAnnotationGenerator$BlameChunk4;
            }
            if (sVNAnnotationGenerator$BlameChunk.blockStart <= sVNAnnotationGenerator$BlameChunk5.blockStart) continue;
            sVNAnnotationGenerator$BlameChunk4 = new SVNAnnotationGenerator$BlameChunk(null);
            sVNAnnotationGenerator$BlameChunk4.copy(sVNAnnotationGenerator$BlameChunk3);
            sVNAnnotationGenerator$BlameChunk4.blockStart = sVNAnnotationGenerator$BlameChunk5.blockStart;
            list.add(n3 + 1, sVNAnnotationGenerator$BlameChunk4);
        }
        if (n3 == list.size() - 1 && n2 == list2.size() - 1) {
            return;
        }
        if (n2 == list2.size() - 1) {
            ++n3;
            while (n3 < list.size()) {
                sVNAnnotationGenerator$BlameChunk3 = (SVNAnnotationGenerator$BlameChunk)list.get(n3);
                sVNAnnotationGenerator$BlameChunk2 = (SVNAnnotationGenerator$BlameChunk)list2.get(list2.size() - 1);
                sVNAnnotationGenerator$BlameChunk = new SVNAnnotationGenerator$BlameChunk(null);
                sVNAnnotationGenerator$BlameChunk.copy(sVNAnnotationGenerator$BlameChunk2);
                sVNAnnotationGenerator$BlameChunk.blockStart = sVNAnnotationGenerator$BlameChunk3.blockStart;
                list2.add(sVNAnnotationGenerator$BlameChunk);
                ++n2;
                ++n3;
            }
        }
        if (n3 == list.size() - 1) {
            ++n2;
            while (n2 < list2.size()) {
                sVNAnnotationGenerator$BlameChunk3 = (SVNAnnotationGenerator$BlameChunk)list2.get(n2);
                sVNAnnotationGenerator$BlameChunk2 = (SVNAnnotationGenerator$BlameChunk)list.get(list.size() - 1);
                sVNAnnotationGenerator$BlameChunk = new SVNAnnotationGenerator$BlameChunk(null);
                sVNAnnotationGenerator$BlameChunk.copy(sVNAnnotationGenerator$BlameChunk2);
                sVNAnnotationGenerator$BlameChunk.blockStart = sVNAnnotationGenerator$BlameChunk3.blockStart;
                list.add(sVNAnnotationGenerator$BlameChunk);
                ++n3;
                ++n2;
            }
        }
    }

    private QSequenceLineSimplifier createSimplifier() {
        if (this.mySimplifier == null) {
            QSequenceLineSimplifier qSequenceLineSimplifier = this.myDiffOptions.isIgnoreEOLStyle() ? new QSequenceLineEOLUnifyingSimplifier() : new QSequenceLineDummySimplifier();
            QSequenceLineSimplifier qSequenceLineSimplifier2 = new QSequenceLineDummySimplifier();
            if (this.myDiffOptions.isIgnoreAllWhitespace()) {
                qSequenceLineSimplifier2 = new QSequenceLineWhiteSpaceSkippingSimplifier();
            } else if (this.myDiffOptions.isIgnoreAmountOfWhitespace()) {
                qSequenceLineSimplifier2 = new QSequenceLineWhiteSpaceReducingSimplifier();
            }
            this.mySimplifier = new QSequenceLineTeeSimplifier(qSequenceLineSimplifier, qSequenceLineSimplifier2);
        }
        return this.mySimplifier;
    }
}

