/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.web.hooks;

import com.a.a.a.d.N;
import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.PathOutputHandler;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgGitRepositoryFactory;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.cmdline.SgCommandInputHandler;
import org.tmatesoft.subgit.stash.mirror.cmdline.SgEnvironmentCommandOutputHandler;
import org.tmatesoft.subgit.stash.mirror.cmdline.SgObjectsListCommandOutputHandler;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTaskParameters;
import org.tmatesoft.subgit.stash.mirror.tasks.SgUninstallTaskParameters;
import org.tmatesoft.subgit.stash.mirror.util.SgFileUtil;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;
import org.tmatesoft.subgit.stash.web.hooks.WriterOutputStream;
import org.tmatesoft.translator.e.i;
import org.tmatesoft.translator.k.n;

public abstract class SgAbstractPreReceiveRepositoryHook {
    private static final Charset UTF_8_CHARSET = StandardCharsets.UTF_8;
    private static final int CONSOLE_BUFFER_SIZE = 512;
    private static final String SUBGIT_DELETION_CANCELLED_KEY = "subgit.deletionCancelled";
    protected final SgMirrorService mirrorService;
    protected final Logger log;
    protected final SgTaskSchedulerService taskSchedulerService;
    protected final GitCommandBuilderFactory commandBuilderFactory;
    protected final SgGitRepositoryFactory gitRepositoryFactory;

    protected SgAbstractPreReceiveRepositoryHook(SgMirrorService sgMirrorService, SgLoggerFactory sgLoggerFactory, SgTaskSchedulerService sgTaskSchedulerService, GitCommandBuilderFactory gitCommandBuilderFactory, SgGitRepositoryFactory sgGitRepositoryFactory) {
        this.mirrorService = sgMirrorService;
        this.log = sgLoggerFactory.getLogger("hooks");
        this.taskSchedulerService = sgTaskSchedulerService;
        this.commandBuilderFactory = gitCommandBuilderFactory;
        this.gitRepositoryFactory = sgGitRepositoryFactory;
    }

    protected n getDevNull() {
        return this.mirrorService.getDummyConsole();
    }

    protected SgMirrorStage getMirrorStage(Repository repository) {
        if (repository == null) {
            return SgMirrorStage.UNKNOWN;
        }
        return this.mirrorService.getRepositoryStage(repository);
    }

    protected static boolean isActiveMirrorStage(SgMirrorStage sgMirrorStage) {
        return sgMirrorStage == SgMirrorStage.INSTALLED || sgMirrorStage == SgMirrorStage.LEGACY || sgMirrorStage == SgMirrorStage.EXTERNAL_LOCAL || sgMirrorStage == SgMirrorStage.EXTERNAL_REMOTE || sgMirrorStage == SgMirrorStage.PENDING_METADATA_MOVE;
    }

    protected void logEvent(SgMirrorScope sgMirrorScope, Object object) {
        this.logEvent(sgMirrorScope, object, Collections.emptyList());
    }

    protected void logEvent(SgMirrorScope sgMirrorScope, Object object, Collection collection) {
        if (this.log.isInfoEnabled()) {
            if (object == null) {
                object = "Message";
            }
            this.log.info(SgTextUtil.formatString("[%s] on%s", sgMirrorScope, object instanceof Class ? ((Class)object).getSimpleName() : object.toString()));
            if (collection != null) {
                for (RefChange refChange : collection) {
                    if (refChange == null) continue;
                    this.log.info("  " + refChange.getRef().getId() + " : " + refChange.getFromHash() + " => " + refChange.getToHash() + " (" + String.valueOf(refChange.getType()) + ")");
                }
            }
        }
    }

    protected n getHookConsole(PrintWriter printWriter, PrintWriter printWriter2) {
        try {
            return new n(new PrintStream(printWriter == null ? SgFileUtil.NULL_OUTPUT_STREAM : new WriterOutputStream((Writer)printWriter, UTF_8_CHARSET, 512, true), true, UTF_8_CHARSET.name()), new PrintStream(printWriter2 == null ? SgFileUtil.NULL_OUTPUT_STREAM : new WriterOutputStream((Writer)printWriter2, UTF_8_CHARSET, 512, true), true, UTF_8_CHARSET.name()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new n(new PrintStream(printWriter == null ? SgFileUtil.NULL_OUTPUT_STREAM : new WriterOutputStream((Writer)printWriter, UTF_8_CHARSET, 512, true), true), new PrintStream(printWriter2 == null ? SgFileUtil.NULL_OUTPUT_STREAM : new WriterOutputStream((Writer)printWriter2, UTF_8_CHARSET, 512, true), true));
        }
    }

    public void onRepositoryDeletionRequest(RepositoryDeletionRequestedEvent repositoryDeletionRequestedEvent) {
        this.logEvent(SgMirrorScope.forRepository(repositoryDeletionRequestedEvent.getRepository()), repositoryDeletionRequestedEvent.getClass());
        try {
            this.runUninstallTask(SgMirrorScope.forRepository(repositoryDeletionRequestedEvent.getRepository()));
        }
        catch (Throwable throwable) {
            this.log.info(throwable.getMessage(), throwable);
            repositoryDeletionRequestedEvent.cancel(new KeyedMessage(SUBGIT_DELETION_CANCELLED_KEY, throwable.getMessage(), throwable.getMessage()));
        }
    }

    public void onProjectDeletionRequest(ProjectDeletionRequestedEvent projectDeletionRequestedEvent) {
        this.logEvent(SgMirrorScope.forProject(projectDeletionRequestedEvent.getProject()), projectDeletionRequestedEvent.getClass());
        try {
            this.runUninstallTask(SgMirrorScope.forProject(projectDeletionRequestedEvent.getProject()));
        }
        catch (Throwable throwable) {
            this.log.info(throwable.getMessage(), throwable);
            projectDeletionRequestedEvent.cancel(new KeyedMessage(SUBGIT_DELETION_CANCELLED_KEY, throwable.getMessage(), throwable.getMessage()));
        }
    }

    public void onRepositoryModified(RepositoryModifiedEvent repositoryModifiedEvent) {
        this.logEvent(SgMirrorScope.forRepository(repositoryModifiedEvent.getRepository()), repositoryModifiedEvent.getClass());
        Repository repository = repositoryModifiedEvent.getOldValue();
        Repository repository2 = repositoryModifiedEvent.getNewValue();
        SgMirrorScope sgMirrorScope = SgMirrorScope.forRepository(repository);
        SgMirrorScope sgMirrorScope2 = SgMirrorScope.forRepository(repository2);
        if (sgMirrorScope == null || sgMirrorScope2 == null) {
            return;
        }
        if (!sgMirrorScope.equals(sgMirrorScope2)) {
            this.log.info("repository moved, old scope: " + String.valueOf(sgMirrorScope) + ", new scope: " + String.valueOf(sgMirrorScope2));
            try {
                SgSettings sgSettings = this.mirrorService.createSettings(sgMirrorScope);
                long l2 = (Integer)sgSettings.get(SgMirrorOption.HOOK_TIMEOUT, new SgSettingsType[0]) * 1000;
                ISgTask iSgTask = this.taskSchedulerService.getScheduler().schedule(sgMirrorScope, "repositoryMoved", sgMirrorScope2);
                if (iSgTask != null) {
                    iSgTask.waitForCompletion(l2);
                }
            }
            catch (SgException sgException) {
                this.log.info(sgException.getMessage(), (Throwable)sgException);
            }
        }
    }

    private void runUninstallTask(SgMirrorScope sgMirrorScope) {
        this.log.info("[{}] scheduling uninstall", (Object)sgMirrorScope);
        ISgTask iSgTask = this.taskSchedulerService.getScheduler().schedule(sgMirrorScope, "uninstall", SgUninstallTaskParameters.DELETE_ALL);
        if (iSgTask == null) {
            this.log.info("[{}] failed to schedule uninstall command", (Object)sgMirrorScope);
            throw new SgException("Failed to uninstall SVN Mirror, cannot run uninstall");
        }
        SgSettings sgSettings = this.mirrorService.createSettings(sgMirrorScope);
        long l2 = (Integer)sgSettings.get(SgMirrorOption.HOOK_TIMEOUT, new SgSettingsType[0]) * 1000;
        SgTaskState sgTaskState = iSgTask.waitForCompletion(l2);
        if (sgTaskState == SgTaskState.FAILED) {
            this.log.info("[{}] uninstall command failed", (Object)sgMirrorScope);
            throw new SgException("Failed to uninstall SVN Mirror, uninstall failed:\n" + iSgTask.getStatus().getMessage());
        }
        if (sgTaskState == SgTaskState.CANCELLED) {
            this.log.info("[{}] uninstall command was cancelled", (Object)sgMirrorScope);
            throw new SgException("Failed to uninstall SVN Mirror, uninstall cancelled");
        }
        if (sgTaskState == SgTaskState.REJECTED) {
            this.log.info("[{}] uninstall command was rejected", (Object)sgMirrorScope);
        } else {
            if (sgTaskState == SgTaskState.TIMEOUT) {
                this.log.info("[{}] uninstall command failed on timeout", (Object)sgMirrorScope);
                throw new SgException("Failed to uninstall SVN Mirror, uninstall command timed out");
            }
            if (sgTaskState == SgTaskState.SHUTDOWN) {
                this.log.info("[{}] uninstall command rejected, add-on is shutting down", (Object)sgMirrorScope);
                throw new SgException("Failed to uninstall SVN Mirror, Subversion Mirror add-on is shutting down");
            }
        }
    }

    protected void runPushTask(@Nonnull Repository repository, SgMirrorStage sgMirrorStage, SgPushTaskParameters sgPushTaskParameters, boolean bl2) {
        long l2;
        Object object;
        if (sgPushTaskParameters.getCommandsFor(sgMirrorStage).isEmpty()) {
            this.log.info("[R-{}] push not ran as it is no-op for stage {}", (Object)repository.getId(), (Object)sgMirrorStage);
            return;
        }
        SgMirrorScope sgMirrorScope = SgMirrorScope.forRepository(repository);
        ISgTask iSgTask = this.taskSchedulerService.getScheduler().schedule(sgMirrorScope, "push", sgPushTaskParameters);
        if (iSgTask == null) {
            this.log.info("[R-{}] push not ran for not managed repository {} (unknown)", (Object)repository.getId(), (Object)repository.getName());
            return;
        }
        if (bl2) {
            object = this.mirrorService.createSettings(sgMirrorScope);
            l2 = (Integer)object.get(SgMirrorOption.HOOK_TIMEOUT, new SgSettingsType[0]) * 1000;
        } else {
            l2 = -1L;
        }
        this.log.info("[R-{}] waiting for push completion", (Object)repository.getId());
        object = iSgTask.waitForCompletion(l2);
        this.log.info("[R-{}] push completed: {}", (Object)repository.getId(), object);
        if (object == SgTaskState.FAILED) {
            throw new SgException(iSgTask.getStatus().getMessage());
        }
        if (object == SgTaskState.CANCELLED || object == SgTaskState.AUTO_CANCELLED) {
            throw new SgException("Operation cancelled");
        }
        if (object == SgTaskState.REJECTED) {
            this.log.info("[R-{}] push was not ran for repository {} (rejected)", (Object)repository.getId(), (Object)repository.getName());
        } else {
            if (object == SgTaskState.TIMEOUT) {
                this.log.info("[R-{}] push failed by timeout, scheduling sync", (Object)repository.getId());
                ISgTask iSgTask2 = this.taskSchedulerService.getScheduler().schedule(sgMirrorScope, "sync", null);
                this.log.info("[R-{}] sync scheduled: {}", (Object)repository.getId(), iSgTask2 != null ? Long.valueOf(iSgTask2.getId()) : "null");
                throw new SgException("Server is busy with ongoing Git/SVN synchronization; try again later");
            }
            if (object == SgTaskState.SHUTDOWN) {
                this.log.info("[R-{}] push was not ran for repository {} (shutdown)", (Object)repository.getId(), (Object)repository.getName());
                throw new SgException("SVN Mirror add-on is shutting down; try again later");
            }
            if (object == SgTaskState.SUCCESS) {
                this.log.info("[R-{}] push succeeded", (Object)repository.getId());
            }
        }
    }

    @NotNull
    protected String rejectSyncOnPendingMetadataMove(Repository repository) {
        this.log.info("an attempt to push to a mirror that is pending metadata move: [R-" + repository.getId() + "] " + repository.getName() + "; rejecting");
        String string = "SVN Mirror add-on is upgrading metadata for this repository.\nRetry this operation in a moment.";
        SgMirrorScope sgMirrorScope = SgMirrorScope.forRepository(repository);
        try {
            this.taskSchedulerService.getScheduler().schedule(sgMirrorScope, "move-metadata", null);
        }
        catch (SgException sgException) {
            this.log.error("Failed to schedule 'move-metadata' task", (Throwable)sgException);
        }
        return "SVN Mirror add-on is upgrading metadata for this repository.\nRetry this operation in a moment.";
    }

    @NotNull
    protected Map getPreUpdateEnvironment(Repository repository) {
        Map map = this.getEnvironmentByReflection();
        if (map == null) {
            this.log.info("failed to detect pre-receive hook environment via reflection");
            map = this.getEnvironmentByGitCommand(repository);
        }
        if (map == null) {
            this.log.info("failed to detect pre-receive hook environment via 'env' command");
            map = Collections.emptyMap();
        }
        this.logRelevantGitEnvironment(map);
        return map;
    }

    private void logRelevantGitEnvironment(@NotNull Map map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("pre-receive hook environment:");
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("GIT_OBJECT") && !((String)entry.getKey()).startsWith("GIT_DIR") && !((String)entry.getKey()).startsWith("GIT_QUARANTINE") && !((String)entry.getKey()).startsWith("GIT_ALTERNATE")) continue;
            stringBuilder.append("\n");
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append((String)entry.getValue());
        }
        this.log.info(stringBuilder.toString());
    }

    @Nullable
    private Map getEnvironmentByReflection() {
        Class<?> clazz = Thread.currentThread().getClass();
        try {
            Field field = clazz.getDeclaredField("threadLocals");
            field.setAccessible(true);
            Object object = field.get(Thread.currentThread());
            if (object == null) {
                return null;
            }
            Field field2 = object.getClass().getDeclaredField("table");
            field2.setAccessible(true);
            Object object2 = field2.get(object);
            if (object2 == null || !object2.getClass().isArray()) {
                return null;
            }
            for (int i2 = 0; i2 < Array.getLength(object2); ++i2) {
                Object object3 = Array.get(object2, i2);
                if (object3 == null) continue;
                try {
                    Method method;
                    Object object4;
                    Field field3 = object3.getClass().getDeclaredField("value");
                    field3.setAccessible(true);
                    Object object5 = field3.get(object3);
                    if (object5 == null || !"GitQuarantineEnvironment".equals(object5.getClass().getSimpleName()) || !((object4 = (method = object5.getClass().getDeclaredMethod("asMap", new Class[0])).invoke(object5, new Object[0])) instanceof Map)) continue;
                    return (Map)object4;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            this.log.info(throwable.getMessage(), throwable);
        }
        return null;
    }

    @Nullable
    private Map getEnvironmentByGitCommand(Repository repository) {
        try {
            return (Map)((GitScmCommandBuilder)((GitScmCommandBuilder)this.commandBuilderFactory.builder(repository).withConfiguration("alias.env", "!env")).command("env")).build((CommandOutputHandler)new SgEnvironmentCommandOutputHandler()).synchronous().call();
        }
        catch (Throwable throwable) {
            this.log.info(throwable.getMessage(), throwable);
            return null;
        }
    }

    protected List getObjectsListByGitCommand(Repository repository, List list) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            for (i i2 : list) {
                N n2 = i2.c();
                if (N.a().equals(n2)) continue;
                byteArrayOutputStream.write(n2.toString().getBytes());
                byteArrayOutputStream.write(10);
                N n3 = i2.b();
                if (N.a().equals(n3)) continue;
                byteArrayOutputStream.write(94);
                byteArrayOutputStream.write(n3.toString().getBytes());
                byteArrayOutputStream.write(10);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (List)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)this.commandBuilderFactory.builder(repository).argument("--stdin")).argument("--objects")).inputHandler((CommandInputHandler)new SgCommandInputHandler(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())))).command("rev-list")).build((CommandOutputHandler)new SgObjectsListCommandOutputHandler()).synchronous().call();
    }

    protected void runPackObjects(Repository repository, List list, File file) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            for (N n2 : list) {
                byteArrayOutputStream.write(n2.toString().getBytes());
                byteArrayOutputStream.write(10);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)this.commandBuilderFactory.builder(repository).argument("--delta-base-offset")).argument("-q")).argument("--stdout")).inputHandler((CommandInputHandler)new SgCommandInputHandler(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())))).command("pack-objects")).build((CommandOutputHandler)new PathOutputHandler(file.toPath())).synchronous().call();
    }
}

