/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.web.hooks;

import com.a.a.a.b.k;
import com.a.a.a.d.N;
import com.a.a.a.d.U;
import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.hook.ScmHookDetails;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.event.api.EventListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.eclipse.jgit.lib.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgGitRepositoryFactory;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTsConsole;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTaskParameters;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTaskParameters$Builder;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTaskParameters$Command;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryAccessType;
import org.tmatesoft.subgit.stash.mirror.util.SgFileUtil;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.web.hooks.Sg6xPreReceiveRepositoryHook$1;
import org.tmatesoft.subgit.stash.web.hooks.SgAbstractPreReceiveRepositoryHook;
import org.tmatesoft.translator.e.i;
import org.tmatesoft.translator.k.n;
import org.tmatesoft.translator.m.d.c;
import org.tmatesoft.translator.util.f;

public class Sg6xPreReceiveRepositoryHook
extends SgAbstractPreReceiveRepositoryHook
implements PreRepositoryHook {
    private RefService refService;

    public Sg6xPreReceiveRepositoryHook(RefService refService, SgMirrorService sgMirrorService, SgTaskSchedulerService sgTaskSchedulerService, SgLoggerFactory sgLoggerFactory, GitCommandBuilderFactory gitCommandBuilderFactory, SgGitRepositoryFactory sgGitRepositoryFactory) {
        super(sgMirrorService, sgLoggerFactory, sgTaskSchedulerService, gitCommandBuilderFactory, sgGitRepositoryFactory);
        this.refService = refService;
    }

    @EventListener
    public void onRefChange(RepositoryRefsChangedEvent repositoryRefsChangedEvent) {
        if (repositoryRefsChangedEvent == null) {
            return;
        }
        this.logEvent(SgMirrorScope.forRepository(repositoryRefsChangedEvent.getRepository()), repositoryRefsChangedEvent.getClass(), repositoryRefsChangedEvent.getRefChanges());
        Repository repository = repositoryRefsChangedEvent.getRepository();
        SgMirrorStage sgMirrorStage = this.getMirrorStage(repository);
        if (!Sg6xPreReceiveRepositoryHook.isActiveMirrorStage(sgMirrorStage)) {
            return;
        }
        String string = repositoryRefsChangedEvent.getClass().getSimpleName();
        Collection collection = repositoryRefsChangedEvent.getRefChanges();
        boolean bl2 = string.indexOf("Deleted") > 0 ? collection.size() == 1 && ObjectId.zeroId().name().equals(((RefChange)collection.iterator().next()).getFromHash()) : false;
        try {
            SgPushTaskParameters$Builder sgPushTaskParameters$Builder = SgPushTaskParameters.builder();
            if ("PullRequestSourceBranchDeletedEvent".equals(string)) {
                sgPushTaskParameters$Builder.setRefDeltas(this.getRefDeltas(repository, collection, bl2));
                sgPushTaskParameters$Builder.addCommandFor(SgMirrorStage.INSTALLED, SgPushTaskParameters$Command.SYNC_WITH_DELTAS);
                sgPushTaskParameters$Builder.addCommandFor(SgMirrorStage.INSTALLED, SgPushTaskParameters$Command.SYNC);
                sgPushTaskParameters$Builder.addCommandFor(SgMirrorStage.EXTERNAL_REMOTE, SgPushTaskParameters$Command.PRE_RECEIVE);
                sgPushTaskParameters$Builder.addCommandFor(SgMirrorStage.EXTERNAL_REMOTE, SgPushTaskParameters$Command.FETCH);
                sgPushTaskParameters$Builder.addCommandFor(SgMirrorStage.EXTERNAL_LOCAL, SgPushTaskParameters$Command.PRE_RECEIVE);
                sgPushTaskParameters$Builder.addCommandFor(SgMirrorStage.EXTERNAL_LOCAL, SgPushTaskParameters$Command.POST_RECEIVE);
            } else if ("BranchCreatedEvent".equals(string) || "BranchChangedEvent".equals(string) || "BranchDeletedEvent".equals(string) || "TagCreatedEvent".equals(string) || "TagChangedEvent".equals(string) || "TagDeletedEvent".equals(string) || "FileEditedEvent".equals(string) || string.endsWith("PullRequestMergedEvent")) {
                sgPushTaskParameters$Builder.setRefDeltas(this.getRefDeltas(repository, collection, bl2));
                sgPushTaskParameters$Builder.addCommandFor(SgMirrorStage.EXTERNAL_REMOTE, SgPushTaskParameters$Command.PRE_RECEIVE);
                sgPushTaskParameters$Builder.addCommandFor(SgMirrorStage.EXTERNAL_REMOTE, SgPushTaskParameters$Command.FETCH);
                sgPushTaskParameters$Builder.addCommandFor(SgMirrorStage.EXTERNAL_LOCAL, SgPushTaskParameters$Command.PRE_RECEIVE);
                sgPushTaskParameters$Builder.addCommandFor(SgMirrorStage.EXTERNAL_LOCAL, SgPushTaskParameters$Command.POST_RECEIVE);
            }
            sgPushTaskParameters$Builder.setConsole(new SgTsConsole(this.getDevNull()));
            SgPushTaskParameters sgPushTaskParameters = sgPushTaskParameters$Builder.build();
            this.runPushTask(repository, sgMirrorStage, sgPushTaskParameters, false);
        }
        catch (SgException | f exception) {
            this.log.info(exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    @EventListener
    public void onRepositoryDeletionRequest(RepositoryDeletionRequestedEvent repositoryDeletionRequestedEvent) {
        super.onRepositoryDeletionRequest(repositoryDeletionRequestedEvent);
    }

    @Override
    @EventListener
    public void onProjectDeletionRequest(ProjectDeletionRequestedEvent projectDeletionRequestedEvent) {
        super.onProjectDeletionRequest(projectDeletionRequestedEvent);
    }

    @Override
    @EventListener
    public void onRepositoryModified(RepositoryModifiedEvent repositoryModifiedEvent) {
        super.onRepositoryModified(repositoryModifiedEvent);
    }

    @NotNull
    private List getRefDeltas(Repository repository, Collection collection) {
        return this.getRefDeltas(repository, collection, false);
    }

    @NotNull
    private List getRefDeltas(Repository repository, Collection collection, boolean bl2) {
        ArrayList<i> arrayList = new ArrayList<i>(collection.size());
        for (RefChange refChange : collection) {
            if (!i.c(refChange.getRef().getId())) continue;
            arrayList.add(this.getRefDelta(repository, refChange, bl2));
        }
        return arrayList;
    }

    private i getRefDelta(Repository repository, RefChange refChange, boolean bl2) {
        if (!bl2) {
            return new i(U.b(refChange.getRef().getId()), this.toObjectId(repository, refChange.getFromHash()), this.toObjectId(repository, refChange.getToHash()));
        }
        return new i(U.b(refChange.getRef().getId()), this.toObjectId(repository, refChange.getToHash()), this.toObjectId(repository, refChange.getFromHash()));
    }

    private N toObjectId(Repository repository, String string) {
        try {
            N n2 = N.b(string);
            if (n2 == null) {
                return N.a();
            }
            return n2;
        }
        catch (k k2) {
            Ref ref = this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(string).build());
            if (ref != null) {
                return this.toObjectId(repository, ref.getLatestCommit());
            }
            throw f.c(k2, "Failed to parse commit ID '%s'", string);
        }
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext preRepositoryHookContext, @Nonnull RepositoryHookRequest repositoryHookRequest) {
        PrintWriter printWriter;
        PrintWriter printWriter2;
        Repository repository = repositoryHookRequest.getRepository();
        Collection collection = repositoryHookRequest.getRefChanges();
        this.logEvent(SgMirrorScope.forRepository(repository), "PreUpdate (" + repositoryHookRequest.getTrigger().getId() + ", dry run: " + repositoryHookRequest.isDryRun() + ")", collection);
        SgMirrorStage sgMirrorStage = this.getMirrorStage(repositoryHookRequest.getRepository());
        if (repositoryHookRequest.isDryRun() || !Sg6xPreReceiveRepositoryHook.isActiveMirrorStage(sgMirrorStage)) {
            return RepositoryHookResult.accepted();
        }
        if (sgMirrorStage == SgMirrorStage.PENDING_METADATA_MOVE) {
            String string = this.rejectSyncOnPendingMetadataMove(repository);
            return this.rejected(string, string, "processing " + repositoryHookRequest.getTrigger().getId());
        }
        Map map = this.getPreUpdateEnvironment(repository);
        if (repositoryHookRequest.getScmHookDetails().isPresent()) {
            printWriter2 = ((ScmHookDetails)repositoryHookRequest.getScmHookDetails().get()).out();
            printWriter = ((ScmHookDetails)repositoryHookRequest.getScmHookDetails().get()).err();
        } else {
            this.log.info("no scm hook details provided, using stubs");
            printWriter2 = new PrintWriter(SgFileUtil.NULL_OUTPUT_STREAM);
            printWriter = new PrintWriter(SgFileUtil.NULL_OUTPUT_STREAM);
        }
        if (!preRepositoryHookContext.registerCommitCallback((PreRepositoryHookCommitCallback)new Sg6xPreReceiveRepositoryHook$1(this, repository, sgMirrorStage, collection, map, printWriter2, printWriter, repositoryHookRequest), RepositoryHookCommitFilter.ADDED_TO_ANY_REF, new RepositoryHookCommitFilter[]{RepositoryHookCommitFilter.REMOVED_FROM_ANY_REF})) {
            this.log.info("failed to register commit callback, request was vetoed by another hook");
        } else {
            this.log.info("commit callback registered successfully");
        }
        return RepositoryHookResult.accepted();
    }

    @NotNull
    private RepositoryHookResult rejected(@Nullable String string, @Nullable String string2, @NotNull String string3) {
        String string4 = String.format("An error occurred while %s.", string3);
        return RepositoryHookResult.rejected((String)(string == null ? string4 : string), (String)(string2 == null ? string4 : string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String onReceive(Repository repository, SgMirrorStage sgMirrorStage, Collection collection, Map map, PrintWriter printWriter, PrintWriter printWriter2) {
        Object object;
        SgTsConsole sgTsConsole = new SgTsConsole(this.getHookConsole(printWriter, printWriter2));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : collection) {
            object = object2.getRef().getId();
            if (i.c(object)) continue;
            arrayList.add((String)object);
        }
        if (arrayList.size() > 0) {
            this.log.info("an attempt to push references with a non-ASCII character: [" + String.join((CharSequence)",", arrayList) + "] to [R-" + repository.getId() + "], rejecting");
            return n.f(arrayList);
        }
        Object object3 = null;
        try {
            Object object4;
            Object object2;
            object2 = this.getRefDeltas(repository, collection);
            object = this.gitRepositoryFactory.getAccessType(repository);
            if (object == SgRepositoryAccessType.CMDLINE && !object2.isEmpty()) {
                this.log.info("running pack objects for [R-" + repository.getId() + "]");
                object4 = this.getObjectsListByGitCommand(repository, (List)object2);
                File file = this.createTempPackFile(repository);
                this.runPackObjects(repository, (List)object4, file);
                object3 = file.getAbsolutePath();
            }
            this.log.info("scheduling push task for [R-" + repository.getId() + "]");
            object4 = SgPushTaskParameters.builder().setConsole(sgTsConsole).setRefDeltas((Collection)object2).setEnvironment(map).setCollectFromQuarantine(true).setPackFilePath((String)object3).setEnvironment(map).addCommandFor(SgMirrorStage.INSTALLED, SgPushTaskParameters$Command.SYNC_WITH_DELTAS).build();
            this.runPushTask(repository, sgMirrorStage, (SgPushTaskParameters)object4, true);
        }
        catch (Throwable throwable) {
            this.log.info(throwable.getMessage(), throwable);
            object = throwable.getMessage();
            String string = object == null ? "" : object;
            return string;
        }
        finally {
            sgTsConsole.flush();
        }
        return null;
    }

    private File createTempPackFile(Repository repository) {
        File file = this.mirrorService.getMetadataDirectory(repository);
        c c2 = c.b(file);
        File file2 = c2.s();
        try {
            return File.createTempFile("temp-", ".pack", file2);
        }
        catch (IOException iOException) {
            throw f.b(iOException);
        }
    }
}

