/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.web;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.cmdline.SgEnvironmentCommandOutputHandler;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.web.SgPluginPropertiesService$ExitCodeHandler;
import org.tmatesoft.subgit.stash.web.SgPluginPropertiesService$PathOutputHandler;
import org.tmatesoft.translator.m.O;
import org.tmatesoft.translator.m.Z;
import org.tmatesoft.translator.util.f;

public class SgPluginPropertiesService {
    public static final String PLUGIN_FQ_NAME = "org.tmatesoft.subgit.stash-svn-importer";
    private static final Duration PATH_RESOLUTION_TIMEOUT = Duration.of(1L, ChronoUnit.MINUTES);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final StorageService storageService;
    private final PluginAccessor pluginAccessor;
    private final ClusterService clusterService;
    private final GitCommandBuilderFactory commandBuilderFactory;

    public SgPluginPropertiesService(ApplicationPropertiesService applicationPropertiesService, StorageService storageService, PluginAccessor pluginAccessor, ClusterService clusterService, GitCommandBuilderFactory gitCommandBuilderFactory) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.storageService = storageService;
        this.pluginAccessor = pluginAccessor;
        this.clusterService = clusterService;
        this.commandBuilderFactory = gitCommandBuilderFactory;
    }

    public String getPluginVersion() {
        Plugin plugin = this.pluginAccessor.getPlugin(PLUGIN_FQ_NAME);
        if (plugin != null && plugin.getPluginInformation() != null) {
            return plugin.getPluginInformation().getVersion();
        }
        return "unknown";
    }

    public Version getParsedServerVersion() {
        return new Version(this.applicationPropertiesService.getBuildVersion());
    }

    public String getServerVersion() {
        return this.applicationPropertiesService.getBuildVersion() + " " + this.applicationPropertiesService.getBuildNumber();
    }

    public String getServerInformation() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("server ");
        stringBuilder.append(this.getServerVersion());
        stringBuilder.append("; ");
        Plugin plugin = this.pluginAccessor.getPlugin(PLUGIN_FQ_NAME);
        if (plugin == null) {
            stringBuilder.append("add-on unknown");
        } else {
            stringBuilder.append("add-on ");
            stringBuilder.append(plugin.getPluginInformation().getVersion());
        }
        stringBuilder.append("; ");
        Set set = this.clusterService.getInformation().getNodes();
        if (set.isEmpty()) {
            stringBuilder.append("cluster is empty");
        } else if (set.size() == 1) {
            stringBuilder.append("single node server");
        } else {
            stringBuilder.append("cluster has ");
            stringBuilder.append(set.size());
            stringBuilder.append(" nodes");
        }
        return stringBuilder.toString();
    }

    @NotNull
    public File getSubGitDirectory() {
        return new File(this.storageService.getSharedHomeDir().toFile(), "data/subgit");
    }

    @NotNull
    public File getMetadataDirectory(int n2) {
        return new File(this.getSubGitDirectory(), "repositories/" + n2);
    }

    @NotNull
    public File getMetadataDirectory(com.atlassian.bitbucket.repository.Repository repository) {
        return this.getMetadataDirectory(repository.getId());
    }

    @NotNull
    public File getRepositoryDirectory(@NotNull com.atlassian.bitbucket.repository.Repository repository, SgLoggerFactory sgLoggerFactory) {
        Logger logger = sgLoggerFactory.getLogger("repository-path");
        logger.info("detecting repository path for repository " + repository.getId() + ": " + repository.getProject().getName() + "/" + repository.getName());
        File file = SgPluginPropertiesService.getRepositoryDirWithReflection(this.storageService, repository, logger);
        if (SgPluginPropertiesService.isValidRepositoryDirectory(file, logger)) {
            return file;
        }
        logger.info("falling back to 'git rev-parse' method");
        file = this.revParseGitDir(repository, logger);
        if (file == null) {
            logger.info("falling back to 'git pwd' method");
            file = this.gitPwd(repository, logger);
        }
        if (file == null) {
            throw new SgException("Failed to locate repository " + repository.getProject().getName() + "/" + repository.getName() + " on the file system");
        }
        return file;
    }

    @Nullable
    private File revParseGitDir(@NotNull com.atlassian.bitbucket.repository.Repository repository, Logger logger) {
        SgPluginPropertiesService$ExitCodeHandler sgPluginPropertiesService$ExitCodeHandler = new SgPluginPropertiesService$ExitCodeHandler();
        GitCommand gitCommand = ((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)this.commandBuilderFactory.builder(repository).command("rev-parse")).argument("--absolute-git-dir")).exitHandler((CommandExitHandler)sgPluginPropertiesService$ExitCodeHandler)).build((CommandOutputHandler)new SgPluginPropertiesService$PathOutputHandler());
        gitCommand.setIdleTimeout(PATH_RESOLUTION_TIMEOUT);
        gitCommand.setExecutionTimeout(PATH_RESOLUTION_TIMEOUT);
        gitCommand.setTimeout(PATH_RESOLUTION_TIMEOUT);
        File file = null;
        try {
            file = (File)gitCommand.synchronous().call();
        }
        catch (Throwable throwable) {
            logger.info(throwable.getMessage(), throwable);
        }
        if (sgPluginPropertiesService$ExitCodeHandler.hasErrors()) {
            sgPluginPropertiesService$ExitCodeHandler.logErrors(logger);
            return null;
        }
        if (!SgPluginPropertiesService.isValidRepositoryDirectory(file, logger)) {
            return null;
        }
        return file;
    }

    @Nullable
    private File gitPwd(@NotNull com.atlassian.bitbucket.repository.Repository repository, Logger logger) {
        SgPluginPropertiesService$ExitCodeHandler sgPluginPropertiesService$ExitCodeHandler = new SgPluginPropertiesService$ExitCodeHandler();
        GitCommand gitCommand = ((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)this.commandBuilderFactory.builder(repository).withConfiguration("alias.pwd", "!pwd")).command("pwd")).exitHandler((CommandExitHandler)sgPluginPropertiesService$ExitCodeHandler)).build((CommandOutputHandler)new SgPluginPropertiesService$PathOutputHandler());
        gitCommand.setIdleTimeout(PATH_RESOLUTION_TIMEOUT);
        gitCommand.setExecutionTimeout(PATH_RESOLUTION_TIMEOUT);
        gitCommand.setTimeout(PATH_RESOLUTION_TIMEOUT);
        File file = null;
        try {
            file = (File)gitCommand.synchronous().call();
        }
        catch (Throwable throwable) {
            logger.info(throwable.getMessage(), throwable);
        }
        if (sgPluginPropertiesService$ExitCodeHandler.hasErrors()) {
            sgPluginPropertiesService$ExitCodeHandler.logErrors(logger);
            return null;
        }
        if (!SgPluginPropertiesService.isValidRepositoryDirectory(file, logger)) {
            logger.info("falling back to 'git env' method");
            return this.parseGitEnvironment(repository, file, logger);
        }
        return file;
    }

    @Nullable
    private File parseGitEnvironment(@NotNull com.atlassian.bitbucket.repository.Repository repository, @Nullable File file, Logger logger) {
        File file2;
        File file3;
        SgPluginPropertiesService$ExitCodeHandler sgPluginPropertiesService$ExitCodeHandler = new SgPluginPropertiesService$ExitCodeHandler();
        GitCommand gitCommand = ((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)this.commandBuilderFactory.builder(repository).withConfiguration("alias.env", "!env")).command("env")).exitHandler((CommandExitHandler)sgPluginPropertiesService$ExitCodeHandler)).build((CommandOutputHandler)new SgEnvironmentCommandOutputHandler());
        gitCommand.setIdleTimeout(PATH_RESOLUTION_TIMEOUT);
        gitCommand.setExecutionTimeout(PATH_RESOLUTION_TIMEOUT);
        gitCommand.setTimeout(PATH_RESOLUTION_TIMEOUT);
        Map map = null;
        try {
            map = (Map)gitCommand.synchronous().call();
        }
        catch (Throwable throwable) {
            logger.info(throwable.getMessage(), throwable);
        }
        if (map == null) {
            logger.info("no environment collected");
            return null;
        }
        logger.info("parsing environment:\n" + String.valueOf(map));
        if (sgPluginPropertiesService$ExitCodeHandler.hasErrors()) {
            sgPluginPropertiesService$ExitCodeHandler.logErrors(logger);
            return null;
        }
        String string = (String)map.get("GIT_DIR");
        File file4 = file3 = string == null ? null : new File(string);
        if (file3 != null && file3.isAbsolute() && SgPluginPropertiesService.isValidRepositoryDirectory(file3, logger)) {
            return file3;
        }
        if (file != null && file.isAbsolute() && string != null && SgPluginPropertiesService.isValidRepositoryDirectory(file2 = new File(file, string), logger)) {
            return file2;
        }
        return null;
    }

    public static boolean isValidRepositoryDirectory(@Nullable File file, Logger logger) {
        if (file == null) {
            return false;
        }
        O o2 = new O();
        Repository repository = o2.createGitRepositoryInstance(Z.a(file), true);
        try {
            logger.info("valid repository directory: {}", (Object)file);
            boolean bl2 = true;
            if (repository != null) {
                repository.close();
            }
            return bl2;
        }
        catch (Throwable throwable) {
            try {
                if (repository != null) {
                    try {
                        repository.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (f f2) {
                logger.info("repository directory {} is invalid: {}", (Object)file, (Object)f2.getMessage());
                return false;
            }
        }
    }

    private static File getRepositoryDirWithReflection(Object object, com.atlassian.bitbucket.repository.Repository repository, Logger logger) {
        Object object2;
        Object object3;
        Object object4;
        Object object5 = null;
        while (object != null) {
            try {
                object4 = Proxy.getInvocationHandler(object);
                if (object4 == null) {
                    return null;
                }
                object = SgPluginPropertiesService.getFieldValue(object4, "service");
                if (object != null) continue;
                object3 = SgPluginPropertiesService.getFieldValue(object4, "advised");
                if (object3 != null && (object2 = SgPluginPropertiesService.getFieldValue(object3, "targetSource")) != null) {
                    object5 = SgPluginPropertiesService.getFieldValue(object2, "target");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = null;
        }
        if (object5 == null) {
            logger.info("failed to find dmzStorageService");
            return null;
        }
        object4 = "getRepositoryDir";
        object3 = SgPluginPropertiesService.getMethod(object5, "getRepositoryDir", new Class[]{com.atlassian.bitbucket.repository.Repository.class});
        if (object3 == null) {
            logger.info("failed to find method {}", (Object)"getRepositoryDir");
            return null;
        }
        try {
            ((Method)object3).setAccessible(true);
            object2 = ((Method)object3).invoke(object5, repository);
            if (object2 instanceof Path) {
                return ((Path)object2).toFile();
            }
        }
        catch (Throwable throwable) {
            logger.info("failed to invoke method {}: {}", (Object)"getRepositoryDir", (Object)throwable.getMessage());
        }
        return null;
    }

    private static Method getMethod(Object object, String string, Class[] classArray) {
        Class<?> clazz = object.getClass();
        while (true) {
            try {
                return clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ((clazz = clazz.getSuperclass()) != null && clazz != Object.class) continue;
                return null;
            }
            break;
        }
    }

    private static Object getFieldValue(Object object, String string) {
        Class<?> clazz = object.getClass();
        while (true) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                return field.get(object);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                if ((clazz = clazz.getSuperclass()) != null && clazz != Object.class) continue;
                return null;
            }
            break;
        }
    }
}

