/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.web;

import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.RepositoryCacheConfig;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgBootstrapJobRunner;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsService;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.util.SgCleanupJobRunner;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.web.SgLicenseManager;
import org.tmatesoft.subgit.stash.web.SgPluginManager$1;
import org.tmatesoft.subgit.stash.web.SgPluginPropertiesService;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.translator.b.g;
import org.tmatesoft.translator.m.aY;
import org.tmatesoft.translator.util.r;
import org.tmatesoft.translator.util.u;

public class SgPluginManager
implements LifecycleAware {
    private static final long CLEANUP_INTERVAL = 300000L;
    private static final int BOOTSTRAP_DELAY = 10000;
    private static final int BOOTSTRAP_INTERVAL = 180000;
    private static final String CONFIG_BUNDLE_NAME = "org.tmatesoft.translator.client.svnmirror-config";
    private StorageService storageService;
    private final Logger log;
    private final SgTaskSchedulerService taskSchedulerService;
    private final SgLoggerFactory loggerFactory;
    private final SgJsonService jsonService;
    private final SgLicenseManager licenseManager;
    private final SchedulerService schedulerService;
    private final SgPluginPropertiesService pluginPropertiesService;
    private final SgSettingsService settingsService;
    private final AtomicBoolean pluginActive;

    public SgPluginManager(StorageService storageService, SgLoggerFactory sgLoggerFactory, SgTaskSchedulerService sgTaskSchedulerService, SgJsonService sgJsonService, SgLicenseManager sgLicenseManager, SchedulerService schedulerService, SgPluginPropertiesService sgPluginPropertiesService, SgSettingsService sgSettingsService) {
        this.storageService = storageService;
        this.log = sgLoggerFactory.getLogger("manager");
        this.pluginPropertiesService = sgPluginPropertiesService;
        this.settingsService = sgSettingsService;
        this.loggerFactory = sgLoggerFactory;
        this.jsonService = sgJsonService;
        this.licenseManager = sgLicenseManager;
        this.schedulerService = schedulerService;
        this.taskSchedulerService = sgTaskSchedulerService;
        this.pluginActive = new AtomicBoolean(true);
        this.log.info("SgPluginManager INSTANCE CREATED");
    }

    public void onStart() {
        this.log.info("ON START");
        this.initializePlugin();
        this.log.info("instance registered within event publisher");
        this.log.info(this.pluginPropertiesService.getServerInformation());
    }

    public void onStop() {
        this.log.info("ON STOP");
        this.log.info(this.pluginPropertiesService.getServerInformation());
        try {
            this.shutdown();
            this.log.info("plugin shut down");
        }
        finally {
            this.log.info("plugin unregistered from event publishers");
        }
    }

    private void shutdown() {
        boolean bl2 = this.pluginActive.getAndSet(false);
        if (!bl2) {
            return;
        }
        try {
            this.licenseManager.onStop();
        }
        catch (Throwable throwable) {
            this.log.error("failed to shutdown license manager", throwable);
        }
        try {
            this.taskSchedulerService.shutdown();
        }
        catch (Throwable throwable) {
            this.log.error("failed to shutdown task scheduler service", throwable);
        }
        try {
            this.loggerFactory.shutdown();
        }
        catch (Throwable throwable) {
            this.log.error("failed to shutdown logger factory");
        }
    }

    private void initializePlugin() {
        this.log.info("add-on init sequence started");
        this.configureSVNKit();
        this.setupJGit();
        aY.b();
        SgPluginManager.initializeHashProvider();
        try {
            this.initializePlatform();
        }
        catch (IOException iOException) {
            this.log.error(iOException.getMessage(), (Throwable)iOException);
        }
        SgPluginManager.configureResourceBundle();
        g.b("subgit/stash.config");
        org.tmatesoft.translator.g.g.a();
        this.licenseManager.onStart(this.taskSchedulerService);
        this.scheduleRegularCleanup();
        this.scheduleRepositoriesUpgradeOrSync();
    }

    private static void configureResourceBundle() {
        u u2 = u.a();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(CONFIG_BUNDLE_NAME);
        u u3 = new u(u2.b(), u2.c(), resourceBundle);
        u.a(u3);
    }

    private void setupJGit() {
        SgSettings sgSettings = this.settingsService.createSettingsForScope(SgMirrorScope.global());
        long l2 = (Long)sgSettings.get(SgMirrorOption.REPOSITORY_CACHE_EXPIRE_DELAY, new SgSettingsType[0]);
        long l3 = (Long)sgSettings.get(SgMirrorOption.REPOSITORY_CACHE_CLEANUP_DELAY, new SgSettingsType[0]);
        RepositoryCacheConfig repositoryCacheConfig = new RepositoryCacheConfig();
        repositoryCacheConfig.setExpireAfter(l2);
        repositoryCacheConfig.setCleanupDelay(l3);
        aY.a(repositoryCacheConfig);
    }

    private void scheduleRegularCleanup() {
        this.schedulerService.registerJobRunner(SgCleanupJobRunner.KEY, (JobRunner)new SgCleanupJobRunner(this.log, this.jsonService, this.taskSchedulerService));
        try {
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)SgCleanupJobRunner.KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)300000L, (Date)new Date(System.currentTimeMillis() + 300000L)));
            this.schedulerService.scheduleJob(JobId.of((String)"org.tmatesoft.subgit:cleanup"), jobConfig);
            this.log.info("regular cleanup job scheduled");
        }
        catch (SchedulerServiceException schedulerServiceException) {
            this.log.info(schedulerServiceException.getMessage(), (Throwable)schedulerServiceException);
        }
    }

    private void scheduleRepositoriesUpgradeOrSync() {
        List list = this.schedulerService.getJobsByJobRunnerKey(JobRunnerKey.of((String)"org.tmatesoft.subgit:SubGitSyncJobRunner"));
        if (!list.isEmpty()) {
            this.log.info("there are legacy sync jobs present: " + list.size());
            for (JobDetails jobDetails : list) {
                this.schedulerService.unscheduleJob(jobDetails.getJobId());
                this.log.info("legacy sync job unscheduled: " + String.valueOf(jobDetails.getJobId()));
            }
        }
        this.schedulerService.registerJobRunner(SgBootstrapJobRunner.KEY, (JobRunner)new SgBootstrapJobRunner(this.taskSchedulerService, this.pluginActive, this.loggerFactory));
        try {
            long l2 = System.currentTimeMillis() + 10000L;
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)SgBootstrapJobRunner.KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)180000L, (Date)new Date(l2)));
            this.schedulerService.scheduleJob(JobId.of((String)"org.tmatesoft.subgit:bootstrap"), jobConfig);
            this.log.info("bootstrap scheduled");
        }
        catch (SchedulerServiceException schedulerServiceException) {
            this.log.info(schedulerServiceException.getMessage(), (Throwable)schedulerServiceException);
        }
    }

    public static void initializeHashProvider() {
        for (int i2 = 0; i2 < 16; ++i2) {
            try {
                MessageDigest messageDigest = Constants.newMessageDigest();
                if (messageDigest == null) continue;
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void configureSVNKit() {
        FSRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        DAVRepositoryFactory.setup();
        System.setProperty("svnkit.http.methods", "Basic,Digest,NTLM,Negotiate");
        String string = System.getProperty("svnkit.ssh.client");
        if (string == null) {
            System.setProperty("svnkit.ssh.client", "apache");
        }
        SVNDebugLog.setDefaultLog(new SgPluginManager$1(this));
    }

    private void initializePlatform() {
        File file = new File(this.storageService.getDataDir().toFile(), "subgit");
        File file2 = new File(file, "etc");
        File file3 = new File(file, "usr");
        r.b(file2);
        r.c(file3);
        Files.createDirectories(file2.toPath(), new FileAttribute[0]);
        Files.createDirectories(file3.toPath(), new FileAttribute[0]);
    }
}

