/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.web;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.google.gson.JsonElement;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.SgSupportZipService;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonService;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerSnapshot;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.svn.SgConnectionTest;
import org.tmatesoft.subgit.stash.mirror.svn.SgSubversionService;
import org.tmatesoft.subgit.stash.mirror.svn.SgSubversionService$Node;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.util.SgAuthorisationOptions;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.mirror.util.SgLongPollOptions;
import org.tmatesoft.subgit.stash.mirror.util.SgSupportZip;
import org.tmatesoft.subgit.stash.mirror.util.SgSupportZipRequest;
import org.tmatesoft.subgit.stash.web.SgMirrorRenderer;
import org.tmatesoft.subgit.stash.web.SgMirrorServlet$AuthorisationContext;
import org.tmatesoft.subgit.stash.web.SgMirrorServlet$CountingWriter;
import org.tmatesoft.subgit.stash.web.SgMirrorServlet$User;

public class SgMirrorServlet
extends HttpServlet {
    private static final long MAX_CHANNEL_DATA = 0x500000L;
    private static final long UPLOAD_FILE_SIZE_LIMIT = 10240L;
    private static final long LONG_POLL_HEARTBEAT_INTERVAL = 5000L;
    private final Logger log;
    private final RepositoryService repositoryService;
    private final ProjectService projectService;
    private final PermissionValidationService permissionValidationService;
    private final SgTaskSchedulerService taskSchedulerService;
    private final SgSubversionService subversionService;
    private final SgJsonService jsonService;
    private final SgMirrorService mirrorService;
    private final SgMirrorRenderer mirrorRenderer;
    private final SgSupportZipService supportZipService;
    private final NavBuilder navBuilder;
    private final UserService userService;
    private final AuthenticationContext authenticationContext;

    public SgMirrorServlet(RepositoryService repositoryService, ProjectService projectService, PermissionValidationService permissionValidationService, AuthenticationContext authenticationContext, UserService userService, NavBuilder navBuilder, SgSubversionService sgSubversionService, SgTaskSchedulerService sgTaskSchedulerService, SgJsonService sgJsonService, SgMirrorService sgMirrorService, SgSupportZipService sgSupportZipService, SgLoggerFactory sgLoggerFactory, SgMirrorRenderer sgMirrorRenderer) {
        this.log = sgLoggerFactory.getLogger("servlet");
        this.navBuilder = navBuilder;
        this.userService = userService;
        this.authenticationContext = authenticationContext;
        this.mirrorRenderer = sgMirrorRenderer;
        this.repositoryService = repositoryService;
        this.permissionValidationService = permissionValidationService;
        this.taskSchedulerService = sgTaskSchedulerService;
        this.subversionService = sgSubversionService;
        this.jsonService = sgJsonService;
        this.mirrorService = sgMirrorService;
        this.projectService = projectService;
        this.supportZipService = sgSupportZipService;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SgMirrorServlet$AuthorisationContext sgMirrorServlet$AuthorisationContext = this.authoriseAccess(httpServletRequest, httpServletResponse, hashMap);
        if (sgMirrorServlet$AuthorisationContext == null) {
            return;
        }
        String string = httpServletRequest.getParameter("command");
        if ("get".equals(string)) {
            httpServletResponse.setStatus(200);
            try {
                this.doPollMirrorState(sgMirrorServlet$AuthorisationContext.getScope(), httpServletRequest, httpServletResponse, sgMirrorServlet$AuthorisationContext, false);
            }
            catch (Throwable throwable) {
                this.log.info(throwable.getMessage());
                try {
                    this.writeErrorObject(sgMirrorServlet$AuthorisationContext.getScope(), httpServletResponse, this.subversionService.getErrorMessage(throwable));
                    httpServletResponse.getWriter().write("\r\n");
                }
                catch (IOException iOException) {
                    this.log.info(iOException.getMessage());
                }
            }
        } else {
            hashMap.put("longPollOptions", this.mirrorService.createSettings(sgMirrorServlet$AuthorisationContext.getScope()).get(SgMirrorOption.LONG_POLL_OPTIONS, new SgSettingsType[0]));
            this.mirrorRenderer.render(sgMirrorServlet$AuthorisationContext.getScope(), hashMap, SgMirrorServlet.getScopePath(sgMirrorServlet$AuthorisationContext.getScope(), SgMirrorServlet.getPathParts(httpServletRequest)), httpServletRequest, httpServletResponse);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block17: {
            SgMirrorScope sgMirrorScope = this.getRequestScope(httpServletRequest, null);
            if (sgMirrorScope == null) {
                return;
            }
            String string = httpServletRequest.getParameter("command");
            httpServletResponse.setStatus(200);
            try {
                Object object;
                Serializable serializable;
                SgMirrorServlet$AuthorisationContext sgMirrorServlet$AuthorisationContext = this.authoriseAccess(sgMirrorScope, string);
                if (string == null) {
                    throw new SgException("Command name parameter missing");
                }
                if ("get-subversion-tree".equals(string)) {
                    this.doSendSubversionTreeNodes(sgMirrorScope, httpServletRequest, httpServletResponse);
                    break block17;
                }
                if ("test-connection".equals(string)) {
                    this.doTestConnection(sgMirrorScope, httpServletRequest, httpServletResponse);
                    break block17;
                }
                if ("poll".equals(string)) {
                    this.doPollMirrorState(sgMirrorScope, httpServletRequest, httpServletResponse, sgMirrorServlet$AuthorisationContext, true);
                    break block17;
                }
                if ("get".equals(string)) {
                    this.doPollMirrorState(sgMirrorScope, httpServletRequest, httpServletResponse, sgMirrorServlet$AuthorisationContext, false);
                    break block17;
                }
                if ("upload-file".equals(string)) {
                    this.doReceiveFile(sgMirrorScope, httpServletRequest, httpServletResponse);
                    break block17;
                }
                if ("build-support-zip".equals(string)) {
                    this.doBuildSupportZip(sgMirrorScope, httpServletRequest, httpServletResponse, sgMirrorServlet$AuthorisationContext);
                    break block17;
                }
                if ("remove-support-zips".equals(string)) {
                    this.doRemoveSupportZips(sgMirrorScope, httpServletResponse);
                    break block17;
                }
                if ("cancel".equals(string)) {
                    SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = this.readSnapshot(sgMirrorScope, httpServletRequest);
                    long l2 = this.taskSchedulerService.getScheduler().cancelTask(sgMirrorScope, sgTaskSchedulerSnapshot.getTask().getId());
                    this.writeObject(sgMirrorScope, Collections.singletonMap("taskId", l2), httpServletResponse.getWriter());
                    break block17;
                }
                if ("bootstrap".equals(string)) {
                    serializable = null;
                } else {
                    object = this.readSnapshot(sgMirrorScope, httpServletRequest);
                    serializable = ((SgTaskSchedulerSnapshot)object).getData();
                }
                object = this.taskSchedulerService.getScheduler().schedule(sgMirrorScope, string, serializable);
                if (object != null && object.getState() != SgTaskState.REJECTED) {
                    this.writeObject(sgMirrorScope, Collections.singletonMap("taskId", object.getId()), httpServletResponse.getWriter());
                    break block17;
                }
                throw new SgException("Failed to schedule task '" + string + "'");
            }
            catch (Throwable throwable) {
                this.log.info(throwable.getMessage());
                try {
                    this.writeErrorObject(sgMirrorScope, httpServletResponse, this.subversionService.getErrorMessage(throwable));
                    httpServletResponse.getWriter().write("\r\n");
                }
                catch (IOException iOException) {
                    this.log.info(iOException.getMessage());
                }
            }
        }
    }

    private SgMirrorServlet$AuthorisationContext authoriseAccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) {
        try {
            this.permissionValidationService.validateAuthenticated();
        }
        catch (AuthorisationException authorisationException) {
            if (map != null) {
                String string = httpServletRequest.getRequestURL().toString();
                String string2 = ((NavBuilder.Login)this.navBuilder.login().next(string)).buildRelative();
                httpServletResponse.sendRedirect(string2);
            } else {
                httpServletResponse.sendError(401);
            }
            return null;
        }
        SgMirrorScope sgMirrorScope = this.getRequestScope(httpServletRequest, map);
        if (sgMirrorScope == null) {
            httpServletResponse.sendError(404);
            return null;
        }
        try {
            return this.authoriseAccess(sgMirrorScope, null);
        }
        catch (SgException sgException) {
            httpServletResponse.sendError(403);
            return null;
        }
    }

    private SgMirrorScope getRequestScope(HttpServletRequest httpServletRequest, Map map) {
        Project project;
        SgMirrorScope sgMirrorScope;
        String string;
        String[] stringArray = SgMirrorServlet.getPathParts(httpServletRequest);
        String string2 = stringArray.length > 1 && "projects".equalsIgnoreCase(stringArray[0]) ? stringArray[1] : null;
        String string3 = string = string2 != null && stringArray.length > 3 && "repos".equalsIgnoreCase(stringArray[2]) ? stringArray[3] : null;
        if (string2 != null && string != null) {
            Repository repository = this.repositoryService.getBySlug(string2, string);
            sgMirrorScope = repository != null ? SgMirrorScope.forRepository(repository) : null;
            project = repository;
        } else if (string2 != null) {
            Project project2 = this.projectService.getByKey(string2);
            sgMirrorScope = project2 != null ? SgMirrorScope.forProject(project2) : null;
            project = project2;
        } else {
            sgMirrorScope = SgMirrorScope.global();
            project = null;
        }
        if (map != null) {
            map.put("data", project);
            map.put("scope", sgMirrorScope);
        }
        return sgMirrorScope;
    }

    private SgMirrorServlet$AuthorisationContext authoriseAccess(SgMirrorScope sgMirrorScope, String string) {
        SgAuthorisationOptions sgAuthorisationOptions = (SgAuthorisationOptions)this.mirrorService.createSettings(SgMirrorScope.global()).get(SgMirrorOption.AUTHORISATION_OPTIONS, new SgSettingsType[0]);
        boolean bl2 = false;
        boolean bl3 = false;
        if (sgMirrorScope.isGlobal()) {
            try {
                this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                bl2 = true;
                bl3 = true;
            }
            catch (AuthorisationException authorisationException) {}
        } else {
            ApplicationUser applicationUser;
            try {
                this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                bl3 = true;
            }
            catch (AuthorisationException authorisationException) {
                // empty catch block
            }
            if (sgAuthorisationOptions.isGroupAuthorisationEnabled()) {
                applicationUser = this.authenticationContext.getCurrentUser();
                if (string == null || SgAuthorisationOptions.isImportGroupCommand(string)) {
                    bl2 = applicationUser != null && (this.userService.isUserInGroup(applicationUser, sgAuthorisationOptions.getMirrorGroupName()) || this.userService.isUserInGroup(applicationUser, sgAuthorisationOptions.getImportGroupName()));
                } else {
                    boolean bl4 = bl2 = applicationUser != null && this.userService.isUserInGroup(applicationUser, sgAuthorisationOptions.getMirrorGroupName());
                }
            }
            if (!bl2 && sgAuthorisationOptions.isAdminAuthorisationEnabled()) {
                if (sgMirrorScope.isRepository()) {
                    applicationUser = this.repositoryService.getById(sgMirrorScope.getRepositoryId());
                    if (applicationUser != null) {
                        try {
                            this.permissionValidationService.validateForRepository((Repository)applicationUser, Permission.REPO_ADMIN);
                            bl2 = true;
                        }
                        catch (AuthorisationException authorisationException) {}
                    }
                } else if (sgMirrorScope.isProject() && (applicationUser = this.projectService.getById(sgMirrorScope.getProjectId())) != null) {
                    try {
                        this.permissionValidationService.validateForProject((Project)applicationUser, Permission.PROJECT_ADMIN);
                        bl2 = true;
                    }
                    catch (AuthorisationException authorisationException) {
                        // empty catch block
                    }
                }
            }
        }
        if (!bl2) {
            throw new SgException("Logged in user is not authorised to perform this operation.");
        }
        return new SgMirrorServlet$AuthorisationContext(sgMirrorScope, new SgMirrorServlet$User(bl3));
    }

    private void doBuildSupportZip(SgMirrorScope sgMirrorScope, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SgMirrorServlet$AuthorisationContext sgMirrorServlet$AuthorisationContext) {
        SgSupportZipRequest sgSupportZipRequest = null;
        try {
            sgSupportZipRequest = (SgSupportZipRequest)this.jsonService.getGson().fromJson((Reader)httpServletRequest.getReader(), SgSupportZipRequest.class);
        }
        catch (Throwable throwable) {
            this.writeErrorObject(sgMirrorScope, httpServletResponse, throwable.getMessage());
        }
        try {
            boolean bl2 = sgSupportZipRequest != null && sgSupportZipRequest.isIncludeServerLogs() && sgMirrorServlet$AuthorisationContext.getUser().isAdmin();
            boolean bl3 = sgSupportZipRequest != null && sgSupportZipRequest.isIncludeGlobalLogs() && sgMirrorServlet$AuthorisationContext.getUser().isAdmin();
            boolean bl4 = sgMirrorServlet$AuthorisationContext.getUser().isAdmin();
            SgSupportZip sgSupportZip = this.supportZipService.createSupportArchive(sgMirrorScope, new SgSupportZipRequest("", bl2, bl3, bl4));
            this.writeObject(sgMirrorScope, sgSupportZip, httpServletResponse.getWriter());
        }
        catch (Throwable throwable) {
            this.writeErrorObject(sgMirrorScope, httpServletResponse, throwable.getMessage());
        }
    }

    private void doRemoveSupportZips(SgMirrorScope sgMirrorScope, HttpServletResponse httpServletResponse) {
        try {
            int n2 = this.supportZipService.removeSupportArchives(sgMirrorScope);
            this.writeObject(sgMirrorScope, Collections.singletonMap("filesRemoved", n2), httpServletResponse.getWriter());
        }
        catch (SgException sgException) {
            Map<String, String> map = Collections.singletonMap("error", sgException.getMessage());
            this.writeObject(sgMirrorScope, map, httpServletResponse.getWriter());
        }
    }

    private void doReceiveFile(SgMirrorScope sgMirrorScope, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean bl2 = JakartaServletFileUpload.isMultipartContent(httpServletRequest);
        if (!bl2) {
            throw new IOException("Unexpected request; multipart expected");
        }
        JakartaServletFileUpload jakartaServletFileUpload = new JakartaServletFileUpload(DiskFileItemFactory.builder().get());
        jakartaServletFileUpload.setFileSizeMax(10240L);
        jakartaServletFileUpload.setSizeMax(10240L);
        boolean bl3 = false;
        try {
            DiskFileItem diskFileItem;
            byte[] byArray;
            List list = jakartaServletFileUpload.parseRequest(httpServletRequest);
            if (list != null && list.size() > 0 && (byArray = (diskFileItem = (DiskFileItem)list.get(0)).get()) != null) {
                String string = this.jsonService.getStorage(sgMirrorScope).exchangeForKey(byArray);
                this.writeObject(sgMirrorScope, Collections.singletonMap("fileName", string), httpServletResponse.getWriter());
                bl3 = true;
            }
            if (!bl3) {
                this.writeErrorObject(sgMirrorScope, httpServletResponse, "No File Received");
            }
        }
        catch (FileUploadException fileUploadException) {
            this.writeErrorObject(sgMirrorScope, httpServletResponse, fileUploadException.getMessage());
        }
    }

    private void doTestConnection(SgMirrorScope sgMirrorScope, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        SgConnectionTest sgConnectionTest = this.subversionService.testConnection(this.readSettings(sgMirrorScope, httpServletRequest));
        this.writeObject(sgMirrorScope, sgConnectionTest, httpServletResponse.getWriter());
    }

    private void doSendSubversionTreeNodes(SgMirrorScope sgMirrorScope, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        SgSubversionService$Node[] sgSubversionService$NodeArray = this.subversionService.loadNodes(this.readSettings(sgMirrorScope, httpServletRequest));
        this.writeObject(sgMirrorScope, sgSubversionService$NodeArray, httpServletResponse.getWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPollMirrorState(SgMirrorScope sgMirrorScope, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SgMirrorServlet$AuthorisationContext sgMirrorServlet$AuthorisationContext, boolean bl2) {
        block18: {
            SgLongPollOptions sgLongPollOptions = (SgLongPollOptions)this.mirrorService.createSettings(sgMirrorScope).get(SgMirrorOption.LONG_POLL_OPTIONS, new SgSettingsType[0]);
            boolean bl3 = bl2 && sgLongPollOptions.isEnabled() && !SgMirrorServlet.hasConnectionCloseHeader(httpServletRequest);
            long l2 = sgLongPollOptions.getInterval() * 1000;
            long l3 = System.currentTimeMillis() + l2;
            Map<String, SgMirrorServlet$User> map = Collections.singletonMap("user", sgMirrorServlet$AuthorisationContext.getUser());
            long l4 = 0L;
            ISgTaskScheduler iSgTaskScheduler = this.taskSchedulerService.getScheduler();
            BlockingQueue blockingQueue = iSgTaskScheduler.obtainQueue(sgMirrorScope);
            String string = SgMirrorServlet.formatDate(new Date(System.currentTimeMillis() - 1000L));
            String string2 = SgMirrorServlet.formatDate(new Date());
            httpServletResponse.setContentType("application/json; charset=utf-8");
            httpServletResponse.setHeader("Expires", string);
            httpServletResponse.setHeader("Last-Modified", string2);
            httpServletResponse.setHeader("Cache-Control", "no-store");
            httpServletResponse.addHeader("Cache-Control", "no-cache");
            httpServletResponse.addHeader("Cache-Control", "private");
            httpServletResponse.setHeader("Pragma", "no-cache");
            this.jsonService.openSession(sgMirrorScope);
            try {
                boolean bl4;
                JsonElement jsonElement = null;
                do {
                    SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot;
                    Object object;
                    try {
                        if (bl3) {
                            object = null;
                            for (var20_17 = Math.max(100L, l3 - System.currentTimeMillis()); var20_17 >= 0L && (object = (SgTaskSchedulerSnapshot)blockingQueue.poll(Math.min(var20_17, 5000L), TimeUnit.MILLISECONDS)) == null; var20_17 -= 5000L) {
                                httpServletResponse.getWriter().write("\r\n");
                                httpServletResponse.getWriter().flush();
                            }
                            sgTaskSchedulerSnapshot = object;
                        } else {
                            sgTaskSchedulerSnapshot = (SgTaskSchedulerSnapshot)blockingQueue.poll(var20_17, TimeUnit.MILLISECONDS);
                        }
                        if (sgTaskSchedulerSnapshot != null && sgTaskSchedulerSnapshot.isShutdown()) {
                            throw new SgException("Add-on has been disabled");
                        }
                        if (sgTaskSchedulerSnapshot != null && ((SgSettingsSnapshot)sgTaskSchedulerSnapshot.getData()).get(SgMirrorOption.STAGE, new SgSettingsType[0]) == SgMirrorStage.MISSING) {
                            throw new SgException("This repository no longer exists");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.log.error(interruptedException.getMessage(), (Throwable)interruptedException);
                        break block18;
                    }
                    if (sgTaskSchedulerSnapshot != null) {
                        object = new SgMirrorServlet$CountingWriter(this, httpServletResponse.getWriter());
                        try {
                            jsonElement = this.jsonService.writeDiff(jsonElement, sgTaskSchedulerSnapshot, sgMirrorScope, map, (Writer)object);
                            ((SgMirrorServlet$CountingWriter)object).flush();
                            l4 += ((SgMirrorServlet$CountingWriter)object).getCount();
                        }
                        finally {
                            ((SgMirrorServlet$CountingWriter)object).close();
                        }
                    }
                    bl4 = SgMirrorServlet.isChannelExpired(l4, l3);
                } while (bl3 && !bl4);
                if (jsonElement == null) {
                    throw new SgException("Failed to retrieve data");
                }
            }
            finally {
                this.jsonService.releaseSession(sgMirrorScope);
                iSgTaskScheduler.releaseQueue(sgMirrorScope);
            }
        }
    }

    private SgSettingsSnapshot readSettings(SgMirrorScope sgMirrorScope, HttpServletRequest httpServletRequest) {
        SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = this.readSnapshot(sgMirrorScope, httpServletRequest);
        SgSettingsSnapshot sgSettingsSnapshot = (SgSettingsSnapshot)sgTaskSchedulerSnapshot.getData();
        sgSettingsSnapshot.setDefaults(this.mirrorService.createSettings(sgMirrorScope).snapshot(SgMirrorOption.all()));
        return sgSettingsSnapshot;
    }

    private SgTaskSchedulerSnapshot readSnapshot(SgMirrorScope sgMirrorScope, HttpServletRequest httpServletRequest) {
        return (SgTaskSchedulerSnapshot)this.jsonService.read(httpServletRequest.getReader(), sgMirrorScope, SgTaskSchedulerSnapshot.class);
    }

    private void writeErrorObject(SgMirrorScope sgMirrorScope, HttpServletResponse httpServletResponse, String string) {
        this.writeObject(sgMirrorScope, Collections.singletonMap("error", string), httpServletResponse.getWriter());
    }

    private void writeObject(SgMirrorScope sgMirrorScope, Object object, Writer writer) {
        this.jsonService.write(object, sgMirrorScope, writer);
    }

    private static boolean hasConnectionCloseHeader(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getHeaders("Connection");
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!"close".equalsIgnoreCase(string.trim())) continue;
            return true;
        }
        return false;
    }

    private static boolean isChannelExpired(long l2, long l3) {
        return l2 > 0x500000L || System.currentTimeMillis() > l3;
    }

    private static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(date);
    }

    @NotNull
    private static String[] getPathParts(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getPathInfo();
        return string == null || string.isEmpty() || string.equals("/") ? new String[]{} : string.substring(1).split("/");
    }

    @NotNull
    private static String[] getScopePath(SgMirrorScope sgMirrorScope, String[] stringArray) {
        String[] stringArray2;
        if (sgMirrorScope.isGlobal() && stringArray.length > 0) {
            stringArray2 = stringArray;
        } else if (sgMirrorScope.isProject() && stringArray.length > 2) {
            stringArray2 = new String[stringArray.length - 2];
            System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
        } else if (sgMirrorScope.isRepository() && stringArray.length > 4) {
            stringArray2 = new String[stringArray.length - 4];
            System.arraycopy(stringArray, 4, stringArray2, 0, stringArray2.length);
        } else {
            stringArray2 = new String[]{};
        }
        return stringArray2;
    }
}

