/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.web;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgSupportZipService;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonService;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgClusterStatus;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerSnapshot;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.util.SgFileUtil;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SgMirrorRenderer {
    private final SgJsonService jsonService;
    private final StorageService storageService;
    private final SgTaskSchedulerService taskSchedulerService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final RepositoryService repositoryService;
    private final SgMirrorService mirrorService;
    private final SgSupportZipService supportZipService;

    public SgMirrorRenderer(SgJsonService sgJsonService, StorageService storageService, SgTaskSchedulerService sgTaskSchedulerService, SgSupportZipService sgSupportZipService, SoyTemplateRenderer soyTemplateRenderer, RepositoryService repositoryService, SgMirrorService sgMirrorService) {
        this.jsonService = sgJsonService;
        this.storageService = storageService;
        this.taskSchedulerService = sgTaskSchedulerService;
        this.supportZipService = sgSupportZipService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.repositoryService = repositoryService;
        this.mirrorService = sgMirrorService;
    }

    public void render(SgMirrorScope sgMirrorScope, Map map, String[] stringArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (stringArray == null || stringArray.length == 0) {
            this.renderTemplate("tmatesoft.svn", map, httpServletResponse);
        } else {
            httpServletResponse.setHeader("Cache-Control", "no-cache, must-revalidate");
            httpServletResponse.setHeader("Pragma", "no-cache");
            String string = httpServletRequest.getRequestURI();
            while (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            map.put("uri", string);
            if ("info".equalsIgnoreCase(stringArray[0])) {
                this.renderTemplate("tmatesoft.debug.view", map, httpServletResponse);
            } else if ("snapshot".equalsIgnoreCase(stringArray[0])) {
                this.renderSnapshot(sgMirrorScope, map, httpServletResponse);
            } else if ("cluster".equalsIgnoreCase(stringArray[0])) {
                this.renderClusterStatus(this.taskSchedulerService.getClusterStatus(), httpServletResponse);
            } else if (sgMirrorScope.isRepository() && "files".equals(stringArray[0])) {
                this.renderDirectory(sgMirrorScope, map, stringArray, httpServletResponse);
            } else if ("log".equals(stringArray[0])) {
                this.renderLog(sgMirrorScope, httpServletResponse);
            } else if ("support".equals(stringArray[0]) && stringArray.length > 1) {
                this.renderScopeSupportFile(sgMirrorScope, SgMirrorRenderer.getFilePath(stringArray, 1), httpServletResponse);
            } else {
                httpServletResponse.sendError(404);
            }
        }
    }

    private void renderSnapshot(SgMirrorScope sgMirrorScope, Map map, HttpServletResponse httpServletResponse) {
        StringWriter stringWriter = new StringWriter();
        try {
            SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = this.obtainSnapshot(sgMirrorScope);
            if (sgTaskSchedulerSnapshot != null) {
                this.jsonService.write(sgTaskSchedulerSnapshot, sgMirrorScope, stringWriter);
                map.put("snapshot", stringWriter.toString());
                this.renderTemplate("tmatesoft.debug.snapshot", map, httpServletResponse);
            } else {
                httpServletResponse.sendError(500);
            }
        }
        catch (SgException sgException) {
            httpServletResponse.sendError(500, sgException.getMessage());
        }
    }

    private void renderClusterStatus(SgClusterStatus sgClusterStatus, HttpServletResponse httpServletResponse) {
        StringWriter stringWriter = new StringWriter();
        if (sgClusterStatus != null) {
            this.jsonService.write(sgClusterStatus, SgMirrorScope.global(), stringWriter);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("status", stringWriter.toString());
            this.renderTemplate("tmatesoft.debug.cluster", hashMap, httpServletResponse);
        } else {
            httpServletResponse.sendError(500);
        }
    }

    private void renderDirectory(SgMirrorScope sgMirrorScope, Map map, String[] stringArray, HttpServletResponse httpServletResponse) {
        File file = this.getMetadataDirectory(sgMirrorScope);
        if (file != null) {
            File file2;
            String string = SgMirrorRenderer.getFilePath(stringArray, 1);
            File file3 = file2 = string != null ? new File(file, string) : null;
            if (file2 != null && file2.isDirectory()) {
                map.put("filePath", string);
                map.put("files", file2.list());
                this.renderTemplate("tmatesoft.debug.dir", map, httpServletResponse);
            } else if (SgFileUtil.isFileExistsAndReadable(file2)) {
                this.writeFileContents(httpServletResponse, file2, SgMirrorRenderer.isTextFile(file2) ? "text/plain;charset=UTF-8" : "application/octet-stream");
            } else {
                httpServletResponse.sendError(404);
            }
        } else {
            httpServletResponse.sendError(404);
        }
    }

    private void renderLog(SgMirrorScope sgMirrorScope, HttpServletResponse httpServletResponse) {
        File file;
        File file2 = sgMirrorScope.isRepository() ? ((file = this.getMetadataDirectory(sgMirrorScope)) != null ? new File(file, "subgit/logs/svnmirror.log") : null) : new File(this.storageService.getHomeDir().toFile(), "log/svnmirror.log");
        if (file2 != null) {
            this.writeFileContents(httpServletResponse, file2, "text/plain;charset=UTF-8");
        } else {
            httpServletResponse.sendError(404);
        }
    }

    private void renderScopeSupportFile(SgMirrorScope sgMirrorScope, String string, HttpServletResponse httpServletResponse) {
        File file = new File(this.supportZipService.getSupportDirectory(sgMirrorScope), string);
        if (SgFileUtil.isFileExistsAndReadable(file)) {
            this.writeFileContents(httpServletResponse, file, "application/octet-stream");
        } else {
            httpServletResponse.sendError(404);
        }
    }

    private File getMetadataDirectory(SgMirrorScope sgMirrorScope) {
        if (!sgMirrorScope.isRepository()) {
            return null;
        }
        Repository repository = this.repositoryService.getById(sgMirrorScope.getRepositoryId());
        if (repository != null) {
            return this.mirrorService.getMetadataDirectory(repository);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileContents(HttpServletResponse httpServletResponse, File file, String string) {
        httpServletResponse.setContentType(string);
        httpServletResponse.setStatus(200);
        if (file.length() < Integer.MAX_VALUE) {
            httpServletResponse.setContentLength((int)file.length());
        }
        try {
            SgMirrorRenderer.writeFileContents(file, (OutputStream)httpServletResponse.getOutputStream());
        }
        finally {
            httpServletResponse.getOutputStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SgTaskSchedulerSnapshot obtainSnapshot(SgMirrorScope sgMirrorScope) {
        ISgTaskScheduler iSgTaskScheduler = this.taskSchedulerService.getScheduler();
        try {
            BlockingQueue blockingQueue = iSgTaskScheduler.obtainQueue(sgMirrorScope);
            SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = (SgTaskSchedulerSnapshot)blockingQueue.poll(10L, TimeUnit.SECONDS);
            return sgTaskSchedulerSnapshot;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            iSgTaskScheduler.releaseQueue(sgMirrorScope);
        }
        return null;
    }

    private void renderTemplate(String string, Map map, HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType("text/html;charset=UTF-8");
        httpServletResponse.setStatus(200);
        try {
            this.soyTemplateRenderer.render((Appendable)httpServletResponse.getWriter(), "org.tmatesoft.subgit.stash-svn-importer:svn-server", string, map);
        }
        catch (SoyException soyException) {
            Throwable throwable = soyException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(soyException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFileContents(File file, OutputStream outputStream) {
        InputStream inputStream = null;
        try {
            int n2;
            inputStream = SVNFileUtil.openFileForReading(file);
            byte[] byArray = new byte[8192];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
            }
        }
        catch (IOException | SVNException exception) {
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTextFile(File file) {
        InputStream inputStream = null;
        try {
            inputStream = SVNFileUtil.openFileForReading(file);
            boolean bl2 = SVNFileUtil.detectMimeType(inputStream) == null;
            return bl2;
        }
        catch (IOException | SVNException exception) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
    }

    private static String getFilePath(String[] stringArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 < stringArray.length; ++i2) {
            if ("..".equals(stringArray[i2]) || ".".equals(stringArray[i2])) {
                return null;
            }
            stringBuilder.append("/").append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }
}

