/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.web;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.event.api.EventListener;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.Contact;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseCheckEvent;
import com.atlassian.upm.api.license.event.PluginLicenseEvent;
import com.atlassian.upm.api.license.event.PluginLicenseMaintenancePeriodExpiredEvent;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.jgit.lib.ObjectId;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService;
import org.tmatesoft.subgit.stash.mirror.tasks.SgBootstrapSchedule;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.web.SgLicenseCheckRunner;
import org.tmatesoft.translator.b.F;
import org.tmatesoft.translator.g.i;
import org.tmatesoft.translator.g.k;
import org.tmatesoft.translator.g.n;
import org.tmatesoft.translator.h.d;
import org.tmatesoft.translator.m.aE;
import org.tmatesoft.translator.m.aQ;
import org.tmatesoft.translator.m.d.b;
import org.tmatesoft.translator.util.f;

public class SgLicenseManager {
    private final Logger log;
    private static final String NULL_LICENSE_HASH = "0000000000000000000000000000000000000000";
    private static final String HASH_FUNCTION = "SHA-1";
    private static final long EVALUATION_REVISION_COUNT_LIMIT = 10000L;
    private final PluginLicenseManager pluginLicenseManager;
    private final LicenseService stashLicenseService;
    private final PluginLicenseEventRegistry licenseEventRegistry;
    private final SchedulerService schedulerService;
    private SgTaskSchedulerService taskSchedulerService;
    private boolean isLicenseValid;

    public SgLicenseManager(LicenseService licenseService, PluginLicenseManager pluginLicenseManager, PluginLicenseEventRegistry pluginLicenseEventRegistry, SchedulerService schedulerService, SgLoggerFactory sgLoggerFactory) {
        this.log = sgLoggerFactory.getLogger("license");
        this.schedulerService = schedulerService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.stashLicenseService = licenseService;
        this.licenseEventRegistry = pluginLicenseEventRegistry;
    }

    public void onStart(SgTaskSchedulerService sgTaskSchedulerService) {
        this.log.info("starting license manager");
        this.taskSchedulerService = sgTaskSchedulerService;
        this.isLicenseValid = this.hasLicense();
        try {
            this.licenseEventRegistry.register((Object)this);
        }
        catch (Throwable throwable) {
            this.log.error("failed to register listener on plugin registry");
            this.scheduleLicenseCheck();
        }
    }

    public void onStop() {
        this.licenseEventRegistry.unregister((Object)this);
        this.unscheduleLicenseCheck();
    }

    @EventListener
    public void onLicenseEvent(PluginLicenseEvent pluginLicenseEvent) {
        this.log.info("ON LICENSE EVENT: " + String.valueOf(pluginLicenseEvent));
        if (pluginLicenseEvent instanceof PluginLicenseCheckEvent || pluginLicenseEvent instanceof PluginLicenseMaintenancePeriodExpiredEvent) {
            return;
        }
        this.log.info("license event received ({}), reloading repositories states", (Object)(pluginLicenseEvent == null ? "<null>" : pluginLicenseEvent.getClass().getSimpleName()));
        this.validateLicense();
    }

    public synchronized void validateLicense() {
        if (!this.taskSchedulerService.isMasterScheduler()) {
            return;
        }
        boolean bl2 = this.hasLicense();
        try {
            if (bl2 != this.isLicenseValid) {
                this.taskSchedulerService.getScheduler().refresh();
                if (bl2) {
                    this.taskSchedulerService.getScheduler().schedule(SgMirrorScope.global(), "bootstrap", SgBootstrapSchedule.scheduled());
                }
            }
        }
        catch (SgException sgException) {
            this.log.info(sgException.getMessage(), (Throwable)sgException);
        }
        finally {
            this.isLicenseValid = bl2;
        }
    }

    public boolean hasLicense() {
        BitbucketServerLicense bitbucketServerLicense = this.stashLicenseService.get();
        if (this.considerTestingLicense() && this.isTestingLicense((ProductLicense)bitbucketServerLicense)) {
            return true;
        }
        PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().getOrElse((Object)null);
        return pluginLicense != null && !pluginLicense.getError().isDefined();
    }

    public boolean isEvaluation() {
        PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().getOrElse((Object)null);
        return pluginLicense == null || pluginLicense.isEvaluation();
    }

    private void scheduleLicenseCheck() {
        this.schedulerService.registerJobRunner(SgLicenseCheckRunner.KEY, (JobRunner)new SgLicenseCheckRunner(this));
        try {
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)SgLicenseCheckRunner.KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)10000L, (Date)new Date(System.currentTimeMillis() + 10000L)));
            this.schedulerService.scheduleJob(JobId.of((String)"org.tmatesoft.subgit:license"), jobConfig);
            this.log.info("regular license check job scheduled");
        }
        catch (SchedulerServiceException schedulerServiceException) {
            this.log.info(schedulerServiceException.getMessage(), (Throwable)schedulerServiceException);
        }
    }

    private void unscheduleLicenseCheck() {
        this.schedulerService.unscheduleJob(JobId.of((String)"org.tmatesoft.subgit:license"));
    }

    private boolean considerTestingLicense() {
        return "true".equalsIgnoreCase(System.getProperty("svnmirror.considerTestingLicense", "false"));
    }

    public void updateLicenseInfo(b b2) {
        try {
            F f2 = b2.v();
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().getOrElse((Object)null);
            if (this.isPluginLicenseOutDated(f2, pluginLicense)) {
                this.registerPluginLicense(b2, pluginLicense);
            }
        }
        catch (f f3) {
            this.log.info("Failed to update license key information for repository '" + b2.U().a() + "'", (Throwable)f3);
            d.getLogger().info(f3);
        }
    }

    private boolean isPluginLicenseOutDated(F f2, PluginLicense pluginLicense) {
        String string;
        String string2 = f2.j();
        if (string2 == null) {
            return true;
        }
        if (pluginLicense == null) {
            return !f2.f(string2);
        }
        String string3 = this.generatePurchaseId(pluginLicense);
        if (!string3.equalsIgnoreCase(string = f2.e(string2))) {
            return true;
        }
        ZonedDateTime zonedDateTime = pluginLicense.getExpiryZonedDate().orElse(null);
        Date date = f2.x(string2);
        if (zonedDateTime == null && date == null) {
            return false;
        }
        if (zonedDateTime == null || date == null) {
            return true;
        }
        return zonedDateTime.minusDays(1L).truncatedTo(ChronoUnit.DAYS).isAfter(zonedDateTime);
    }

    private void registerPluginLicense(aE aE2, PluginLicense pluginLicense) {
        i i2 = this.generateLicense(pluginLicense);
        aQ aQ2 = aE2.t();
        aQ2.a(org.tmatesoft.translator.a.f.a);
        aQ2.a(i2);
        aQ2.b(false);
        aQ2.a(true);
        try {
            aQ2.s();
        }
        catch (f f2) {
            this.log.info("Failed to register a license key for repository " + String.valueOf(aE2.c()), (Throwable)f2);
            d.getLogger().info(f2);
        }
    }

    private i generateLicense(PluginLicense pluginLicense) {
        Object object;
        if (pluginLicense == null) {
            return this.generateTrialLicense();
        }
        i i2 = new i();
        i2.a(pluginLicense.getOrganization().getName());
        Iterator iterator = pluginLicense.getContacts().iterator();
        if (iterator.hasNext() && (object = (Contact)iterator.next()) != null) {
            i2.c(object.getEmail());
        }
        object = this.generatePurchaseId(pluginLicense);
        i2.b((String)object);
        Optional optional = pluginLicense.getExpiryZonedDate();
        optional.ifPresent(zonedDateTime -> i2.b(Date.from(this.getDateMidnight((ZonedDateTime)zonedDateTime).toInstant())));
        try {
            return i2.t();
        }
        catch (k k2) {
            throw f.b(k2);
        }
    }

    private ZonedDateTime getDateMidnight(ZonedDateTime zonedDateTime) {
        return zonedDateTime.plusDays(1L).truncatedTo(ChronoUnit.DAYS);
    }

    private boolean isTestingLicense(ProductLicense productLicense) {
        return productLicense != null && productLicense.getLicenseType() == LicenseType.TESTING;
    }

    private i generateTrialLicense() {
        i i2 = new i();
        BitbucketServerLicense bitbucketServerLicense = this.stashLicenseService.get();
        if (this.considerTestingLicense() && this.isTestingLicense((ProductLicense)bitbucketServerLicense)) {
            i2.b(n.A.a() + "-testing");
            i2.b(bitbucketServerLicense.getExpiryDate());
        } else {
            i2.a(true);
            i2.b("Atlassian Bitbucket Server auto-generated key");
        }
        i2.a(System.getProperty("user.name", "Atlassian Bitbucket Server"));
        try {
            return i2.t();
        }
        catch (k k2) {
            throw f.b(k2);
        }
    }

    private String generatePurchaseId(PluginLicense pluginLicense) {
        n n2 = pluginLicense.isEvaluation() ? n.A : n.z;
        return n2.a() + "-" + this.computePluginLicenseHash(pluginLicense);
    }

    private String computePluginLicenseHash(PluginLicense pluginLicense) {
        MessageDigest messageDigest;
        if (pluginLicense == null) {
            return NULL_LICENSE_HASH;
        }
        String string = pluginLicense.getRawLicense();
        if (string == null) {
            return NULL_LICENSE_HASH;
        }
        String string2 = "PluginLicense:" + string;
        byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
        try {
            messageDigest = MessageDigest.getInstance(HASH_FUNCTION);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw f.b(noSuchAlgorithmException);
        }
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        ObjectId objectId = ObjectId.fromRaw(byArray2);
        return objectId.name();
    }

    public long getEvaluationRepositoryRevisionsLimit() {
        return 10000L;
    }

    public boolean isCheckRepositorySize() {
        return false;
    }
}

