/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.util;

import com.a.a.a.b.i;
import com.a.a.a.c.C;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgException;

public class SgTextUtil {
    private static final Pattern SVN_GENERIC_ERROR_REGEXP = Pattern.compile("^(svn: E[0-9]+:)\\s*([^\n]*).*$", 40);
    private static final Pattern SVN_PRE_COMMIT_ERROR_REGEXP = Pattern.compile("^(svn: E[0-9]+:)\\s+(Commit\\sblocked.*)$", 40);

    public static String formatString(String string, Object ... objectArray) {
        try {
            if (string == null || objectArray == null || objectArray.length == 0) {
                return string;
            }
            return String.format(string, objectArray);
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static String formatErrorMessage(Throwable throwable) {
        boolean bl2 = SgTextUtil.isSubversionErrorMessage(throwable.getMessage());
        String string = SgTextUtil.formatErrorMessage(throwable.getMessage());
        if (bl2 || throwable instanceof SgException) {
            return string;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (throwable.getMessage() != null) {
            printWriter.printf("%s : \n", throwable.getMessage());
        }
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    public static String formatErrorMessage(String string) {
        if (string == null) {
            return "NullPointerException";
        }
        Matcher matcher = SVN_PRE_COMMIT_ERROR_REGEXP.matcher(string);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        Matcher matcher2 = SVN_GENERIC_ERROR_REGEXP.matcher(string);
        if (matcher2.matches()) {
            return matcher2.group(2);
        }
        return string;
    }

    public static int getMaxCoreRunnersCount() {
        String string = System.getProperty("svnmirror.maxCoreRunnersCount", "32");
        try {
            return Math.max(1, Integer.parseInt(string));
        }
        catch (Throwable throwable) {
            return 32;
        }
    }

    private static boolean isSubversionErrorMessage(String string) {
        return string != null && SVN_GENERIC_ERROR_REGEXP.matcher(string).matches();
    }

    public static String loadTextFileContents(File file, Logger logger) {
        if (!file.isFile() || !file.canRead()) {
            logger.info("cannot read from file at '{}'", (Object)file.getAbsolutePath());
            return "";
        }
        try {
            return new String(C.h(file), StandardCharsets.UTF_8).replace("\t", "    ").replace("\r\n", "\n").replace("\r", "\n").trim();
        }
        catch (i i2) {
            if (logger != null) {
                logger.info(i2.getMessage(), (Throwable)i2);
            }
            return "";
        }
    }

    public static Config loadGitConfig(String string) {
        try {
            return new BlobBasedConfig(null, string.getBytes(StandardCharsets.UTF_8));
        }
        catch (ConfigInvalidException configInvalidException) {
            return null;
        }
    }

    public static void writeTextFileContents(File file, String string, Logger logger) {
        block2: {
            try {
                C.a(file, string.replace("\r\n", "\n").replace("\r", "\n").replace("\t", "    ").trim().getBytes(StandardCharsets.UTF_8));
            }
            catch (i i2) {
                if (logger == null) break block2;
                logger.info(i2.getMessage(), (Throwable)i2);
            }
        }
    }
}

