/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.sift.MDCBasedDiscriminator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.sift.Discriminator;
import ch.qos.logback.core.util.FileSize;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.jboss.logging.MDC;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgLogLevelMessage;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory$ClosingSiftingAppender;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory$RepositoryAppenderFactory;
import org.tmatesoft.subgit.stash.web.SgPluginPropertiesService;

public class SgLoggerFactory
implements TopicListener {
    private static final String ROOT = "sg";
    private static final String ROOT_LOG_PATTERN = "%d [%thread] %-5level %logger{36} - %msg %ex\n";
    private static final String ROOT_MAX_SIZE = "10MB";
    private static final String ROOT_LOG_FILE = "svnmirror.log";
    private static final String ROOT_LOG_FILE_PATTERN = "svnmirror.%i.log.gz";
    private static final String REPOSITORY = "sgr";
    private static final String MDC_SCOPE_KEY = "sg.scope";
    private static final String MDC_TASK_KEY = "sg.task";
    private static final String MDC_LOG_DIR_KEY = "sg.logDir";
    private static final String REPOSITORY_LOG_PATTERN = "%d %mdc{sg.task:-none} - %msg %ex\n";
    private static final String REPOSITORY_MAX_SIZE = "10MB";
    private static final String REPOSITORY_LOG_FILE = "svnmirror.log";
    private static final String REPOSITORY_LOG_FILE_PATTERN = "svnmirror.%i.log.gz";
    private final StorageService storageService;
    private final SgPluginPropertiesService pluginPropertiesService;
    private final RepositoryService repositoryService;
    private final LoggerContext loggerContext;
    private String subscribeId;
    private Topic logLevelTopic;

    public SgLoggerFactory(StorageService storageService, SgPluginPropertiesService sgPluginPropertiesService, TopicService topicService, RepositoryService repositoryService) {
        this.storageService = storageService;
        this.pluginPropertiesService = sgPluginPropertiesService;
        this.repositoryService = repositoryService;
        this.loggerContext = this.createLoggerContext();
        this.logLevelTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:logLevel", TopicSettings.builder((Class)null).build());
        this.subscribeId = this.logLevelTopic.subscribe((TopicListener)this);
    }

    public Logger getLogger(String string) {
        string = string == null || string.isEmpty() ? ROOT : "sg." + string;
        return this.loggerContext.getLogger(string);
    }

    public Logger getLogger(SgTask sgTask) {
        String string;
        if (sgTask != null && ((SgMirrorScope)sgTask.getScope()).isRepository()) {
            File file = this.getLogDirectoryForRepository((SgMirrorScope)sgTask.getScope());
            if (!(!"bootstrap".equals(sgTask.getName()) && !"push".equals(sgTask.getName()) || file != null && file.isDirectory())) {
                string = ROOT;
            } else {
                SgLoggerFactory.updateMDCContext(sgTask, file);
                string = REPOSITORY;
            }
        } else {
            string = sgTask == null ? ROOT : "sg." + sgTask.getName();
        }
        return this.loggerContext.getLogger(string);
    }

    private File getLogDirectoryForRepository(SgMirrorScope sgMirrorScope) {
        Repository repository = this.repositoryService.getById(sgMirrorScope.getRepositoryId());
        if (repository != null) {
            File file = this.pluginPropertiesService.getMetadataDirectory(repository);
            return new File(file, "subgit/logs");
        }
        return null;
    }

    public void setLevel(Level level) {
        this.doSetLevel(level);
        this.logLevelTopic.publish((Serializable)new SgLogLevelMessage(level));
    }

    private void doSetLevel(Level level) {
        this.loggerContext.getLogger(ROOT).setLevel(level);
    }

    private LoggerContext createLoggerContext() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        File file = new File(this.storageService.getHomeDir().toFile(), "log");
        String string = file.getAbsolutePath().replace(File.separatorChar, '/');
        loggerContext.getLogger(ROOT).detachAndStopAllAppenders();
        loggerContext.getLogger(ROOT).setAdditive(false);
        loggerContext.getLogger(ROOT).addAppender(SgLoggerFactory.createRollingFileAppender((Context)loggerContext, string, "svnmirror.log", "svnmirror.%i.log.gz", "10MB", ROOT_LOG_PATTERN));
        loggerContext.getLogger(ROOT).setLevel(Level.INFO);
        loggerContext.getLogger(REPOSITORY).detachAndStopAllAppenders();
        loggerContext.getLogger(REPOSITORY).setAdditive(false);
        loggerContext.getLogger(REPOSITORY).addAppender(this.createRepositoryAppender(loggerContext));
        loggerContext.getLogger(REPOSITORY).setLevel(Level.DEBUG);
        return loggerContext;
    }

    private Appender createRepositoryAppender(LoggerContext loggerContext) {
        MDCBasedDiscriminator mDCBasedDiscriminator = new MDCBasedDiscriminator();
        mDCBasedDiscriminator.setKey(MDC_SCOPE_KEY);
        mDCBasedDiscriminator.setDefaultValue(SgMirrorScope.global().toString());
        mDCBasedDiscriminator.setContext((Context)loggerContext);
        mDCBasedDiscriminator.start();
        SgLoggerFactory$ClosingSiftingAppender sgLoggerFactory$ClosingSiftingAppender = new SgLoggerFactory$ClosingSiftingAppender();
        sgLoggerFactory$ClosingSiftingAppender.setAppenderFactory(new SgLoggerFactory$RepositoryAppenderFactory(this));
        sgLoggerFactory$ClosingSiftingAppender.setDiscriminator((Discriminator)mDCBasedDiscriminator);
        sgLoggerFactory$ClosingSiftingAppender.setMaxAppenderCount(Integer.MAX_VALUE);
        sgLoggerFactory$ClosingSiftingAppender.setContext((Context)loggerContext);
        sgLoggerFactory$ClosingSiftingAppender.start();
        return sgLoggerFactory$ClosingSiftingAppender;
    }

    private static void updateMDCContext(SgTask sgTask, File file) {
        if (sgTask != null) {
            MDC.put(MDC_SCOPE_KEY, sgTask.getScope().toString());
            MDC.put(MDC_TASK_KEY, sgTask.getName());
        } else {
            MDC.remove(MDC_SCOPE_KEY);
            MDC.remove(MDC_TASK_KEY);
        }
        if (file != null) {
            MDC.put(MDC_LOG_DIR_KEY, file.getAbsolutePath().replace(File.separatorChar, '/'));
        } else {
            MDC.remove(MDC_LOG_DIR_KEY);
        }
    }

    public void shutdown() {
        this.getLogger(ROOT).info("shutting down logger factory");
        if (this.subscribeId != null && this.logLevelTopic != null) {
            this.logLevelTopic.unsubscribe(this.subscribeId);
            this.logLevelTopic = null;
            this.subscribeId = null;
        }
        this.loggerContext.getLogger(ROOT).detachAndStopAllAppenders();
        this.loggerContext.getLogger(REPOSITORY).detachAndStopAllAppenders();
    }

    public void onMessage(@Nonnull MessageEvent messageEvent) {
        SgLogLevelMessage sgLogLevelMessage = (SgLogLevelMessage)messageEvent.getMessage();
        this.getLogger(ROOT).info("log level message received: " + String.valueOf(sgLogLevelMessage.getLevel()));
        this.doSetLevel(sgLogLevelMessage.getLevel());
    }

    private static Encoder createPatternEncoder(Context context, String string) {
        PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setCharset(StandardCharsets.UTF_8);
        patternLayoutEncoder.setPattern(string);
        patternLayoutEncoder.setContext(context);
        patternLayoutEncoder.start();
        return patternLayoutEncoder;
    }

    @NotNull
    private static Appender createRollingFileAppender(Context context, String string, String string2, String string3, String string4, String string5) {
        String string6 = string + "/" + string2;
        String string7 = string + "/" + string3;
        SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = new SizeBasedTriggeringPolicy();
        SgLoggerFactory.setPolicyMaxFileSize(sizeBasedTriggeringPolicy, string4);
        sizeBasedTriggeringPolicy.setContext(context);
        Encoder encoder = SgLoggerFactory.createPatternEncoder(context, string5);
        FixedWindowRollingPolicy fixedWindowRollingPolicy = new FixedWindowRollingPolicy();
        fixedWindowRollingPolicy.setMinIndex(1);
        fixedWindowRollingPolicy.setMaxIndex(3);
        fixedWindowRollingPolicy.setFileNamePattern(string7);
        fixedWindowRollingPolicy.setContext(context);
        RollingFileAppender rollingFileAppender = new RollingFileAppender();
        rollingFileAppender.setEncoder(encoder);
        rollingFileAppender.setFile(string6);
        rollingFileAppender.setRollingPolicy((RollingPolicy)fixedWindowRollingPolicy);
        rollingFileAppender.setTriggeringPolicy((TriggeringPolicy)sizeBasedTriggeringPolicy);
        rollingFileAppender.setContext(context);
        fixedWindowRollingPolicy.setParent((FileAppender)rollingFileAppender);
        fixedWindowRollingPolicy.start();
        sizeBasedTriggeringPolicy.start();
        rollingFileAppender.start();
        return rollingFileAppender;
    }

    private static void setPolicyMaxFileSize(SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy, String string) {
        try {
            Method method = sizeBasedTriggeringPolicy.getClass().getMethod("setMaxFileSize", FileSize.class);
            method.invoke((Object)sizeBasedTriggeringPolicy, FileSize.valueOf((String)string));
        }
        catch (Throwable throwable) {
            try {
                Method method = sizeBasedTriggeringPolicy.getClass().getMethod("setMaxFileSize", String.class);
                method.invoke((Object)sizeBasedTriggeringPolicy, string);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }
}

