/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.util;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.util.SgAuthorisationOptions;

public class SgHasImportOrMirrorPermission
implements Condition {
    private final SgMirrorService mirrorService;
    private final AuthenticationContext authenticationContext;
    private final UserService userService;
    private final PermissionValidationService permissionValidationService;

    public SgHasImportOrMirrorPermission(SgMirrorService sgMirrorService, AuthenticationContext authenticationContext, UserService userService, PermissionValidationService permissionValidationService) {
        this.mirrorService = sgMirrorService;
        this.authenticationContext = authenticationContext;
        this.userService = userService;
        this.permissionValidationService = permissionValidationService;
    }

    public void init(Map map) {
    }

    public boolean shouldDisplay(Map map) {
        try {
            this.permissionValidationService.validateAuthenticated();
        }
        catch (AuthorisationException authorisationException) {
            return false;
        }
        boolean bl2 = false;
        if (!map.containsKey("repository") && !map.containsKey("project")) {
            try {
                this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                bl2 = true;
            }
            catch (AuthorisationException authorisationException) {}
        } else {
            String string;
            SgAuthorisationOptions sgAuthorisationOptions = (SgAuthorisationOptions)this.mirrorService.createSettings(SgMirrorScope.global()).get(SgMirrorOption.AUTHORISATION_OPTIONS, new SgSettingsType[0]);
            if (sgAuthorisationOptions.isAdminAuthorisationEnabled()) {
                if (map.containsKey("repository") && map.get("repository") instanceof Repository) {
                    string = (Repository)map.get("repository");
                    try {
                        this.permissionValidationService.validateForRepository((Repository)string, Permission.REPO_ADMIN);
                        bl2 = true;
                    }
                    catch (AuthorisationException authorisationException) {}
                } else if (map.containsKey("project") && map.get("project") instanceof Project) {
                    string = (Project)map.get("project");
                    try {
                        this.permissionValidationService.validateForProject((Project)string, Permission.PROJECT_ADMIN);
                        bl2 = true;
                    }
                    catch (AuthorisationException authorisationException) {
                        // empty catch block
                    }
                }
            }
            if (!bl2 && sgAuthorisationOptions.isGroupAuthorisationEnabled()) {
                string = sgAuthorisationOptions.getImportGroupName();
                String string2 = sgAuthorisationOptions.getMirrorGroupName();
                ApplicationUser applicationUser = this.authenticationContext.getCurrentUser();
                bl2 = applicationUser != null && (this.userService.isUserInGroup(applicationUser, string) || this.userService.isUserInGroup(applicationUser, string2));
            }
        }
        return bl2;
    }
}

