/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.util;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.util.ISgCleanable;

public class SgCleanupJobRunner
implements JobRunner {
    public static JobRunnerKey KEY = JobRunnerKey.of((String)"org.tmatesoft.subgit:SgCleanupJobRunner");
    private final Logger log;
    private final ISgCleanable[] cleanable;

    public SgCleanupJobRunner(Logger logger, ISgCleanable ... iSgCleanableArray) {
        this.log = logger;
        this.cleanable = iSgCleanableArray;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        if (this.cleanable != null) {
            for (ISgCleanable iSgCleanable : this.cleanable) {
                if (iSgCleanable == null) continue;
                this.log.info("running cleanup for '" + iSgCleanable.getClass().getSimpleName() + "' service");
                try {
                    iSgCleanable.cleanup();
                }
                catch (Throwable throwable) {
                    this.log.info(throwable.getMessage(), throwable);
                }
            }
        }
        this.log.info("cleanup completed");
        return JobRunnerResponse.success();
    }
}

