/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.util.SgBackup$1;

public class SgBackup {
    private final Map backupFiles = new HashMap();

    public void backup(File file) {
        this.backup(file, null);
    }

    public void backup(File file, File file2) {
        if (file != null) {
            this.backup(file.toPath(), file2 != null ? file2.toPath() : null);
        }
    }

    public void backup(Path path, Path path2) {
        if (path == null || this.backupFiles.containsKey(path)) {
            return;
        }
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            if (path2 != null) {
                try {
                    SgBackup.copy(path2, null, true);
                }
                catch (IOException iOException) {
                    throw new SgException("Failed to back up, cannot delete file '" + String.valueOf(path2) + "'");
                }
            }
            Path path3 = path2 != null ? path2 : SgBackup.getBackupPath(path);
            try {
                SgBackup.copy(path, path3, false);
                this.backupFiles.put(path, path3);
            }
            catch (IOException iOException) {
                throw new SgException("Failed to back up file '" + String.valueOf(path) + "'");
            }
        }
        this.backupFiles.put(path, null);
    }

    public void restore() {
        for (Path path : new HashSet(this.backupFiles.keySet())) {
            Path path2 = (Path)this.backupFiles.get(path);
            try {
                if (path2 == null) {
                    SgBackup.copy(path, null, true);
                } else {
                    SgBackup.copy(path2, path, true);
                }
                this.backupFiles.remove(path);
            }
            catch (IOException iOException) {}
        }
    }

    public void delete() {
        for (Path path : new HashSet(this.backupFiles.keySet())) {
            Path path2 = (Path)this.backupFiles.get(path);
            if (path2 != null) {
                try {
                    SgBackup.copy(path2, null, true);
                    this.backupFiles.remove(path);
                }
                catch (IOException iOException) {}
                continue;
            }
            this.backupFiles.remove(path);
        }
    }

    private static void copy(Path path, Path path2, boolean bl2) {
        Files.walkFileTree(path, new SgBackup$1(path2, path, bl2));
    }

    private static Path getBackupPath(Path path) {
        Path path2;
        int n2 = 0;
        do {
            String string = (String)(n2 > 0 ? "." + n2 : "") + ".bak";
            path2 = path.resolveSibling(String.valueOf(path.getFileName()) + string);
            ++n2;
        } while (Files.exists(path2, LinkOption.NOFOLLOW_LINKS));
        return path2;
    }
}

