/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsEditor;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryTask;
import org.tmatesoft.subgit.stash.mirror.util.SgVerifyInfo;
import org.tmatesoft.subgit.stash.mirror.util.SgVerifyInfo$Builder;
import org.tmatesoft.translator.a.l;
import org.tmatesoft.translator.b.G;
import org.tmatesoft.translator.m.Z;
import org.tmatesoft.translator.m.aS;
import org.tmatesoft.translator.m.aj;
import org.tmatesoft.translator.m.bs;
import org.tmatesoft.translator.m.d.b;
import org.tmatesoft.translator.util.f;

public class SgVerifyTask
extends SgRepositoryTask
implements l {
    private static final long UNVERIFIED_REVISIONS_MAX_COUNT = 1024L;
    private static final Version MAX_RESET_TRUSTFOLDERSTAT_VERSION = new Version(new Integer[]{4, 0, 2});
    private SgMirrorStage stage;
    private long verifiedRevision;
    private boolean verifyStarted;
    private long endRevision = -1L;
    private long startRevision = -1L;
    private Collection issues;

    public SgVerifyTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, sgMirrorService, escalatedSecurityContext);
    }

    @Override
    protected EnumSet getApplicableStages() {
        return EnumSet.of(SgMirrorStage.INSTALLED);
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.runSecurely(sgSettingsSnapshot);
        SgVerifyInfo sgVerifyInfo = (SgVerifyInfo)sgSettingsSnapshot.get(SgMirrorOption.VERIFY_INFO, new SgSettingsType[0]);
        if (this.isResetTrustFolderStatOption(sgVerifyInfo)) {
            this.resetTrustFolderStatOption();
        } else {
            this.getLogger().info("core.trustfolderstat option will not be unset");
        }
        this.stage = (SgMirrorStage)((Object)sgSettingsSnapshot.get(SgMirrorOption.STAGE, new SgSettingsType[0]));
        long l2 = this.getStartVerifyRevision(sgSettingsSnapshot);
        if (l2 >= 0L) {
            this.getLogger().info("starting verify from revision: " + l2);
            b b2 = this.createProxyRepository(sgSettingsSnapshot);
            aS aS2 = new aS(b2);
            aS2.a(this);
            aS2.a(this);
            aS2.a(l2);
            this.verifyStarted = true;
            aS2.a();
        } else {
            this.getLogger().info("mirror does not need verification, last verification data:");
            this.getLogger().info("version:   " + sgVerifyInfo.getVerifiedVersion());
            this.getLogger().info("revision:  " + sgVerifyInfo.getVerifiedRevision());
            this.getLogger().info("completed: " + sgVerifyInfo.isVerifyCompleted());
            this.getLogger().info("errors:");
            for (int i2 = 0; i2 < sgVerifyInfo.getIssues().length; ++i2) {
                this.getLogger().info("      : " + sgVerifyInfo.getIssues()[i2].toString());
            }
        }
    }

    private boolean isResetTrustFolderStatOption(SgVerifyInfo sgVerifyInfo) {
        if (sgVerifyInfo == null) {
            return true;
        }
        String string = sgVerifyInfo.getVerifiedVersion();
        if (string == null) {
            return true;
        }
        return new Version(string).compareTo(MAX_RESET_TRUSTFOLDERSTAT_VERSION) <= 0;
    }

    @Override
    public void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        SgVerifyInfo sgVerifyInfo = (SgVerifyInfo)sgSettingsSnapshot.get(SgMirrorOption.VERIFY_INFO, new SgSettingsType[0]);
        SgVerifyInfo sgVerifyInfo2 = this.verifyStarted ? new SgVerifyInfo$Builder().setCompleted(this.getState() == SgTaskState.SUCCESS).setRevision(this.verifiedRevision).setVersion(this.getMirrorService().getPluginPropertiesService().getPluginVersion()).setIssues(this.issues).build() : (sgVerifyInfo != null ? new SgVerifyInfo$Builder().setCompleted(sgVerifyInfo.isVerifyCompleted()).setRevision(sgVerifyInfo.getVerifiedRevision()).setVersion(this.getMirrorService().getPluginPropertiesService().getPluginVersion()).setIssues(sgVerifyInfo.getIssues()).build() : new SgVerifyInfo$Builder().setCompleted(false).setRevision(0L).setVersion(this.getMirrorService().getPluginPropertiesService().getPluginVersion()).build());
        this.getLogger().info("updating verify information:");
        this.getLogger().info("version:   " + sgVerifyInfo2.getVerifiedVersion());
        this.getLogger().info("revision:  " + sgVerifyInfo2.getVerifiedRevision());
        this.getLogger().info("completed: " + sgVerifyInfo2.isVerifyCompleted());
        this.getLogger().info("errors:");
        for (int i2 = 0; i2 < sgVerifyInfo2.getIssues().length; ++i2) {
            this.getLogger().info("      : " + sgVerifyInfo2.getIssues()[i2].toString());
        }
        SgSettingsEditor sgSettingsEditor = this.getSettingsEditor();
        sgSettingsEditor.set(SgMirrorOption.VERIFY_INFO, sgVerifyInfo2);
        sgSettingsEditor.save();
        if (this.stage == SgMirrorStage.INSTALLED && !this.isPaused()) {
            if ((Integer)this.getUserSettings().get(SgMirrorOption.SVN_FETCH_INTERVAL, new SgSettingsType[0]) > 0 || ((Boolean)this.getUserSettings().get(SgMirrorOption.IMPORT, new SgSettingsType[0])).booleanValue()) {
                this.schedule("sync");
            }
        } else if (this.stage == SgMirrorStage.LEGACY) {
            this.schedule("upgrade");
        }
    }

    private long getStartVerifyRevision(SgSettingsSnapshot sgSettingsSnapshot) {
        long l2;
        long l3;
        G g2;
        if (this.isPaused()) {
            return -1L;
        }
        SgVerifyInfo sgVerifyInfo = (SgVerifyInfo)sgSettingsSnapshot.get(SgMirrorOption.VERIFY_INFO, new SgSettingsType[0]);
        if (sgVerifyInfo == null) {
            return (Long)sgSettingsSnapshot.get(SgMirrorOption.SVN_MINIMAL_REVISION, new SgSettingsType[0]);
        }
        long l4 = sgVerifyInfo.getVerifiedRevision();
        if (!sgVerifyInfo.isVerifyCompleted()) {
            return l4 >= 0L ? l4 : (Long)sgSettingsSnapshot.get(SgMirrorOption.SVN_MINIMAL_REVISION, new SgSettingsType[0]);
        }
        b b2 = this.createProxyRepository(sgSettingsSnapshot);
        aj aj2 = b2.c(g2 = b2.G());
        if (aj2 != null && (l3 = (l2 = aj2.o()) - l4) >= 1024L) {
            return l4;
        }
        return -1L;
    }

    private void resetTrustFolderStatOption() {
        this.getLogger().info("core.trustfolderstat : about to unset");
        Z z2 = this.getMirrorService().getGitRepositoryKey(this.getRepository());
        try (Repository repository = this.getMirrorService().getGitRepositoryFactory().createGitRepositoryInstance(z2, true);){
            StoredConfig storedConfig = repository.getConfig();
            storedConfig.load();
            if (!storedConfig.getBoolean("core", null, "trustfolderstat", true)) {
                storedConfig.unset("core", null, "trustfolderstat");
                storedConfig.save();
                this.getLogger().info("core.trustfolderstat option unset");
            } else {
                this.getLogger().info("core.trustfolderstat option is set to 'true' or not set");
            }
        }
        catch (IOException | ConfigInvalidException | f exception) {
            this.getLogger().error("core.trustfolderstat : failed to unset", (Throwable)exception);
        }
    }

    @Override
    public void startLocationVerification(File file, long l2, long l3) {
        this.startRevision = l2;
        this.endRevision = l3;
        this.getLogger().info("verifying revision range: " + l2 + ":" + l3);
    }

    @Override
    public void endLocationVerification(File file, File file2) {
    }

    @Override
    public void onProgress(int n2, long l2) {
        this.verifiedRevision = l2;
        if (this.startRevision >= 0L && this.endRevision >= this.startRevision && l2 >= this.startRevision) {
            long l3 = this.endRevision - this.startRevision;
            long l4 = l2 - this.startRevision;
            n2 = (int)((double)l4 / (double)l3 * 100.0);
        }
        this.setProgressMessage("Verified revision " + l2, n2, new Object[0]);
    }

    @Override
    public void onRevision(bs bs2) {
        if (this.issues == null) {
            this.issues = new ArrayList();
        }
        this.issues.add(bs2);
    }

    @Override
    public void startVerification(File file) {
    }

    @Override
    public void endVerification(File file) {
    }
}

