/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.a.a.a.b.b;
import com.a.a.a.c.C;
import com.a.a.a.d.au;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.subgit.stash.mirror.SgAuthorsMappingOptions;
import org.tmatesoft.subgit.stash.mirror.SgCredentials;
import org.tmatesoft.subgit.stash.mirror.SgCredentials$Builder;
import org.tmatesoft.subgit.stash.mirror.SgCredentials$Type;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsEditor;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.svn.SgConnectionTest;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryTask;
import org.tmatesoft.subgit.stash.mirror.util.SgConfigOption;
import org.tmatesoft.subgit.stash.mirror.util.SgFileUtil;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.translator.b.e;
import org.tmatesoft.translator.b.g;
import org.tmatesoft.translator.b.n;
import org.tmatesoft.translator.b.o;
import org.tmatesoft.translator.b.w;
import org.tmatesoft.translator.h.d;
import org.tmatesoft.translator.util.f;
import org.tmatesoft.translator.util.u;

public class SgUpgradeTask
extends SgRepositoryTask {
    protected SgUpgradeTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, sgMirrorService, escalatedSecurityContext);
    }

    @Override
    protected EnumSet getApplicableStages() {
        return EnumSet.of(SgMirrorStage.LEGACY);
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        block6: {
            g g2;
            super.runSecurely(sgSettingsSnapshot);
            this.setProgressMessage("Upgrading...", 100, new Object[0]);
            File file = new File(this.getRepositoryArea().i(), "status");
            File file2 = new File(this.getRepositoryArea().i(), "config.tmp");
            boolean bl2 = SgFileUtil.isFileExistsAndReadable(this.getRepositoryArea().e());
            if (!bl2) {
                boolean bl3 = this.isImported(file);
                if (bl3) {
                    this.setProgressMessage("Imported repository detected...", 100, new Object[0]);
                    this.backupAndRemove();
                    this.setMessage(null, new Object[0]);
                    return;
                }
                this.getBackup().backup(file2);
                Files.move(this.getRepositoryArea().g().toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                g2 = g.a(file2, this.getRepositoryArea().d());
            } else {
                Files.deleteIfExists(this.getRepositoryArea().g().toPath());
                g2 = this.createActiveConfig();
            }
            this.getBackup().backup(this.getRepositoryArea().e(), new File(this.getRepositoryArea().i(), "active.2.0.x.config"));
            this.getBackup().backup(this.getRepositoryArea().g(), new File(this.getRepositoryArea().i(), "user.2.0.x.config"));
            this.getBackup().backup(file);
            Files.deleteIfExists(file.toPath());
            g2.b();
            g g3 = this.createUserHiddenConfig();
            g3.b();
            g g4 = this.createUserVisibleConfig();
            g4.b();
            this.setProgressMessage("Validating credentials...", 100, new Object[0]);
            this.upgradeCredentials(g2);
            this.setProgressMessage("Validating options...", 100, new Object[0]);
            this.upgradeConfigFiles(g2, g3, g4, this.getSettingsEditor());
            g3.c();
            g4.c();
            this.documentConfig(g4);
            this.upgradeAuthorsFile();
            if (bl2) {
                this.setProgressMessage("Applying new configuration...", 100, new Object[0]);
                SgSettings sgSettings = this.getMirrorService().loadInstallConfiguration((SgMirrorScope)this.getScope(), this.getRepositoryArea(), this.getSettingsEditor(), false);
                try {
                    this.install(sgSettings, false);
                }
                catch (Throwable throwable) {
                    if (SgUpgradeTask.isAuthenticationError(throwable, null)) break block6;
                    throw throwable;
                }
            }
        }
        this.getSettingsEditor().save();
        this.setMessage(null, new Object[0]);
        this.getBackup().delete();
    }

    private void upgradeAuthorsFile() {
        File file = this.getRepositoryArea().m();
        boolean bl2 = SgFileUtil.isFileExistsAndReadable(file);
        if (!(file == null || bl2 && file.length() != 0L)) {
            String string = u.a().f("authors");
            String string2 = e.a(string != null ? string : "");
            SgTextUtil.writeTextFileContents(file, string2, this.getLogger());
        }
    }

    private void backupAndRemove() {
        File file = new File(this.getRepositoryArea().d(), "svn");
        this.getBackup().backup(this.getRepositoryArea().i());
        this.getBackup().backup(file);
        File[] fileArray = this.getRepositoryArea().i().listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.equals(this.getRepositoryArea().l())) continue;
                C.b(file2);
            }
        }
        C.b(file);
    }

    private void upgradeConfigFiles(g g2, g g3, g g4, SgSettings sgSettings) {
        List list = g2.b(n.f);
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.getMirrorService().getAuthorsService().isGlobalMappingFile(string)) {
                bl2 = true;
                iterator.remove();
                continue;
            }
            if (!this.getMirrorService().getAuthorsService().isLocalMappingFile(string)) continue;
            bl3 = true;
            iterator.remove();
        }
        sgSettings.set(SgMirrorOption.AUTHORS_MAPPING, new SgAuthorsMappingOptions(bl2, false, bl3));
        sgSettings.set(SgMirrorOption.CORE_AUTHORS_FILE_ENCODING, g2.a(n.g));
        g4.a(n.f, list);
        g2.g(n.f);
        g2.g(n.g);
        this.moveConfigOptions(g2, g3, n.E, n.F, n.G, n.H, w.n.b(o.c.a()), w.B.b(o.c.a()));
        this.deleteAuthenticationOptions(g3);
        this.moveStashManagedOptionsToStash(g3, sgSettings);
        this.moveConfigOptions(g2, g4, new n[0]);
        this.setConfigOption(g3, n.aq, this.getDaemonClasspath());
    }

    /*
     * WARNING - void declaration
     */
    private void upgradeCredentials(g g2) {
        Object object;
        SgCredentials[] sgCredentialsArray = SgUpgradeTask.loadCredentials(g2);
        this.prepareTestSettings(g2);
        SgCredentials object3 = null;
        SgCredentials object4 = null;
        for (SgCredentials object22 : sgCredentialsArray) {
            if (object22 == null) continue;
            d.getLogger().info("testing credentials: " + String.valueOf(object22));
            this.getSettingsEditor().set(SgMirrorOption.CREDENTIALS, object22);
            object = this.getMirrorService().getSubversionService().testConnection(this.getSettingsEditor());
            if (((SgConnectionTest)object).isReadAccess() && ((SgConnectionTest)object).isWriteAccess()) {
                object3 = object22;
                d.getLogger().info("full access");
                break;
            }
            if (((SgConnectionTest)object).isReadAccess() && object4 == null) {
                object4 = object22;
                d.getLogger().info("read access only");
                continue;
            }
            d.getLogger().info("no access: " + ((SgConnectionTest)object).getError());
        }
        SgCredentials object5 = object3 != null ? object3 : (object4 != null ? object4 : SgUpgradeTask.createCacheCredentials(null));
        File file = g2.c(SgConfigOption.SVN_AUTH_PASSWORDS);
        if (g2.a(SgConfigOption.SVN_AUTH_PASSWORD) != null && object5.getPassword() == null) {
            String string = g2.a(SgConfigOption.SVN_AUTH_PASSWORD);
            char[] iOException = string != null ? string.toCharArray() : null;
            object = g2.a(SgConfigOption.SVN_AUTH_USER_NAME);
            this.getSettingsEditor().set(SgMirrorOption.CREDENTIALS, this.addPasswordToCredentials(object5, (String)object, iOException));
        } else if (file != null && object5.getPassword() == null) {
            void var8_17;
            Map map = SgUpgradeTask.loadPasswordsFile(file);
            if (object5.getUserName() != null) {
                object = object5.getUserName();
                char[] cArray = (char[])map.get(object5.getUserName());
            } else if (!map.isEmpty()) {
                Map.Entry entry = map.entrySet().iterator().next();
                object = (String)entry.getKey();
                char[] cArray = (char[])entry.getValue();
            } else {
                Object var8_16 = null;
                object = null;
            }
            this.getSettingsEditor().set(SgMirrorOption.CREDENTIALS, this.addPasswordToCredentials(object5, (String)object, (char[])var8_17));
        } else {
            this.getSettingsEditor().set(SgMirrorOption.CREDENTIALS, object5);
        }
        if (file != null) {
            Map map = SgUpgradeTask.loadPasswordsFile(file);
            if (map.size() <= 1) {
                try {
                    Files.deleteIfExists(file.toPath());
                }
                catch (IOException iOException) {}
            } else {
                File file2 = this.getRepositoryArea().A();
                if (file2 != null && !file2.getAbsoluteFile().equals(file.getAbsoluteFile())) {
                    try {
                        Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private SgCredentials addPasswordToCredentials(SgCredentials sgCredentials, String string, char[] cArray) {
        if (string == null || cArray == null) {
            return sgCredentials;
        }
        if (sgCredentials.getPassword() != null) {
            return sgCredentials;
        }
        if (sgCredentials.getUserName() != null && !sgCredentials.getUserName().equals(string)) {
            return sgCredentials;
        }
        SgCredentials$Builder sgCredentials$Builder = SgCredentials.builder().fromCredentials(sgCredentials).setUserName(string).setPassword(cArray);
        if (sgCredentials.getSslPassword() == null) {
            sgCredentials$Builder.setSslPassword(cArray);
        }
        return sgCredentials$Builder.build();
    }

    private void prepareTestSettings(g g2) {
        au au2 = g2.c(n.z, true);
        SgSettingsEditor sgSettingsEditor = this.getSettingsEditor();
        sgSettingsEditor.set(SgMirrorOption.SVN_URL, au2 != null ? au2.toString() : null);
        if (g2.a(SgConfigOption.SVN_HTTP_SPOOLING) != null) {
            sgSettingsEditor.set(SgMirrorOption.SVN_HTTP_SPOOLING, g2.d(SgConfigOption.SVN_HTTP_SPOOLING, true));
        }
        if (g2.a(SgConfigOption.SVN_READ_TIMEOUT) != null) {
            sgSettingsEditor.set(SgMirrorOption.SVN_READ_TIMEOUT, g2.a(SgConfigOption.SVN_READ_TIMEOUT, -1));
            if ((Integer)sgSettingsEditor.get(SgMirrorOption.SVN_READ_TIMEOUT, new SgSettingsType[0]) < 0) {
                sgSettingsEditor.set(SgMirrorOption.SVN_READ_TIMEOUT, null);
            }
        }
        if (g2.a(SgConfigOption.SVN_CONNECT_TIMEOUT) != null) {
            sgSettingsEditor.set(SgMirrorOption.SVN_CONNECT_TIMEOUT, g2.a(SgConfigOption.SVN_CONNECT_TIMEOUT, -1));
            if ((Integer)sgSettingsEditor.get(SgMirrorOption.SVN_CONNECT_TIMEOUT, new SgSettingsType[0]) < 0) {
                sgSettingsEditor.set(SgMirrorOption.SVN_CONNECT_TIMEOUT, null);
            }
        }
    }

    private void moveStashManagedOptionsToStash(g g2, SgSettings sgSettings) {
        au au2 = g2.c(n.z, true);
        String string = g2.a(n.k);
        String string2 = g2.a(n.g);
        int n2 = g2.a(SgConfigOption.SVN_FETCH_INTERVAL, -1);
        long l2 = g2.a(n.I, 1L);
        boolean bl2 = g2.d(n.ad, true);
        boolean bl3 = g2.d(n.ae, true);
        sgSettings.set(SgMirrorOption.SVN_URL, au2 != null ? au2.toString() : null);
        if (l2 >= 0L) {
            sgSettings.set(SgMirrorOption.SVN_MINIMAL_REVISION, l2);
        } else {
            g2.g(n.I);
        }
        sgSettings.set(SgMirrorOption.TRANSLATE_EOLS, bl2);
        sgSettings.set(SgMirrorOption.TRANSLATE_IGNORES, bl3);
        if (string != null) {
            sgSettings.set(SgMirrorOption.CORE_DEFAULT_DOMAIN, string);
        }
        if (string2 != null) {
            sgSettings.set(SgMirrorOption.CORE_AUTHORS_FILE_ENCODING, string2);
        }
        if (n2 >= 0) {
            sgSettings.set(SgMirrorOption.SVN_FETCH_INTERVAL, n2);
        } else {
            sgSettings.set(SgMirrorOption.SVN_FETCH_INTERVAL, 0);
            g2.b(SgConfigOption.SVN_FETCH_INTERVAL, 0);
        }
        g2.g(n.k);
        g2.g(SgConfigOption.SVN_HTTP_SPOOLING);
        g2.g(SgConfigOption.SVN_CONNECT_TIMEOUT);
        g2.g(SgConfigOption.SVN_READ_TIMEOUT);
        g2.g(SgConfigOption.SVN_FETCH_INTERVAL);
        g2.g(n.g);
    }

    @Override
    protected void rollbackSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        this.getBackup().restore();
    }

    @Override
    public void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        if (this.getState() == SgTaskState.SUCCESS) {
            this.setPaused(false);
            if (SgFileUtil.isFileExistsAndReadable(this.getRepositoryArea().e())) {
                this.schedule("sync");
            }
        }
    }

    private static SgCredentials[] loadCredentials(g g2) {
        String string;
        char[] cArray;
        String string2 = g2.a(SgConfigOption.SVN_AUTH_USER_NAME);
        String string3 = g2.a(n.z);
        boolean bl2 = string3 != null && string3.startsWith("svn+ssh://");
        boolean bl3 = string3 != null && string3.startsWith("https://");
        ArrayList<SgCredentials> arrayList = new ArrayList<SgCredentials>();
        if (string2 != null && g2.a(SgConfigOption.SVN_AUTH_PASSWORD) != null) {
            arrayList.add(SgUpgradeTask.createSimpleCredentials(string2, g2.a(SgConfigOption.SVN_AUTH_PASSWORD)));
        }
        Map map = SgUpgradeTask.loadPasswordsFile(g2.c(SgConfigOption.SVN_AUTH_PASSWORDS));
        if (bl2) {
            if (string2 != null && g2.c(SgConfigOption.SVN_AUTH_SSH_KEY_FILE) != null) {
                arrayList.add(SgUpgradeTask.createSshKeyCredentials(string2, g2.c(SgConfigOption.SVN_AUTH_SSH_KEY_FILE), g2.a(SgConfigOption.SVN_AUTH_SSH_PASSPHRASE)));
            }
        } else if (bl3 && string2 != null && g2.c(SgConfigOption.SVN_AUTH_SSH_KEY_FILE) != null) {
            arrayList.add(SgUpgradeTask.createSslCertCredentials(string2, g2.c(SgConfigOption.SVN_AUTH_SSL_CERT_FILE), g2.a(SgConfigOption.SVN_AUTH_SSL_PASSPHRASE), g2.a(SgConfigOption.SVN_AUTH_PASSWORD)));
            for (String string4 : map.keySet()) {
                cArray = (char[])map.get(string4);
                string = cArray != null ? new String(cArray) : null;
                arrayList.add(SgUpgradeTask.createSslCertCredentials(string4, g2.c(SgConfigOption.SVN_AUTH_SSL_CERT_FILE), g2.a(SgConfigOption.SVN_AUTH_SSL_PASSPHRASE), string));
            }
        }
        for (String string4 : map.keySet()) {
            cArray = (char[])map.get(string4);
            string = cArray != null ? new String(cArray) : null;
            arrayList.add(SgUpgradeTask.createSimpleCredentials(string4, string));
        }
        if (bl2) {
            arrayList.add(SgUpgradeTask.createAgentCredentials(string2));
        }
        if (g2.d(SgConfigOption.SVN_AUTH_USE_DEFAULT_CONFIG_DIRECTORY, false)) {
            arrayList.add(SgUpgradeTask.createCacheCredentials(null));
        } else if (g2.c(SgConfigOption.SVN_AUTH_CONFIG_DIRECTORY) != null) {
            arrayList.add(SgUpgradeTask.createCacheCredentials(g2.c(SgConfigOption.SVN_AUTH_CONFIG_DIRECTORY)));
        }
        return arrayList.toArray(new SgCredentials[arrayList.size()]);
    }

    private static SgCredentials createSimpleCredentials(String string, String string2) {
        SgCredentials$Builder sgCredentials$Builder = SgCredentials.builder();
        sgCredentials$Builder.setType(SgCredentials$Type.SIMPLE);
        sgCredentials$Builder.setUseCache(false);
        sgCredentials$Builder.setUserName(string);
        sgCredentials$Builder.setPassword(string2 != null ? string2.toCharArray() : null);
        return sgCredentials$Builder.build();
    }

    private static SgCredentials createSshKeyCredentials(String string, File file, String string2) {
        SgCredentials$Builder sgCredentials$Builder = SgCredentials.builder();
        sgCredentials$Builder.setType(SgCredentials$Type.SSH);
        sgCredentials$Builder.setUseCache(false);
        sgCredentials$Builder.setUserName(string);
        byte[] byArray = SgUpgradeTask.loadFile(file);
        if (byArray == null) {
            return null;
        }
        sgCredentials$Builder.setSshKey(file.getName());
        sgCredentials$Builder.setSshKeyValue(byArray);
        sgCredentials$Builder.setPassphrase(string2 != null ? string2.toCharArray() : null);
        return sgCredentials$Builder.build();
    }

    private static SgCredentials createSslCertCredentials(String string, File file, String string2, String string3) {
        SgCredentials$Builder sgCredentials$Builder = SgCredentials.builder();
        sgCredentials$Builder.setType(SgCredentials$Type.SSL);
        sgCredentials$Builder.setUseCache(false);
        sgCredentials$Builder.setUserName(string);
        byte[] byArray = SgUpgradeTask.loadFile(file);
        if (byArray == null) {
            return null;
        }
        sgCredentials$Builder.setSslCert(file.getName());
        sgCredentials$Builder.setSslCertValue(byArray);
        sgCredentials$Builder.setSslPassword(string3 != null ? string3.toCharArray() : null);
        sgCredentials$Builder.setPassphrase(string2 != null ? string2.toCharArray() : null);
        return sgCredentials$Builder.build();
    }

    private static SgCredentials createCacheCredentials(File file) {
        SgCredentials$Builder sgCredentials$Builder = SgCredentials.builder();
        sgCredentials$Builder.setUseCache(true);
        sgCredentials$Builder.setCachePath(file);
        return sgCredentials$Builder.build();
    }

    private static SgCredentials createAgentCredentials(String string) {
        SgCredentials$Builder sgCredentials$Builder = SgCredentials.builder();
        sgCredentials$Builder.setType(SgCredentials$Type.SSH);
        sgCredentials$Builder.setUseCache(false);
        sgCredentials$Builder.setUserName(string);
        sgCredentials$Builder.setUseSshAgent(true);
        return sgCredentials$Builder.build();
    }

    private static Map loadPasswordsFile(File file) {
        if (file == null) {
            return new HashMap();
        }
        try {
            return org.tmatesoft.translator.m.a.d.loadPasswordsFromFile(file);
        }
        catch (f f2) {
            return new HashMap();
        }
    }

    private static byte[] loadFile(File file) {
        try {
            return SVNFileUtil.readFully(file);
        }
        catch (SVNException sVNException) {
            return null;
        }
    }

    private boolean isImported(File file) {
        Map map = this.getMirrorService().loadLegacyStatus(file);
        if (map.get("message") instanceof String) {
            String string = map.get("message").toString();
            return string.startsWith("Import to Git repository ") && string.indexOf(" has been completed; ") > 0;
        }
        return false;
    }

    private static boolean isAuthenticationError(Throwable throwable, Set set) {
        Set set2 = set = set == null ? new HashSet() : set;
        if (throwable instanceof SVNAuthenticationException || throwable instanceof b) {
            return true;
        }
        if (throwable == null || set.contains(throwable)) {
            return false;
        }
        set.add(throwable);
        return SgUpgradeTask.isAuthenticationError(throwable.getCause(), set);
    }
}

