/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.a.a.a.c.C;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.File;
import java.io.Serializable;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.settings.SgSetting;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgUninstallTaskParameters;
import org.tmatesoft.subgit.stash.mirror.util.SgFileUtil;
import org.tmatesoft.translator.m.d.c;
import org.tmatesoft.translator.m.m;

public class SgUninstallTask
extends SgMirrorTask {
    private final SgMirrorService mirrorService;

    public SgUninstallTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, escalatedSecurityContext);
        this.mirrorService = sgMirrorService;
    }

    @Override
    public boolean isRunnable() {
        if (((SgMirrorScope)this.getScope()).isGlobal() || ((SgMirrorScope)this.getScope()).isProject()) {
            return super.isRunnable();
        }
        try {
            return super.isRunnable() && (Boolean)this.runSecurely(() -> {
                Repository repository = this.mirrorService.getRepositoryService().getById(((SgMirrorScope)this.getScope()).getRepositoryId());
                if (repository != null) {
                    File file = this.mirrorService.getMetadataDirectory(repository);
                    c c2 = c.b(file);
                    return SgFileUtil.isFileExistsAndReadable(c2.g());
                }
                return false;
            }) != false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isApplicableFor(SgSettingsSnapshot sgSettingsSnapshot) {
        if (!super.isApplicableFor(sgSettingsSnapshot)) {
            return false;
        }
        if (!((SgMirrorScope)this.getScope()).isProject() && !((SgMirrorScope)this.getScope()).isRepository()) {
            return false;
        }
        if (((SgMirrorScope)this.getScope()).isRepository()) {
            SgMirrorStage sgMirrorStage = (SgMirrorStage)((Object)sgSettingsSnapshot.get(SgMirrorOption.STAGE, new SgSettingsType[0]));
            return sgMirrorStage == SgMirrorStage.LEGACY || sgMirrorStage == SgMirrorStage.NO_LICENSE || sgMirrorStage == SgMirrorStage.INSTALLED || sgMirrorStage == SgMirrorStage.CONFIGURED || sgMirrorStage == SgMirrorStage.PAUSED || sgMirrorStage == SgMirrorStage.UNKNOWN;
        }
        return true;
    }

    @Override
    protected SgUninstallTaskParameters getParameters() {
        if (super.getParameters() instanceof SgUninstallTaskParameters) {
            return (SgUninstallTaskParameters)super.getParameters();
        }
        return SgUninstallTaskParameters.DEFAULT;
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        File file;
        super.runSecurely(sgSettingsSnapshot);
        this.getLogger().info("delete settings: " + this.getParameters().isDeleteSettings());
        this.getLogger().info("delete logs: " + this.getParameters().isDeleteLogs());
        if (((SgMirrorScope)this.getScope()).isRepository() && (file = (File)sgSettingsSnapshot.get(SgMirrorOption.METADATA_PATH, new SgSettingsType[0])) != null) {
            c c2 = c.b(file);
            this.deleteFiles(c2);
        }
        if (this.getParameters().isDeleteSettings()) {
            this.deleteSettings();
        }
    }

    private void deleteSettings() {
        SgSettings sgSettings = this.mirrorService.createSettings((SgMirrorScope)this.getScope());
        for (SgSetting sgSetting : SgMirrorOption.all()) {
            sgSettings.set(sgSetting, null);
        }
    }

    private void deleteFiles(m m2) {
        Object object;
        File file = m2.i();
        if (this.getParameters().isDeleteLogs()) {
            C.b(file);
        } else {
            object = file.listFiles();
            if (object != null) {
                for (File file2 : object) {
                    if (file2.equals(m2.l())) continue;
                    C.b(file2);
                }
            }
        }
        object = new File(m2.d(), "svn");
        C.b((File)object);
    }
}

