/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.a.a.a.c.aT;
import com.atlassian.bitbucket.request.RequestCallback;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRequestInfoProviderAdapter;
import org.tmatesoft.subgit.stash.mirror.tasks.SgSyncTask$1;
import org.tmatesoft.subgit.stash.mirror.tasks.SgSyncTask$ProgressRange;
import org.tmatesoft.translator.b.G;
import org.tmatesoft.translator.h.d;
import org.tmatesoft.translator.i.c;
import org.tmatesoft.translator.i.g;
import org.tmatesoft.translator.i.i;
import org.tmatesoft.translator.i.j;
import org.tmatesoft.translator.i.k;
import org.tmatesoft.translator.i.l;
import org.tmatesoft.translator.i.p;
import org.tmatesoft.translator.i.q;
import org.tmatesoft.translator.k.n;
import org.tmatesoft.translator.m.aY;
import org.tmatesoft.translator.m.aj;
import org.tmatesoft.translator.m.bl;
import org.tmatesoft.translator.m.d.b;
import org.tmatesoft.translator.m.d.h;
import org.tmatesoft.translator.util.B;

public class SgSyncTask
extends SgRepositoryTask
implements c {
    private final Set updatedRefs = new HashSet();
    private final Set conflictedRefs = new HashSet();
    private final SgSyncTask$ProgressRange progressRange = new SgSyncTask$ProgressRange();
    private String readableOperationName;

    public SgSyncTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, sgMirrorService, escalatedSecurityContext);
    }

    @Override
    public boolean shouldCancel(SgTask sgTask) {
        return !"push".equals(sgTask.getName()) && !"apply".equals(sgTask.getName()) && !"unsynced-remove".equals(sgTask.getName()) && !"unsynced-restore".equals(sgTask.getName());
    }

    @Override
    protected EnumSet getApplicableStages() {
        return EnumSet.of(SgMirrorStage.INSTALLED);
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.runSecurely(sgSettingsSnapshot);
        this.readableOperationName = this.isImport() ? "Importing" : "Synchronizing";
        RequestManager requestManager = this.getMirrorService().getRequestManager();
        requestManager.doAsRequest((RequestCallback)new SgSyncTask$1(this, sgSettingsSnapshot), (RequestInfoProvider)new SgRequestInfoProviderAdapter("Sync"));
    }

    protected void runSyncCommands(SgSettingsSnapshot sgSettingsSnapshot) {
        this.setProgressMessage("%s...", 100, this.readableOperationName);
        this.doSync(sgSettingsSnapshot, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSync(SgSettingsSnapshot sgSettingsSnapshot, Collection collection) {
        HashSet hashSet = new HashSet();
        h h2 = this.createProxySync(sgSettingsSnapshot);
        try {
            if (collection != null) {
                this.validateRefDeltas(collection, h2.b());
            }
            this.preSync(h2.c());
            h2.a(this, (List)(collection != null ? new ArrayList(collection) : Collections.emptyList()));
            this.getMirrorService().createSettings((SgMirrorScope)this.getScope()).set(SgMirrorOption.SYNCED, System.currentTimeMillis());
        }
        finally {
            if (this.getState() != SgTaskState.SHUTDOWN) {
                hashSet.addAll(this.updatedRefs);
                hashSet.addAll(this.conflictedRefs);
                this.updatedRefs.clear();
                this.conflictedRefs.clear();
                d.getLogger().info("about to refresh repository");
                for (org.tmatesoft.translator.e.i i2 : hashSet) {
                    d.getLogger().info("    ref delta: " + String.valueOf(i2));
                }
                this.getMirrorService().forceRepositoryRefresh(this.getRepository(), hashSet);
                this.getMirrorService().getLicenseManager().updateLicenseInfo(this.getMirrorService().createProxyRepository(this.getRepository()));
            }
        }
    }

    private void validateRefDeltas(@NotNull Collection collection, @NotNull b b2) {
        List list = b2.Q();
        if (list.size() > 0) {
            aj aj2 = (aj)list.get(0);
            aT aT2 = aj2.G();
            ArrayList<org.tmatesoft.translator.e.i> arrayList = new ArrayList<org.tmatesoft.translator.e.i>();
            for (org.tmatesoft.translator.e.i i2 : collection) {
                if (aY.a(aT2, i2.a())) continue;
                arrayList.add(i2);
            }
            if (arrayList.size() > 0) {
                String string = n.a(arrayList, Collections.emptyList());
                throw new B(string, new Object[0]);
            }
        }
    }

    protected void preSync(@NotNull G g2) {
    }

    @NotNull
    protected h createProxySync(SgSettings sgSettings) {
        b b2 = this.createProxyRepository(sgSettings);
        h h2 = (h)b2.p();
        h2.a(this);
        h2.a(this.getMirrorService().getAuthorsService().loadAuthorsMapping(sgSettings, this.getRepositoryArea()));
        return h2;
    }

    @Override
    public void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        SgTaskState sgTaskState = this.getState();
        if (sgTaskState == SgTaskState.SUCCESS || sgTaskState == SgTaskState.FAILED) {
            if (sgTaskState == SgTaskState.SUCCESS && this.isImport()) {
                this.setImportAndPaused(false, true);
            } else if ((Integer)sgSettingsSnapshot.get(SgMirrorOption.SVN_FETCH_INTERVAL, new SgSettingsType[0]) > 0) {
                this.schedule("sync", System.currentTimeMillis() + (long)((Integer)sgSettingsSnapshot.get(SgMirrorOption.SVN_FETCH_INTERVAL, new SgSettingsType[0]) * 1000));
            }
        } else if (sgTaskState == SgTaskState.CANCELLED) {
            this.setPaused(true);
        }
    }

    @Override
    public void startTranslation(@NotNull k k2) {
        this.progressRange.reset();
    }

    @Override
    public void onProgressRange(@NotNull org.tmatesoft.translator.i.h h2) {
        d.getLogger().info("progress range: " + String.valueOf(h2));
        this.progressRange.setRangeMessage(h2);
    }

    @Override
    public void onTranslation(@NotNull q q2) {
        if (q2.a() == bl.a) {
            if (this.progressRange != null && this.progressRange.getTotal() > 0L) {
                int n2 = this.progressRange.computeProgress(q2.d());
                this.setProgressMessage("%s, revision %s of %s translated...", n2, this.readableOperationName, q2.d(), this.progressRange.getTotal());
            } else {
                this.setProgressMessage("%s, revision %s translated...", 100, this.readableOperationName, q2.d());
            }
        } else {
            this.setProgressMessage("%s, commit %s translated...", 100, this.readableOperationName, q2.b());
        }
    }

    @Override
    public void onSkipCommit(@NotNull i i2) {
    }

    @Override
    public void startConflictResolution(@NotNull j j2) {
        this.progressRange.reset();
    }

    @Override
    public void doneConflictResolution(@NotNull g g2) {
        this.conflictedRefs.addAll(g2.b());
        this.progressRange.reset();
    }

    @Override
    public void doneTranslation(@NotNull p p2) {
        this.updatedRefs.addAll(p2.b());
        this.progressRange.reset();
    }

    @Override
    public void syncDone(@NotNull l l2) {
        this.progressRange.reset();
    }

    @Override
    public void failedTranslation(p p2, Throwable throwable) {
        this.updatedRefs.addAll(p2.b());
        this.progressRange.reset();
    }

    @Override
    public void onCorruptionDetected() {
        this.setProgressMessage(null, -1, new Object[0]);
        this.setState(SgTaskState.FAILING, "Sync failed, collecting additional information...");
    }
}

