/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.Serializable;
import java.util.EnumSet;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryTask;

public class SgStartTask
extends SgRepositoryTask {
    private final boolean isStartImportCommand;

    public SgStartTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, boolean bl2, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, sgMirrorService, escalatedSecurityContext);
        this.isStartImportCommand = bl2;
    }

    @Override
    protected EnumSet getApplicableStages() {
        return EnumSet.of(SgMirrorStage.PAUSED, SgMirrorStage.CONFIGURED);
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.runSecurely(sgSettingsSnapshot);
        if (this.isStartImportCommand()) {
            this.setProgressMessage("Starting import...", 100, new Object[0]);
        } else {
            this.setProgressMessage("Starting synchronization...", 100, new Object[0]);
        }
        if (this.getStage() == SgMirrorStage.CONFIGURED) {
            this.backupConfiguration();
            boolean bl2 = (Boolean)this.getUserSettings().get(SgMirrorOption.FORCE_REFETCH, new SgSettingsType[0]);
            this.updateUserConfiguration(this.getUserSettings());
            this.getSettingsEditor().set(this.getUserSettings(), SgMirrorOption.USER);
            this.getSettingsEditor().set(SgMirrorOption.FORCE_REFETCH, false);
            this.install(this.getSettingsEditor(), bl2);
            this.getSettingsEditor().save();
            this.getBackup().delete();
        }
        this.setPaused(false);
        this.setMessage(null, new Object[0]);
    }

    private boolean isStartImportCommand() {
        return this.isStartImportCommand;
    }

    @Override
    protected void rollbackSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        this.getBackup().restore();
        this.setPaused(true);
    }

    @Override
    protected void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        if (this.getState() == SgTaskState.SUCCESS && !this.isPaused()) {
            this.setImportAndPaused(this.isStartImportCommand(), false);
            this.schedule("verify");
        }
    }
}

