/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.a.a.a.b.k;
import com.a.a.a.d.au;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestCallback;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.svn.SgAuthenticationManagerProvider;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryTask$1;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryTask$2;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRequestInfoProviderAdapter;
import org.tmatesoft.subgit.stash.mirror.util.SgBackup;
import org.tmatesoft.subgit.stash.mirror.util.SgConfigOption;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;
import org.tmatesoft.translator.b.g;
import org.tmatesoft.translator.b.n;
import org.tmatesoft.translator.b.o;
import org.tmatesoft.translator.h.d;
import org.tmatesoft.translator.m.d.b;
import org.tmatesoft.translator.m.d.c;
import org.tmatesoft.translator.m.m;
import org.tmatesoft.translator.util.f;
import org.tmatesoft.translator.util.z;

public abstract class SgRepositoryTask
extends SgMirrorTask {
    private final SgBackup backup;
    private final SgMirrorService mirrorService;
    private SgMirrorStage stage;
    private File repositoryDirectory;
    private File metadataDirectory;
    private c repositoryArea;
    private Repository repository;

    protected SgRepositoryTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, escalatedSecurityContext);
        this.mirrorService = sgMirrorService;
        this.backup = new SgBackup();
    }

    protected SgMirrorService getMirrorService() {
        return this.mirrorService;
    }

    protected void backupConfiguration() {
        this.getBackup().backup(this.getMirrorService().getUserVisibleConfigFile(this.getRepositoryArea()));
        this.getBackup().backup(this.getMirrorService().getUserHiddenConfigFile(this.getRepositoryArea()));
        this.getBackup().backup(this.getRepositoryArea().m());
        this.getBackup().backup(this.getRepositoryArea().h());
    }

    protected abstract EnumSet getApplicableStages();

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.runSecurely(sgSettingsSnapshot);
        this.getLogger().info(this.mirrorService.getPluginPropertiesService().getServerInformation());
        this.repositoryDirectory = (File)sgSettingsSnapshot.get(SgMirrorOption.REPOSITORY_PATH, new SgSettingsType[0]);
        this.metadataDirectory = (File)sgSettingsSnapshot.get(SgMirrorOption.METADATA_PATH, new SgSettingsType[0]);
        this.stage = (SgMirrorStage)((Object)sgSettingsSnapshot.get(SgMirrorOption.STAGE, new SgSettingsType[0]));
        this.repositoryArea = c.b(this.metadataDirectory);
        this.repository = this.getMirrorService().getRepositoryService().getById(((SgMirrorScope)this.getScope()).getRepositoryId());
        if (this.repository == null) {
            throw new SgException("repository not found, id: " + ((SgMirrorScope)this.getScope()).getRepositoryId());
        }
    }

    public boolean isApplicableFor(SgSettingsSnapshot sgSettingsSnapshot) {
        if (super.isApplicableFor(sgSettingsSnapshot)) {
            SgMirrorStage sgMirrorStage = (SgMirrorStage)((Object)sgSettingsSnapshot.get(SgMirrorOption.STAGE, new SgSettingsType[0]));
            return this.getApplicableStages().contains((Object)sgMirrorStage);
        }
        return false;
    }

    protected SgBackup getBackup() {
        return this.backup;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected File getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    protected File getMetadataDirectory() {
        return this.metadataDirectory;
    }

    protected m getRepositoryArea() {
        return this.repositoryArea;
    }

    protected SgMirrorStage getStage() {
        return this.stage;
    }

    protected void setPaused(boolean bl2) {
        this.setImportAndPaused((Boolean)this.mirrorService.createSettings((SgMirrorScope)this.getScope()).get(SgMirrorOption.IMPORT, new SgSettingsType[0]), bl2);
    }

    protected void setImportAndPaused(boolean bl2, boolean bl3) {
        SgSettings sgSettings = this.mirrorService.createSettings((SgMirrorScope)this.getScope());
        boolean bl4 = (Boolean)sgSettings.get(SgMirrorOption.IMPORT, new SgSettingsType[0]);
        boolean bl5 = (Boolean)sgSettings.get(SgMirrorOption.PAUSED, new SgSettingsType[0]);
        if (bl2 != bl4) {
            sgSettings.set(SgMirrorOption.IMPORT, bl2);
        }
        if (bl3 != bl5) {
            sgSettings.set(SgMirrorOption.PAUSED, bl3);
        }
        if (bl4 != bl2 || bl5 != bl3) {
            try {
                this.getScheduler().dataChanged((SgMirrorScope)this.getScope(), this.mirrorService.loadState((SgMirrorScope)this.getScope()));
            }
            catch (Throwable throwable) {
                this.getLogger().info("failed to load state");
                this.getLogger().info(throwable.getMessage(), throwable);
            }
        }
    }

    protected boolean isPaused() {
        return (Boolean)this.mirrorService.createSettings((SgMirrorScope)this.getScope()).get(SgMirrorOption.PAUSED, new SgSettingsType[0]);
    }

    protected boolean isImport() {
        return (Boolean)this.mirrorService.createSettings((SgMirrorScope)this.getScope()).get(SgMirrorOption.IMPORT, new SgSettingsType[0]);
    }

    protected b createProxyRepository(SgSettings sgSettings) {
        try {
            b b2 = this.getMirrorService().createProxyRepository(this.getRepository());
            SgAuthenticationManagerProvider sgAuthenticationManagerProvider = this.getMirrorService().getSubversionService().createAuthenticationProvider(sgSettings, this.getLogger());
            b2.a(sgAuthenticationManagerProvider);
            b2.a((Boolean)sgSettings.get(SgMirrorOption.SVN_HTTP_SPOOLING, new SgSettingsType[0]));
            return b2;
        }
        catch (f f2) {
            throw SgException.wrap(f2);
        }
    }

    protected void install(SgSettings sgSettings, boolean bl2) {
        this.getMirrorService().getRequestManager().doAsRequest((RequestCallback)new SgRepositoryTask$1(this, sgSettings, bl2), (RequestInfoProvider)new SgRequestInfoProviderAdapter("Install"));
    }

    protected void rebuild(SgSettings sgSettings, long l2) {
        this.getMirrorService().getRequestManager().doAsRequest((RequestCallback)new SgRepositoryTask$2(this, sgSettings, l2), (RequestInfoProvider)new SgRequestInfoProviderAdapter("Rebuild"));
    }

    protected void moveConfigOptions(g g2, g g3, n ... nArray) {
        d.getLogger().info("extracting non-editable options from '%s' to '%s'", g2.a(), g3.a());
        HashSet<n> hashSet = new HashSet<n>(Arrays.asList(nArray != null ? nArray : new n[]{}));
        for (String string : g2.f()) {
            o o2 = o.a(string);
            List list = g2.a(o2);
            if (list.isEmpty()) {
                list.add(null);
            }
            for (String string2 : list) {
                for (n n2 : g2.b(o2, string2)) {
                    d.getLogger().info("  extracting option : '%s'", n2);
                    if (!hashSet.contains(n2)) {
                        List list2 = g2.b(n2);
                        g3.a(n2, list2);
                        g2.g(n2);
                        d.getLogger().info("    option moved to '%s'", g3.a());
                        continue;
                    }
                    d.getLogger().info("    option '%s' is editable, remains", n2);
                }
            }
        }
    }

    protected String getDaemonClasspath() {
        z z2 = z.r();
        String string = z2.e() + "-" + z2.f();
        File file = new File(this.getMirrorService().getStorageService().getDataDir().toFile(), "subgit");
        File file2 = new File(file, "lib/" + string);
        return file2.getAbsolutePath().replace(File.separatorChar, '/');
    }

    protected void documentConfig(g g2) {
        g2.b();
        g2.e();
        g2.c();
    }

    protected void setConfigOption(g g2, n n2, String string) {
        if (string == null) {
            g2.g(n2);
        } else {
            g2.b(n2, string);
        }
    }

    protected void deleteAuthenticationOptions(g g2) {
        Set set = g2.b(o.d, "default");
        for (n n2 : set) {
            g2.g(n2);
        }
        g2.b(SgConfigOption.SVN_AUTH_CONFIG_DIRECTORY, "subgit");
        String string = "hercule";
        g2.b(SgConfigOption.SVN_AUTH_USER_NAME, "hercule");
    }

    protected g createUserVisibleConfig() {
        return g.a(this.getMirrorService().getUserVisibleConfigFile(this.getRepositoryArea()), this.getRepositoryArea().d());
    }

    protected g createUserHiddenConfig() {
        return g.a(this.getMirrorService().getUserHiddenConfigFile(this.getRepositoryArea()), this.getRepositoryArea().d());
    }

    protected g createActiveConfig() {
        return g.a(this.getRepositoryArea().e(), this.getRepositoryArea().d());
    }

    protected void updateUserConfiguration(SgSettings sgSettings) {
        m m2 = this.getRepositoryArea();
        String string = (String)sgSettings.get(SgMirrorOption.CONFIG, new SgSettingsType[0]);
        SgTextUtil.writeTextFileContents(this.getMirrorService().getUserVisibleConfigFile(m2), string, this.getLogger());
        String string2 = (String)sgSettings.get(SgMirrorOption.AUTHORS, new SgSettingsType[0]);
        SgTextUtil.writeTextFileContents(this.getRepositoryArea().m(), string2, this.getLogger());
        this.updateOptionsInHiddenConfig(sgSettings, this.getStage() == SgMirrorStage.INSTALLED || this.getStage() == SgMirrorStage.PAUSED);
    }

    protected void updateOptionsInHiddenConfig(SgSettings sgSettings, boolean bl2) {
        g g2 = this.createUserHiddenConfig();
        g2.b();
        try {
            if (sgSettings.get(SgMirrorOption.SVN_URL, new SgSettingsType[0]) != null) {
                g2.a(n.z, au.b((String)sgSettings.get(SgMirrorOption.SVN_URL, new SgSettingsType[0])));
            }
        }
        catch (k k2) {
            throw SgException.wrap(k2);
        }
        if (!bl2) {
            g2.b(n.I, (Long)sgSettings.get(SgMirrorOption.SVN_MINIMAL_REVISION, new SgSettingsType[0]));
            g2.e(n.ad, (Boolean)sgSettings.get(SgMirrorOption.TRANSLATE_EOLS, new SgSettingsType[0]));
            g2.e(n.ae, (Boolean)sgSettings.get(SgMirrorOption.TRANSLATE_IGNORES, new SgSettingsType[0]));
        }
        g2.c();
    }
}

