/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.Serializable;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgBootstrapSchedule;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorTask;

public class SgRepositoryMovedTask
extends SgMirrorTask {
    private final SgMirrorService mirrorService;
    private long syncTime;

    protected SgRepositoryMovedTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, escalatedSecurityContext);
        this.mirrorService = sgMirrorService;
        this.syncTime = 0L;
    }

    @Override
    public boolean shouldCancel(SgTask sgTask) {
        if (sgTask.getName().equals("sync")) {
            this.syncTime = sgTask.getTimeToRun();
        }
        return true;
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        SgMirrorScope sgMirrorScope = (SgMirrorScope)this.getParameters();
        SgSettings sgSettings = this.mirrorService.createSettings(sgMirrorScope);
        sgSettings.editor().set(sgSettingsSnapshot, new SgSettingsType[0]).save();
        this.getLogger().info("settings for " + String.valueOf(this.getScope()) + " copied to " + String.valueOf(sgMirrorScope));
    }

    @Override
    protected void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        SgMirrorScope sgMirrorScope = (SgMirrorScope)this.getParameters();
        this.getScheduler().bootstrap(sgMirrorScope, SgBootstrapSchedule.scheduled());
        if (this.syncTime != 0L) {
            this.getLogger().info("sync for " + String.valueOf(this.getScope()) + " will be rescheduled for " + String.valueOf(sgMirrorScope));
            this.getScheduler().schedule(sgMirrorScope, "sync", this.syncTime, null);
        }
        super.postRunSecurely(sgSettingsSnapshot);
    }
}

