/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.EnumSet;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryTask;

public class SgRepositoryApplyTask
extends SgRepositoryTask {
    public SgRepositoryApplyTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, sgMirrorService, escalatedSecurityContext);
    }

    @Override
    protected EnumSet getApplicableStages() {
        return EnumSet.of(SgMirrorStage.INSTALLED, SgMirrorStage.CONFIGURED, SgMirrorStage.PAUSED);
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.runSecurely(sgSettingsSnapshot);
        this.setProgressMessage("Applying configuration...", 100, new Object[0]);
        this.backupConfiguration();
        SgSettingsSnapshot sgSettingsSnapshot2 = this.getUserSettings();
        boolean bl2 = (Boolean)sgSettingsSnapshot2.get(SgMirrorOption.FORCE_REFETCH, new SgSettingsType[0]);
        boolean bl3 = (Boolean)sgSettingsSnapshot2.get(SgMirrorOption.FORCE_REBUILD, new SgSettingsType[0]);
        this.updateUserConfiguration(sgSettingsSnapshot2);
        this.getSettingsEditor().set(sgSettingsSnapshot2, SgMirrorOption.USER);
        this.getSettingsEditor().set(SgMirrorOption.FORCE_REFETCH, false);
        this.getSettingsEditor().set(SgMirrorOption.FORCE_REBUILD, false);
        if (this.getStage() != SgMirrorStage.CONFIGURED) {
            if (bl3) {
                this.getLogger().info("Mirror Rebuild");
                this.rebuild(this.getSettingsEditor(), 1L);
                Path path = this.getMirrorService().getUserVisibleConfigFile(this.getRepositoryArea()).toPath();
                Path path2 = this.getMirrorService().getActiveUserVisibleConfigFile(this.getRepositoryArea()).toPath();
                Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
            } else {
                this.getLogger().info("Mirror Install");
                this.install(this.getSettingsEditor(), bl2);
            }
        }
        this.getSettingsEditor().save();
        this.getBackup().delete();
        this.setMessage("Configuration changes applied", new Object[0]);
    }

    @Override
    protected void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        if (!this.isPaused() && (Integer)this.getUserSettings().get(SgMirrorOption.SVN_FETCH_INTERVAL, new SgSettingsType[0]) > 0) {
            this.schedule("verify", this.getState() == SgTaskState.FAILED ? System.currentTimeMillis() + 2100L : -1L);
        }
    }

    @Override
    public void rollback(SgSettingsSnapshot sgSettingsSnapshot) {
        this.getBackup().restore();
        super.rollback(sgSettingsSnapshot);
    }
}

