/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.Serializable;
import java.util.EnumSet;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsEditor;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryTask;
import org.tmatesoft.subgit.stash.mirror.util.SgVerifyInfo;

public class SgRebuildTask
extends SgRepositoryTask {
    public SgRebuildTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, sgMirrorService, escalatedSecurityContext);
    }

    @Override
    protected EnumSet getApplicableStages() {
        return EnumSet.of(SgMirrorStage.INSTALLED, SgMirrorStage.PAUSED);
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.runSecurely(sgSettingsSnapshot);
        this.setProgressMessage("Preparing rebuild...", 100, new Object[0]);
        this.backupConfiguration();
        SgSettingsSnapshot sgSettingsSnapshot2 = this.getUserSettings();
        SgVerifyInfo sgVerifyInfo = (SgVerifyInfo)sgSettingsSnapshot2.get(SgMirrorOption.VERIFY_INFO, new SgSettingsType[0]);
        if (sgVerifyInfo != null) {
            this.rebuild(this.getSettingsEditor(), sgVerifyInfo.getRebuildRevision());
        }
        this.getBackup().delete();
        this.setMessage("Mirror is ready for rebuild", new Object[0]);
    }

    @Override
    protected void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        if (this.getState() == SgTaskState.SUCCESS) {
            SgSettingsEditor sgSettingsEditor = this.getSettingsEditor();
            sgSettingsEditor.set(SgMirrorOption.VERIFY_INFO, null);
            sgSettingsEditor.save();
        }
        if (this.isPaused()) {
            this.setImportAndPaused(true, false);
        }
        this.schedule("verify", this.getState() == SgTaskState.FAILED ? System.currentTimeMillis() + 2100L : -1L);
    }

    @Override
    public void rollback(SgSettingsSnapshot sgSettingsSnapshot) {
        this.getBackup().restore();
        super.rollback(sgSettingsSnapshot);
    }
}

