/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.a.a.a.b.i;
import com.a.a.a.c.C;
import com.atlassian.bitbucket.io.PathInputHandler;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.errors.MissingObjectException;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.cmdline.SgDummyOutputHandler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTask$MessageSender;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTaskParameters;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTaskParameters$Command;
import org.tmatesoft.subgit.stash.mirror.tasks.SgSyncTask;
import org.tmatesoft.subgit.stash.web.hooks.SgExtendedPostReceiveHook;
import org.tmatesoft.subgit.stash.web.hooks.SgExtendedPreReceiveHook;
import org.tmatesoft.translator.b.G;
import org.tmatesoft.translator.c.D;
import org.tmatesoft.translator.e.b;
import org.tmatesoft.translator.h.d;
import org.tmatesoft.translator.i.a;
import org.tmatesoft.translator.i.g;
import org.tmatesoft.translator.i.h;
import org.tmatesoft.translator.i.j;
import org.tmatesoft.translator.i.k;
import org.tmatesoft.translator.i.l;
import org.tmatesoft.translator.i.p;
import org.tmatesoft.translator.i.q;
import org.tmatesoft.translator.k.s;
import org.tmatesoft.translator.m.Z;
import org.tmatesoft.translator.m.bl;
import org.tmatesoft.translator.m.u;
import org.tmatesoft.translator.util.f;
import org.tmatesoft.translator.util.r;

public class SgPushTask
extends SgSyncTask {
    private static final String GIT_QUARANTINE_PATH = "GIT_QUARANTINE_PATH";
    private a standardSyncListener = a.c;
    private SgPushTask$MessageSender messageSender = null;

    public SgPushTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, sgMirrorService, escalatedSecurityContext);
    }

    @Override
    public boolean isRunnable() {
        return ((SgMirrorScope)this.getScope()).isRepository();
    }

    @Override
    public boolean shouldCancel(SgTask sgTask) {
        return sgTask != null && "sync".equals(sgTask.getName());
    }

    @Override
    public SgPushTaskParameters getParameters() {
        return (SgPushTaskParameters)super.getParameters();
    }

    @Override
    protected void runSyncCommands(SgSettingsSnapshot sgSettingsSnapshot) {
        this.setProgressMessage("Synchronizing...", 100, new Object[0]);
        if (this.getParameters().isCollectFromQuarantine()) {
            this.collectFromQuarantine();
        }
        List list = this.getParameters().getCommandsFor(this.getStage());
        for (SgPushTaskParameters$Command sgPushTaskParameters$Command : list) {
            switch (sgPushTaskParameters$Command) {
                case SYNC_WITH_DELTAS: {
                    this.checkObjectsPresence(this.getParameters().getRefDeltas());
                    this.doSync(sgSettingsSnapshot, this.getParameters().getRefDeltas());
                    break;
                }
                case SYNC: {
                    this.doSync(sgSettingsSnapshot, Collections.emptyList());
                    break;
                }
                case PRE_RECEIVE: {
                    this.sendPreReceive();
                    break;
                }
                case FETCH: {
                    this.sendFetch();
                    break;
                }
                case POST_RECEIVE: {
                    this.sendPostReceive();
                }
            }
        }
    }

    @Override
    public boolean isApplicableFor(SgSettingsSnapshot sgSettingsSnapshot) {
        return true;
    }

    private void sendFetch() {
        r r2 = this.getMirrorService().getPlatform();
        try {
            org.tmatesoft.translator.c.j j2 = org.tmatesoft.translator.c.j.a(this.getRepositoryDirectory(), r2, "subgit-sync-daemon");
            j2.a(a.c);
        }
        catch (Throwable throwable) {
            d.getLogger().info(throwable);
        }
    }

    private void sendPreReceive() {
        r r2 = this.getMirrorService().getPlatform();
        s s2 = this.getParameters().getConsole().createProcessEnvironment(r2);
        try {
            org.tmatesoft.translator.k.j j2 = new org.tmatesoft.translator.k.j();
            j2.b(this.getRepositoryDirectory().getAbsolutePath());
            org.tmatesoft.translator.k.i i2 = j2.d();
            b b2 = new b(i2);
            SgExtendedPreReceiveHook sgExtendedPreReceiveHook = new SgExtendedPreReceiveHook(s2, b2, this.getParameters().getRefDeltas());
            sgExtendedPreReceiveHook.execute();
        }
        catch (Throwable throwable) {
            d.getLogger().info(throwable);
            throw f.b(throwable);
        }
    }

    private void sendPostReceive() {
        r r2 = this.getMirrorService().getPlatform();
        s s2 = this.getParameters().getConsole().createProcessEnvironment(r2);
        try {
            org.tmatesoft.translator.k.j j2 = new org.tmatesoft.translator.k.j();
            j2.b(this.getRepositoryDirectory().getAbsolutePath());
            org.tmatesoft.translator.k.i i2 = j2.d();
            b b2 = new b(i2);
            SgExtendedPostReceiveHook sgExtendedPostReceiveHook = new SgExtendedPostReceiveHook(s2, b2, this.getParameters().getRefDeltas());
            sgExtendedPostReceiveHook.execute();
        }
        catch (Throwable throwable) {
            d.getLogger().info(throwable);
        }
    }

    private void checkObjectsPresence(Collection collection) {
        Z z2 = this.getMirrorService().getGitRepositoryKey(this.getRepository());
        try {
            u.a(this.getMirrorService().getGitRepositoryFactory(), z2, new ArrayList(collection));
        }
        catch (MissingObjectException missingObjectException) {
            this.getLogger().error(missingObjectException.getMessage(), (Throwable)missingObjectException);
            String string = "Push failed: necessary object missing.\nPushed object " + String.valueOf(missingObjectException.getObjectId()) + " has not been found in Git repository.\nThis may happen in case Bitbucket Server resources (processes count, memory or disk space) are exhausted.\nCheck Bitbucket Server state and retry push.";
            throw f.b(string, new Object[0]);
        }
    }

    private void collectFromQuarantine() {
        this.getLogger().info("Collecting objects from quarantine.");
        this.getLogger().info("Environment: " + String.valueOf(this.getParameters().getEnvironment()));
        Z z2 = this.getMirrorService().getGitRepositoryKey(this.getRepository());
        org.tmatesoft.translator.m.f f2 = this.getMirrorService().getGitRepositoryFactory().createGitRepositoryArea(z2);
        String string = this.getParameters().getPackFilePath();
        if (string != null) {
            this.getLogger().info("About to run 'unpack-objects' for '" + string + "'.");
            GitCommandBuilderFactory gitCommandBuilderFactory = this.getMirrorService().getGitCommandBuilderFactory();
            ((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)gitCommandBuilderFactory.builder(this.getRepository()).argument("-q")).command("unpack-objects")).inputHandler((CommandInputHandler)new PathInputHandler(Paths.get(string, new String[0])))).build((CommandOutputHandler)new SgDummyOutputHandler()).synchronous().call();
            try {
                C.i(new File(string));
            }
            catch (i i2) {
                throw f.b(i2);
            }
        } else {
            String string2 = (String)this.getParameters().getEnvironment().get(GIT_QUARANTINE_PATH);
            if (string2 != null && !"".equals(string2.trim())) {
                File file = new File(string2).getAbsoluteFile();
                if (file.isDirectory()) {
                    try {
                        f2.collectObjectsFromIncomingDirectory(file, null);
                    }
                    catch (i i3) {
                        throw f.b(i3);
                    }
                } else {
                    this.getLogger().info("Incoming objects directory path '" + string2 + "' does not refer to a directory.");
                }
            } else {
                this.getLogger().info("Incoming objects directory path is not set in the environment.");
            }
        }
    }

    @Override
    protected void preSync(@NotNull G g2) {
        super.preSync(g2);
        this.messageSender = new SgPushTask$MessageSender(this);
        this.standardSyncListener = new D(this.messageSender, g2);
    }

    @Override
    public void startTranslation(@NotNull k k2) {
        super.startTranslation(k2);
        this.standardSyncListener.startTranslation(k2);
        String string = k2.a() == bl.b ? "sending commits to SVN repository" : "fetching revisions from SVN repository";
        this.setProgressMessage("%s", 100, string);
    }

    @Override
    public void onProgressRange(@NotNull h h2) {
        super.onProgressRange(h2);
        this.standardSyncListener.onProgressRange(h2);
    }

    @Override
    public void onTranslation(@NotNull q q2) {
        this.standardSyncListener.onTranslation(q2);
        String string = q2.a() == bl.b ? "commit " + String.valueOf(q2.b()) : "revision " + q2.d();
        this.setProgressMessage("synchronizing %s", 100, string);
    }

    @Override
    public void onSkipCommit(@NotNull org.tmatesoft.translator.i.i i2) {
        super.onSkipCommit(i2);
        this.standardSyncListener.onSkipCommit(i2);
    }

    @Override
    public void startConflictResolution(@NotNull j j2) {
        super.startConflictResolution(j2);
        this.standardSyncListener.startConflictResolution(j2);
        if (j2.a() == bl.b) {
            String string = "recovering unsynced Git commits...";
            this.setProgressMessage("%s", 100, "recovering unsynced Git commits...");
        }
    }

    @Override
    public void doneConflictResolution(@NotNull g g2) {
        super.doneConflictResolution(g2);
        this.standardSyncListener.doneConflictResolution(g2);
    }

    @Override
    public void doneTranslation(@NotNull p p2) {
        super.doneTranslation(p2);
        this.standardSyncListener.doneTranslation(p2);
    }

    @Override
    public void failedTranslation(p p2, Throwable throwable) {
        super.failedTranslation(p2, throwable);
        this.standardSyncListener.failedTranslation(p2, throwable);
    }

    @Override
    public void syncDone(@NotNull l l2) {
        super.syncDone(l2);
        if (l2.b()) {
            this.standardSyncListener.syncDone(l2);
        } else {
            this.println("", new Object[0]);
            this.println("There are unsynced commits in Git repository;", new Object[0]);
            String string = this.getMirrorService().getNavBuilder().pluginServlets().path(new String[]{"svn", "projects", this.getRepository().getProject().getKey(), "repos", this.getRepository().getSlug()}).buildAbsolute() + "#unsynced";
            this.println("Visit '%s' to review and resolve them.", string);
            this.println("", new Object[0]);
        }
    }

    @Override
    public void onCorruptionDetected() {
        super.onCorruptionDetected();
        if (this.messageSender != null) {
            this.messageSender.sendMessage("Sync failed: unexpected error");
            this.messageSender.sendMessage("Sync failed: collecting additional information...");
        }
    }

    @Override
    public void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        if (this.getStage() == SgMirrorStage.INSTALLED && (Integer)sgSettingsSnapshot.get(SgMirrorOption.SVN_FETCH_INTERVAL, new SgSettingsType[0]) > 0) {
            this.schedule("sync", System.currentTimeMillis() + (long)((Integer)sgSettingsSnapshot.get(SgMirrorOption.SVN_FETCH_INTERVAL, new SgSettingsType[0]) * 1000));
        }
    }

    private void println(String string, Object ... objectArray) {
        if (string == null) {
            string = "null";
            objectArray = new Object[]{};
        }
        this.getParameters().getConsole().println(string, objectArray);
    }
}

