/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.tasks.SgBootstrapSchedule;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMoveMetadataTask$1;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMoveMetadataTask$2;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMoveMetadataTask$3;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryTask;
import org.tmatesoft.translator.m.O;
import org.tmatesoft.translator.m.Y;
import org.tmatesoft.translator.m.Z;
import org.tmatesoft.translator.m.d.c;
import org.tmatesoft.translator.util.l;

public class SgMoveMetadataTask
extends SgRepositoryTask {
    protected SgMoveMetadataTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, sgMirrorService, escalatedSecurityContext);
    }

    @Override
    protected EnumSet getApplicableStages() {
        return EnumSet.of(SgMirrorStage.PENDING_METADATA_MOVE);
    }

    @Nullable
    private SgBootstrapSchedule getBootstrapSchedule() {
        if (this.getParameters() instanceof SgBootstrapSchedule) {
            return (SgBootstrapSchedule)this.getParameters();
        }
        return null;
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.runSecurely(sgSettingsSnapshot);
        this.moveRepositoryMetadata();
        this.getScheduler().dataChanged((SgMirrorScope)this.getScope(), this.getMirrorService().loadState((SgMirrorScope)this.getScope()));
    }

    private void moveRepositoryMetadata() {
        Repository repository = this.getMirrorService().getRepositoryService().getById(((SgMirrorScope)this.getScope()).getRepositoryId());
        File file = this.getMirrorService().getMetadataDirectory(repository);
        File file2 = this.getMirrorService().getRepositoryDirectory(repository);
        this.moveRepositoryMetadata(file2, file);
    }

    private void moveRepositoryMetadata(File file, File file2) {
        String string = "-" + new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.US).format(new Date()) + "-backup";
        try {
            Files.createDirectories(file2.toPath(), new FileAttribute[0]);
            O o2 = new O();
            c c2 = c.b(file);
            c c3 = c.b(file2);
            Y y2 = o2.a(Z.a(file));
            Y y3 = o2.a(Z.a(file2));
            this.setProgressMessage("Migrating 'db' directory...", 100, new Object[0]);
            this.getLogger().info("Moving " + String.valueOf(c2.w()) + " => " + String.valueOf(c3.w()));
            this.copyRegularDirectory(c2.w().toPath(), c3.w().toPath(), string);
            this.setProgressMessage("Migrating 'svn' directory...", 100, new Object[0]);
            this.getLogger().info("Moving " + String.valueOf(y2.b()) + " => " + String.valueOf(y3.b()));
            this.copyRegularDirectory(y2.b().toPath(), y3.b().toPath(), string);
            this.setProgressMessage("Migrating 'subgit' directory...", 100, new Object[0]);
            this.getLogger().info("Moving " + String.valueOf(c2.i()) + " => " + String.valueOf(c3.i()));
            Map map = this.copySubGitDirectory(c2, c3, string);
            for (Map.Entry entry : map.entrySet()) {
                this.rename((Path)entry.getKey(), (Path)entry.getValue());
            }
        }
        catch (IOException | l exception) {
            throw SgException.wrap(exception);
        }
    }

    private void copyRegularDirectory(Path path, Path path2, String string) {
        Path path3 = path2.resolveSibling(String.valueOf(path.getFileName()) + string);
        if (Files.exists(path2, LinkOption.NOFOLLOW_LINKS)) {
            try {
                this.getLogger().debug("Moving " + String.valueOf(path2) + " => " + String.valueOf(path3));
                Files.move(path2, path3, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException iOException) {
                this.getLogger().error("Failed to rename " + String.valueOf(path2) + " to " + String.valueOf(path3));
            }
        }
        Files.walkFileTree(path, new SgMoveMetadataTask$1(this, path, path2, string));
    }

    @NotNull
    private Map copySubGitDirectory(c c2, c c3, String string) {
        Path path = c2.i().toPath();
        Path path2 = c3.i().toPath();
        Path path3 = c2.l().toPath();
        Path path4 = c2.g().toPath();
        Path path5 = c2.e().toPath();
        Path path6 = this.getMirrorService().getUserHiddenConfigFile(c2).toPath();
        Path path7 = this.getMirrorService().getActiveUserVisibleConfigFile(c2).toPath();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Files.walkFileTree(path, new SgMoveMetadataTask$2(this, path, path2, string, path3, path4, path5, path6, path7, linkedHashMap));
        return linkedHashMap;
    }

    private boolean isChild(Path path, Path path2) {
        for (Path path3 = path2.getParent(); path3 != null && path3.getNameCount() > 1; path3 = path3.getParent()) {
            if (!path3.equals(path)) continue;
            return true;
        }
        return false;
    }

    private void rename(Path path, Path path2) {
        this.getLogger().info("Moving " + String.valueOf(path) + " => " + String.valueOf(path2));
        Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    protected void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        SgBootstrapSchedule sgBootstrapSchedule = this.getBootstrapSchedule();
        long l2 = sgBootstrapSchedule == null ? -1L : sgBootstrapSchedule.nextTime(sgSettingsSnapshot);
        this.getScheduler().schedule((SgMirrorScope)this.getScope(), "verify", l2, null);
        if (this.getState() == SgTaskState.SUCCESS) {
            this.deleteRepositoryMetadata();
            this.addMetadataSymlinks();
        }
    }

    private void deleteRepositoryMetadata() {
        Repository repository = this.getMirrorService().getRepositoryService().getById(((SgMirrorScope)this.getScope()).getRepositoryId());
        File file = this.getMirrorService().getRepositoryDirectoryOrNull(repository);
        if (file == null) {
            return;
        }
        O o2 = new O();
        c c2 = c.b(file);
        this.getLogger().info("Deleting " + String.valueOf(c2.i()));
        this.deleteRecursively(c2.i().toPath());
        this.getLogger().info("Deleting " + String.valueOf(c2.w()));
        this.deleteRecursively(c2.w().toPath());
        try {
            Y y2 = o2.a(Z.a(file));
            this.getLogger().info("Deleting " + String.valueOf(y2.b()));
            this.deleteRecursively(y2.b().toPath());
        }
        catch (l l2) {
            this.getLogger().error("Failed to create repository key for path " + String.valueOf(file), (Throwable)l2);
        }
    }

    private void addMetadataSymlinks() {
        Repository repository = this.getMirrorService().getRepositoryService().getById(((SgMirrorScope)this.getScope()).getRepositoryId());
        File file = this.getMirrorService().getRepositoryDirectoryOrNull(repository);
        if (file == null) {
            return;
        }
        File file2 = this.getMirrorService().getMetadataDirectory(repository);
        O o2 = new O();
        c c2 = c.b(file);
        c c3 = c.b(file2);
        this.link(c2.i().toPath(), c3.i().toPath());
        this.link(c2.w().toPath(), c3.w().toPath());
        try {
            Y y2 = o2.a(Z.a(file));
            Y y3 = o2.a(Z.a(file2));
            this.link(y2.b().toPath(), y3.b().toPath());
        }
        catch (l l2) {
            this.getLogger().error("Failed to create repository key for path " + String.valueOf(file), (Throwable)l2);
        }
    }

    private void link(Path path, Path path2) {
        Path path3;
        this.getLogger().info("Linking " + String.valueOf(path) + " to " + String.valueOf(path2));
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            this.getLogger().error("Unable to link " + String.valueOf(path) + " to " + String.valueOf(path2) + ": file already exists");
            return;
        }
        try {
            path3 = path.getParent().relativize(path2);
        }
        catch (Throwable throwable) {
            path3 = path2.toAbsolutePath();
        }
        try {
            Files.createSymbolicLink(path, path3, new FileAttribute[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.getLogger().info("Symbolic links are not supported: " + unsupportedOperationException.getMessage());
        }
        catch (IOException iOException) {
            this.getLogger().error("Failed to create a symbolic link", (Throwable)iOException);
        }
    }

    private void deleteRecursively(Path path) {
        try {
            Files.walkFileTree(path, new SgMoveMetadataTask$3(this));
        }
        catch (IOException iOException) {
            this.getLogger().error("Failed to delete directory " + String.valueOf(path), (Throwable)iOException);
        }
    }
}

