/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import ch.qos.logback.classic.ClassicConstants;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import java.io.Serializable;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskFactoryService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.settings.SgSetting;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgApplyTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgBootstrapTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgConfigureTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgHandleUnsyncedRefTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMoveMetadataTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRebuildTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRefreshTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryApplyTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryMovedTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgStartTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgStopTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgSyncTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgUninstallTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgUninstallTaskParameters;
import org.tmatesoft.subgit.stash.mirror.tasks.SgUpgradeTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgVerifyTask;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.mirror.util.SgPerformanceOption;

public class SgMirrorTaskFactory
implements SgTaskFactoryService {
    public static final String BOOTSTRAP_EXECUTOR_NAME = "bootstrap";
    public static final String INTERACTIVE_EXECUTOR_NAME = "interactive";
    public static final String REST_EXECUTOR_NAME = "rest";
    private static final Logger log = LoggerFactory.getLogger(SgMirrorTaskFactory.class);
    private final SecurityService securityService;
    private final SgLoggerFactory loggerFactory;
    private final SgMirrorService mirrorService;

    public SgMirrorTaskFactory(SecurityService securityService, SgLoggerFactory sgLoggerFactory, SgMirrorService sgMirrorService) {
        this.securityService = securityService;
        this.loggerFactory = sgLoggerFactory;
        this.mirrorService = sgMirrorService;
    }

    @Override
    public String getBootstrapTaskName() {
        return BOOTSTRAP_EXECUTOR_NAME;
    }

    public String toString(SgMirrorScope sgMirrorScope, SgSettingsSnapshot sgSettingsSnapshot) {
        SgMirrorStage sgMirrorStage;
        if (sgMirrorScope.isGlobal()) {
            return "GLOBAL";
        }
        if (sgMirrorScope.isProject()) {
            return "PROJECT";
        }
        if (sgSettingsSnapshot != null && (sgMirrorStage = (SgMirrorStage)((Object)sgSettingsSnapshot.get(SgMirrorOption.STAGE, new SgSettingsType[0]))) != null) {
            return sgMirrorStage.name();
        }
        return "NONE";
    }

    @Override
    public void preRun(SgTask sgTask) {
        log.info("setting logger on task {} scope: {})", (Object)sgTask.getName(), (Object)sgTask.getScope());
        try {
            this.createSecurityContext((SgMirrorScope)sgTask.getScope()).call(() -> {
                log.info("setting logger on task {} within security context", (Object)sgTask.getName());
                Logger logger = this.loggerFactory.getLogger(sgTask);
                log.info("logger: {}", (Object)logger);
                sgTask.setLogger(logger);
                return null;
            });
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
        }
    }

    @Override
    public void postRun(SgTask sgTask) {
        Logger logger = sgTask.getLogger();
        if (logger != null && ((SgMirrorScope)sgTask.getScope()).isRepository()) {
            logger.debug(ClassicConstants.FINALIZE_SESSION_MARKER, "===");
        }
    }

    public String getExecutorName(SgMirrorScope sgMirrorScope, String string) {
        if (this.getBootstrapTaskName().equals(string)) {
            return BOOTSTRAP_EXECUTOR_NAME;
        }
        if (this.isBackgroundTask(string)) {
            return "core";
        }
        if (this.isRestTask(string)) {
            return REST_EXECUTOR_NAME;
        }
        return INTERACTIVE_EXECUTOR_NAME;
    }

    private boolean isRestTask(String string) {
        return string != null && string.endsWith("-rest");
    }

    private boolean isBackgroundTask(String string) {
        return "sync".equals(string) || "sync-rest".equals(string) || "upgrade".equals(string) || "upgrade-rest".equals(string) || "move-metadata".equals(string) || "move-metadata-rest".equals(string) || "verify".equals(string) || "verify-rest".equals(string);
    }

    public boolean keepIdleSnapshot(SgMirrorScope sgMirrorScope, SgSettingsSnapshot sgSettingsSnapshot) {
        if (sgSettingsSnapshot == null || sgMirrorScope == null || sgMirrorScope.isProject()) {
            return false;
        }
        if (sgMirrorScope.isGlobal()) {
            return true;
        }
        SgMirrorStage sgMirrorStage = (SgMirrorStage)((Object)sgSettingsSnapshot.get(SgMirrorOption.STAGE, new SgSettingsType[0]));
        if (this.mirrorService.createSettings(SgMirrorScope.global()).get(SgMirrorOption.MIRROR_TRACKING_MODE, new SgSettingsType[0]) == SgPerformanceOption.TRACK_ACTIVE) {
            return sgMirrorStage == SgMirrorStage.INSTALLED;
        }
        return sgMirrorStage == SgMirrorStage.CONFIGURED || sgMirrorStage == SgMirrorStage.PAUSED || sgMirrorStage == SgMirrorStage.LEGACY || sgMirrorStage == SgMirrorStage.UNKNOWN || sgMirrorStage == SgMirrorStage.PENDING_METADATA_MOVE || sgMirrorStage == SgMirrorStage.EXTERNAL_LOCAL || sgMirrorStage == SgMirrorStage.EXTERNAL_REMOTE;
    }

    public SgTask createTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable) {
        SgMirrorTask sgMirrorTask;
        String string2;
        EscalatedSecurityContext escalatedSecurityContext = this.createSecurityContext(sgMirrorScope);
        String string3 = string2 = string.endsWith("-rest") ? string.substring(0, string.length() - "-rest".length()) : string;
        if ("configure".equals(string2)) {
            sgMirrorTask = new SgConfigureTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext);
        } else if ("reset".equals(string2) || "uninstall".equals(string2) || "uninstall-import".equals(string2)) {
            serializable = "reset".equals(string2) ? new SgUninstallTaskParameters(false, false) : new SgUninstallTaskParameters(true, false);
            sgMirrorTask = new SgUninstallTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext);
        } else {
            sgMirrorTask = "apply".equals(string2) ? (sgMirrorScope.isRepository() ? new SgRepositoryApplyTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : new SgApplyTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext)) : ("sync".equals(string2) ? new SgSyncTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : ("verify".equals(string2) ? new SgVerifyTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : ("rebuild".equals(string2) ? new SgRebuildTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : ("push".equals(string2) ? new SgPushTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : ("stop".equals(string2) || "stop-import".equals(string2) ? new SgStopTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : ("start".equals(string2) ? new SgStartTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, false, this.mirrorService, escalatedSecurityContext) : ("start-import".equals(string2) ? new SgStartTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, true, this.mirrorService, escalatedSecurityContext) : ("refresh".equals(string2) ? new SgRefreshTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : ("upgrade".equals(string2) ? new SgUpgradeTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : ("move-metadata".equals(string2) ? new SgMoveMetadataTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : ("unsynced-remove".equals(string2) || "unsynced-restore".equals(string2) ? new SgHandleUnsyncedRefTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : (BOOTSTRAP_EXECUTOR_NAME.equals(string2) ? new SgBootstrapTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : ("repositoryMoved".equals(string2) ? new SgRepositoryMovedTask(sgTaskScheduler, string, sgMirrorScope, l2, serializable, this.mirrorService, escalatedSecurityContext) : null)))))))))))));
        }
        return sgMirrorTask;
    }

    public boolean publishParentOnChildChanges(SgMirrorScope sgMirrorScope, SgSettingsSnapshot sgSettingsSnapshot) {
        if (sgSettingsSnapshot == null || sgMirrorScope.isGlobal() || sgMirrorScope.isProject()) {
            return false;
        }
        SgMirrorStage sgMirrorStage = (SgMirrorStage)((Object)sgSettingsSnapshot.get(SgMirrorOption.STAGE, new SgSettingsType[0]));
        SgPerformanceOption sgPerformanceOption = (SgPerformanceOption)((Object)this.mirrorService.createSettings(SgMirrorScope.global()).get(SgMirrorOption.MIRROR_TRACKING_MODE, new SgSettingsType[0]));
        boolean bl2 = sgPerformanceOption == SgPerformanceOption.TRACK_ACTIVE ? sgMirrorStage == SgMirrorStage.INSTALLED : sgMirrorStage == SgMirrorStage.INSTALLED || sgMirrorStage == SgMirrorStage.PAUSED || sgMirrorStage == SgMirrorStage.CONFIGURED || sgMirrorStage == SgMirrorStage.PENDING_METADATA_MOVE || sgMirrorStage == SgMirrorStage.LEGACY || sgMirrorStage == SgMirrorStage.UNKNOWN || sgMirrorStage == SgMirrorStage.EXTERNAL_LOCAL || sgMirrorStage == SgMirrorStage.EXTERNAL_REMOTE;
        return bl2;
    }

    public boolean hasChildren(SgMirrorScope sgMirrorScope, SgSettingsSnapshot sgSettingsSnapshot) {
        if (sgSettingsSnapshot == null || sgMirrorScope == null || sgMirrorScope.isRepository()) {
            return false;
        }
        return sgSettingsSnapshot.get(SgMirrorOption.STAGE, new SgSettingsType[0]) != SgMirrorStage.NO_LICENSE;
    }

    public SgSettingsSnapshot getChildView(SgMirrorScope sgMirrorScope, SgSettingsSnapshot sgSettingsSnapshot) {
        boolean bl2;
        if (sgSettingsSnapshot == null || sgMirrorScope.isProject() || sgMirrorScope.isGlobal()) {
            return null;
        }
        SgMirrorStage sgMirrorStage = (SgMirrorStage)((Object)sgSettingsSnapshot.get(SgMirrorOption.STAGE, new SgSettingsType[0]));
        SgPerformanceOption sgPerformanceOption = (SgPerformanceOption)((Object)this.mirrorService.createSettings(SgMirrorScope.global()).get(SgMirrorOption.MIRROR_TRACKING_MODE, new SgSettingsType[0]));
        if (sgPerformanceOption == SgPerformanceOption.TRACK_ACTIVE) {
            bl2 = sgMirrorStage == SgMirrorStage.INSTALLED;
        } else {
            boolean bl3 = bl2 = sgMirrorStage == SgMirrorStage.INSTALLED || sgMirrorStage == SgMirrorStage.PAUSED || sgMirrorStage == SgMirrorStage.CONFIGURED || sgMirrorStage == SgMirrorStage.LEGACY || sgMirrorStage == SgMirrorStage.PENDING_METADATA_MOVE || sgMirrorStage == SgMirrorStage.UNKNOWN || sgMirrorStage == SgMirrorStage.EXTERNAL_LOCAL || sgMirrorStage == SgMirrorStage.EXTERNAL_REMOTE;
        }
        if (bl2) {
            HashSet<SgSetting> hashSet = new HashSet<SgSetting>(SgMirrorOption.synthetic());
            hashSet.remove(SgMirrorOption.UNSYNCED_REFS);
            hashSet.add(SgMirrorOption.SVN_URL);
            hashSet.add(SgMirrorOption.IMPORT);
            hashSet.add(SgMirrorOption.VERIFY_INFO);
            return sgSettingsSnapshot.snapshot(hashSet);
        }
        return null;
    }

    public SgSettingsSnapshot loadData(SgMirrorScope sgMirrorScope) {
        return (SgSettingsSnapshot)this.createSecurityContext(sgMirrorScope).call(() -> this.mirrorService.loadState(sgMirrorScope));
    }

    private EscalatedSecurityContext createSecurityContext(SgMirrorScope sgMirrorScope) {
        if (sgMirrorScope.isGlobal()) {
            return this.securityService.withPermission(Permission.ADMIN, "svnmirror admin context");
        }
        if (sgMirrorScope.isProject()) {
            return this.securityService.withPermission(Permission.PROJECT_ADMIN, "svnmirror project context");
        }
        return this.securityService.withPermission(Permission.REPO_ADMIN, "svnmirror repository context");
    }
}

