/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.util.Operation;
import java.io.Serializable;
import java.util.Collections;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgMapSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsEditor;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgSingleSettingParameter;
import org.tmatesoft.subgit.stash.mirror.tasks.SgTsLogger;
import org.tmatesoft.subgit.stash.mirror.util.SgSchedulerOptions;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;
import org.tmatesoft.subgit.stash.web.SgPluginManager;
import org.tmatesoft.translator.h.d;

public abstract class SgMirrorTask
extends SgTask {
    private final EscalatedSecurityContext securityContext;
    private SgSettingsEditor settingsEditor;
    private SgSettingsSnapshot userSettings;

    SgMirrorTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable);
        this.securityContext = escalatedSecurityContext;
    }

    @Override
    protected String formatErrorMessage(String string) {
        return SgTextUtil.formatErrorMessage(string);
    }

    protected SgSettingsSnapshot getUserSettings() {
        return this.userSettings;
    }

    protected SgSettingsEditor getSettingsEditor() {
        return this.settingsEditor;
    }

    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        this.settingsEditor = sgSettingsSnapshot.editor();
        if (this.getParameters() instanceof SgSettingsSnapshot) {
            SgSettingsSnapshot sgSettingsSnapshot2 = (SgSettingsSnapshot)this.getParameters();
            this.userSettings = sgSettingsSnapshot2.setDefaults(sgSettingsSnapshot);
        } else if (this.getParameters() instanceof SgSingleSettingParameter) {
            SgSingleSettingParameter sgSingleSettingParameter = (SgSingleSettingParameter)this.getParameters();
            SgMapSettings sgMapSettings = new SgMapSettings(SgMirrorOption.USER, null);
            sgMapSettings.set(sgSingleSettingParameter.getSetting(), sgSingleSettingParameter.getValue());
            this.userSettings = sgMapSettings.snapshot(Collections.singleton(sgSingleSettingParameter.getSetting())).setDefaults(sgSettingsSnapshot);
        } else {
            this.userSettings = sgSettingsSnapshot;
        }
    }

    protected void configureThreadPools(SgSettingsSnapshot sgSettingsSnapshot) {
        SgSchedulerOptions sgSchedulerOptions = (SgSchedulerOptions)sgSettingsSnapshot.get(SgMirrorOption.SCHEDULER_OPTIONS, new SgSettingsType[0]);
        int n2 = SgTextUtil.getMaxCoreRunnersCount();
        int n3 = sgSchedulerOptions.getMaxRunnersCount() > 0 ? sgSchedulerOptions.getMaxRunnersCount() : Integer.MAX_VALUE;
        int n4 = Math.min(Math.max(1, n2), n3);
        this.getLogger().info("upper limit for core thread pool size: " + n2);
        this.getLogger().info("configured core thread pool size: " + n3);
        this.getLogger().info("effective core thread pool size: " + n4);
        this.getScheduler().setExecutorPoolSize("core", n4);
        this.getScheduler().setExecutorPoolSize("bootstrap", (Integer)sgSettingsSnapshot.get(SgMirrorOption.BOOTSTRAP_POOL_SIZE, new SgSettingsType[0]));
        this.getScheduler().setExecutorPoolSize("interactive", (Integer)sgSettingsSnapshot.get(SgMirrorOption.INTERACTIVE_POOL_SIZE, new SgSettingsType[0]));
        this.getScheduler().setExecutorPoolSize("rest", (Integer)sgSettingsSnapshot.get(SgMirrorOption.REST_POOL_SIZE, new SgSettingsType[0]));
    }

    protected void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
    }

    protected void rollbackSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
    }

    @Override
    public void setLogger(Logger logger) {
        super.setLogger(logger);
        d.setLogger(new SgTsLogger(this.getName(), this.getLogger()));
    }

    protected Object runSecurely(Operation operation) {
        return this.securityContext.call(operation);
    }

    public void run(SgSettingsSnapshot sgSettingsSnapshot) {
        SgPluginManager.initializeHashProvider();
        this.securityContext.call(() -> {
            try {
                this.runSecurely(sgSettingsSnapshot);
            }
            catch (Throwable throwable) {
                this.setNeedsRollback(true);
                throw throwable;
            }
            return null;
        });
    }

    public void rollback(SgSettingsSnapshot sgSettingsSnapshot) {
        if (this.getState() == SgTaskState.SHUTDOWN) {
            return;
        }
        this.securityContext.call(() -> {
            this.rollbackSecurely(sgSettingsSnapshot);
            return null;
        });
    }

    public void postRun(SgSettingsSnapshot sgSettingsSnapshot) {
        try {
            this.securityContext.call(() -> {
                this.postRunSecurely(sgSettingsSnapshot);
                return null;
            });
        }
        finally {
            d.disposeLogger();
        }
    }
}

