/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScope;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope$Builder;

public class SgMirrorScope
extends SgTaskScope {
    private static final long serialVersionUID = 1L;
    private static final SgMirrorScope GLOBAL_SCOPE = SgMirrorScope.builder().build();
    private static final String SEPARATOR = "_";
    private final int repositoryId;
    private final int projectId;
    private final String id;

    public static SgMirrorScope global() {
        return GLOBAL_SCOPE;
    }

    public static SgMirrorScope forProject(Project project) {
        return SgMirrorScope.builder().setProjectId(project.getId()).build();
    }

    public static SgMirrorScope forProjectId(int n2) {
        return SgMirrorScope.builder().setProjectId(n2).build();
    }

    public static SgMirrorScope forRepository(Repository repository) {
        int n2 = repository.getId();
        return SgMirrorScope.builder().setProjectId(repository.getProject().getId()).setRepositoryId(n2).build();
    }

    private SgMirrorScope(SgMirrorScope$Builder sgMirrorScope$Builder) {
        this.projectId = sgMirrorScope$Builder.projectId;
        this.repositoryId = sgMirrorScope$Builder.repositoryId;
        this.id = this.toString();
    }

    public String getId() {
        return this.id;
    }

    public boolean isGlobal() {
        return this.repositoryId <= 0 && this.projectId <= 0;
    }

    public boolean isProject() {
        return !this.isGlobal() && this.repositoryId <= 0;
    }

    public boolean isRepository() {
        return !this.isGlobal() && !this.isProject();
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public SgSettingsType getSettingsType() {
        if (this.isRepository()) {
            return SgMirrorOption.REPOSITORY;
        }
        if (this.isProject()) {
            return SgMirrorOption.PROJECT;
        }
        return SgMirrorOption.GLOBAL;
    }

    @Override
    public SgMirrorScope parent() {
        if (this.isGlobal()) {
            return null;
        }
        if (this.isProject()) {
            return SgMirrorScope.global();
        }
        if (this.isRepository()) {
            return SgMirrorScope.forProjectId(this.getProjectId());
        }
        return null;
    }

    @Override
    public boolean includes(SgTaskScope sgTaskScope) {
        if (sgTaskScope == null || sgTaskScope.getClass() != this.getClass()) {
            return false;
        }
        SgMirrorScope sgMirrorScope = (SgMirrorScope)sgTaskScope;
        if (this.isGlobal()) {
            return true;
        }
        if (this.isProject()) {
            return sgMirrorScope.projectId == this.projectId;
        }
        if (this.isRepository()) {
            return sgMirrorScope.projectId == this.projectId && sgMirrorScope.repositoryId == this.repositoryId;
        }
        return false;
    }

    public String toString() {
        if (this.isGlobal()) {
            return "G";
        }
        if (this.isProject()) {
            return "P_" + this.projectId;
        }
        return "R_" + this.projectId + SEPARATOR + this.repositoryId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SgMirrorScope sgMirrorScope = (SgMirrorScope)object;
        return this.repositoryId == sgMirrorScope.repositoryId && this.projectId == sgMirrorScope.projectId;
    }

    public int hashCode() {
        return 31 * this.repositoryId + this.projectId;
    }

    public static SgMirrorScope$Builder builder() {
        return new SgMirrorScope$Builder();
    }
}

