/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.a.a.a.b.k;
import com.a.a.a.d.N;
import com.a.a.a.d.U;
import com.atlassian.bitbucket.request.RequestCallback;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.SgUnsyncedRef;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTsConsole;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgHandleUnsyncedRefTask$1;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTaskParameters;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTaskParameters$Command;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRequestInfoProviderAdapter;
import org.tmatesoft.translator.e.i;
import org.tmatesoft.translator.h.d;

public class SgHandleUnsyncedRefTask
extends SgRepositoryTask {
    private final Set refDeltas = new HashSet();

    protected SgHandleUnsyncedRefTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, sgMirrorService, escalatedSecurityContext);
    }

    @Override
    public boolean shouldCancel(SgTask sgTask) {
        return false;
    }

    @Override
    protected EnumSet getApplicableStages() {
        return EnumSet.of(SgMirrorStage.INSTALLED, SgMirrorStage.PAUSED);
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.runSecurely(sgSettingsSnapshot);
        SgUnsyncedRef[] sgUnsyncedRefArray = (SgUnsyncedRef[])this.getUserSettings().get(SgMirrorOption.UNSYNCED_REFS_COMMANDS, new SgSettingsType[0]);
        if (sgUnsyncedRefArray == null || sgUnsyncedRefArray.length == 0) {
            return;
        }
        this.getMirrorService().getRequestManager().doAsRequest((RequestCallback)new SgHandleUnsyncedRefTask$1(this, sgUnsyncedRefArray, sgSettingsSnapshot), (RequestInfoProvider)new SgRequestInfoProviderAdapter("HandleUnsyncedRefs"));
        this.setMessage(null, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReachableFromAny(Repository repository, Set set, SgUnsyncedRef sgUnsyncedRef) {
        ObjectId objectId = ObjectId.fromString(sgUnsyncedRef.getCommitId());
        RevWalk revWalk = new RevWalk(repository);
        try {
            HashSet<RevCommit> hashSet = new HashSet<RevCommit>();
            for (Serializable serializable : set) {
                RevCommit revCommit = revWalk.lookupCommit(ObjectId.fromString(((SgUnsyncedRef)serializable).getCommitId()));
                if (revCommit == null) continue;
                hashSet.add(revCommit);
            }
            revWalk.markStart(hashSet);
            revWalk.setRetainBody(false);
            for (Serializable serializable : revWalk) {
                if (!((RevObject)serializable).getId().equals(objectId)) continue;
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (IOException iOException) {
            d.getLogger().info(iOException);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            revWalk.dispose();
        }
        return false;
    }

    @Override
    protected void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.postRunSecurely(sgSettingsSnapshot);
        if (!this.refDeltas.isEmpty()) {
            for (i i2 : this.refDeltas) {
                d.getLogger().info("will send ref delta: " + String.valueOf(i2));
            }
        }
        if (this.getStage() == SgMirrorStage.INSTALLED && !this.refDeltas.isEmpty()) {
            SgPushTaskParameters sgPushTaskParameters = SgPushTaskParameters.builder().setRefDeltas(this.refDeltas).setConsole(new SgTsConsole(this.getMirrorService().getDummyConsole())).addCommandFor(SgMirrorStage.INSTALLED, SgPushTaskParameters$Command.SYNC_WITH_DELTAS).addCommandFor(SgMirrorStage.INSTALLED, SgPushTaskParameters$Command.SYNC).build();
            this.getScheduler().schedule((SgMirrorScope)this.getScope(), "push", -1L, sgPushTaskParameters);
        } else if (this.getStage() == SgMirrorStage.PAUSED && !this.refDeltas.isEmpty()) {
            this.getMirrorService().forceRepositoryRefresh(this.getRepository(), this.refDeltas);
        }
    }

    private i createRenameRefDelta(SgUnsyncedRef sgUnsyncedRef) {
        try {
            N n2 = N.b(sgUnsyncedRef.getCommitId());
            U u2 = U.b(sgUnsyncedRef.getTargetRef());
            if (n2 != null) {
                return new i(u2, N.a(), n2);
            }
        }
        catch (k k2) {
            d.getLogger().info(k2);
        }
        return null;
    }

    private void removeReference(Repository repository, String string) {
        try {
            if (repository.findRef(string) == null) {
                throw new SgException("'" + string + "' does not exist");
            }
            RefUpdate refUpdate = repository.updateRef(string);
            if (refUpdate != null) {
                refUpdate.setForceUpdate(true);
                RefUpdate$Result refUpdate$Result = refUpdate.delete();
                if (refUpdate$Result != RefUpdate$Result.FORCED && refUpdate$Result != RefUpdate$Result.FAST_FORWARD) {
                    throw new SgException("Failed to delete reference: " + String.valueOf((Object)refUpdate$Result));
                }
                d.getLogger().info("reference '" + string + "' deleted, result: " + String.valueOf((Object)refUpdate$Result));
            }
        }
        catch (IOException iOException) {
            d.getLogger().info("failed to delete reference '" + string + "'");
            d.getLogger().info(iOException);
            throw iOException;
        }
    }

    static /* synthetic */ void access$000(SgHandleUnsyncedRefTask sgHandleUnsyncedRefTask, String string, int n2, Object[] objectArray) {
        sgHandleUnsyncedRefTask.setProgressMessage(string, n2, objectArray);
    }

    static /* synthetic */ void access$100(SgHandleUnsyncedRefTask sgHandleUnsyncedRefTask, String string, int n2, Object[] objectArray) {
        sgHandleUnsyncedRefTask.setProgressMessage(string, n2, objectArray);
    }
}

