/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.atlassian.bitbucket.request.RequestCallback;
import com.atlassian.bitbucket.request.RequestContext;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.SgUnsyncedRef;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgHandleUnsyncedRefTask;
import org.tmatesoft.translator.e.i;
import org.tmatesoft.translator.h.d;

class SgHandleUnsyncedRefTask$1
implements RequestCallback {
    final /* synthetic */ SgUnsyncedRef[] val$refs;
    final /* synthetic */ SgSettingsSnapshot val$data;
    final /* synthetic */ SgHandleUnsyncedRefTask this$0;

    SgHandleUnsyncedRefTask$1(SgHandleUnsyncedRefTask sgHandleUnsyncedRefTask, SgUnsyncedRef[] sgUnsyncedRefArray, SgSettingsSnapshot sgSettingsSnapshot) {
        this.this$0 = sgHandleUnsyncedRefTask;
        this.val$refs = sgUnsyncedRefArray;
        this.val$data = sgSettingsSnapshot;
    }

    @Nullable
    public Void withRequest(@Nonnull RequestContext requestContext) {
        try (Repository repository = this.this$0.getMirrorService().createGitRepository(this.this$0.getRepository());){
            HashSet<SgUnsyncedRef> hashSet = new HashSet<SgUnsyncedRef>();
            for (SgUnsyncedRef sgUnsyncedRef : this.val$refs) {
                if ("unsynced-remove".equals(this.this$0.getName())) {
                    this.this$0.removeReference(repository, sgUnsyncedRef.getRef());
                    continue;
                }
                if (!"unsynced-restore".equals(this.this$0.getName())) continue;
                if (repository.findRef(sgUnsyncedRef.getTargetRef()) != null) {
                    throw new SgException("Reference '" + sgUnsyncedRef.getTargetRef() + "' already exists");
                }
                if (hashSet.contains(sgUnsyncedRef)) continue;
                hashSet.add(sgUnsyncedRef);
                d.getLogger().info("ref '" + sgUnsyncedRef.getRef() + "' explicitly included into restore set.");
            }
            if (!hashSet.isEmpty()) {
                int n2;
                SgHandleUnsyncedRefTask.access$000(this.this$0, "Collecting references to restore...", 100, new Object[0]);
                SgUnsyncedRef[] sgUnsyncedRefArray = (SgUnsyncedRef[])this.val$data.get(SgMirrorOption.UNSYNCED_REFS, new SgSettingsType[0]);
                do {
                    n2 = 0;
                    for (SgUnsyncedRef object : sgUnsyncedRefArray) {
                        if (hashSet.contains(object) || object.targetExists() || repository.findRef(object.getTargetRef()) != null || !this.this$0.isReachableFromAny(repository, hashSet, object)) continue;
                        hashSet.add(object);
                        d.getLogger().info("ref '" + object.getRef() + "' implicitly included into restore set.");
                        n2 = 1;
                    }
                    if (n2 != 0) continue;
                    d.getLogger().info("no more referenced to consider");
                } while (n2 != 0);
                SgHandleUnsyncedRefTask.access$100(this.this$0, "Restoring references...", 100, new Object[0]);
                for (SgUnsyncedRef sgUnsyncedRef : hashSet) {
                    i i2;
                    if (this.this$0.getStage() == SgMirrorStage.PAUSED) {
                        ObjectId objectId = repository.resolve(sgUnsyncedRef.getRef());
                        RefUpdate refUpdate = repository.updateRef(sgUnsyncedRef.getTargetRef(), true);
                        refUpdate.setNewObjectId(objectId);
                        RefUpdate$Result refUpdate$Result = refUpdate.forceUpdate();
                        if (refUpdate$Result == RefUpdate$Result.FORCED || refUpdate$Result == RefUpdate$Result.FAST_FORWARD || refUpdate$Result == RefUpdate$Result.NO_CHANGE || refUpdate$Result == RefUpdate$Result.NEW) {
                            RefUpdate refUpdate2 = repository.updateRef(sgUnsyncedRef.getRef(), true);
                            refUpdate2.setExpectedOldObjectId(objectId);
                            refUpdate2.delete();
                        }
                    }
                    if ((i2 = this.this$0.createRenameRefDelta(sgUnsyncedRef)) == null) continue;
                    this.this$0.refDeltas.add(i2);
                }
            }
        }
        catch (Throwable throwable) {
            throw com.a.a.a.b.i.a(throwable);
        }
        return null;
    }
}

