/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.a.a.a.c.C;
import com.atlassian.bitbucket.request.RequestCallback;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashSet;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgConfigureTask$1;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorStartType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryTask;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRequestInfoProviderAdapter;
import org.tmatesoft.subgit.stash.mirror.util.SgLayoutType;
import org.tmatesoft.subgit.stash.web.SgLicenseManager;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.translator.b.n;
import org.tmatesoft.translator.d.b;
import org.tmatesoft.translator.d.e;
import org.tmatesoft.translator.d.g;
import org.tmatesoft.translator.d.l;
import org.tmatesoft.translator.m.m;
import org.tmatesoft.translator.util.a;

public class SgConfigureTask
extends SgRepositoryTask
implements b {
    private long lastPercentage = 0L;
    private String lastMessage = null;

    public SgConfigureTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, sgMirrorService, escalatedSecurityContext);
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.runSecurely(sgSettingsSnapshot);
        this.getMirrorService().getRequestManager().doAsRequest((RequestCallback)new SgConfigureTask$1(this), (RequestInfoProvider)new SgRequestInfoProviderAdapter("Configure"));
        this.setMessage(null, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendUserAuthors(File file, String string) {
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file, true);
            outputStream.write("\n".getBytes(StandardCharsets.UTF_8));
            outputStream.write(string.getBytes(StandardCharsets.UTF_8));
        }
        finally {
            if (outputStream != null) {
                SVNFileUtil.closeFile(outputStream);
            }
        }
    }

    private void applyUserConfiguration(SgSettingsSnapshot sgSettingsSnapshot, org.tmatesoft.translator.b.g g2) {
        this.getLogger().info("Applying user branches mapping to visible configuration file");
        if (sgSettingsSnapshot.get(SgMirrorOption.LAYOUT_TYPE, new SgSettingsType[0]) != SgLayoutType.MANUAL) {
            this.applyExtraConfigOptions(g2, (String)sgSettingsSnapshot.get(SgMirrorOption.CONFIG, new SgSettingsType[0]));
            return;
        }
        String string = (String)sgSettingsSnapshot.get(SgMirrorOption.TRUNK_BINDING, new SgSettingsType[0]);
        if (string != null) {
            g2.g(n.E);
            g2.b(n.E, string);
        }
        String[] stringArray = (String[])sgSettingsSnapshot.get(SgMirrorOption.SHELVES_BINDINGS, new SgSettingsType[0]);
        String[] stringArray2 = (String[])sgSettingsSnapshot.get(SgMirrorOption.BRANCHES_BINDINGS, new SgSettingsType[0]);
        String[] stringArray3 = (String[])sgSettingsSnapshot.get(SgMirrorOption.TAGS_BINDINGS, new SgSettingsType[0]);
        String[] stringArray4 = (String[])sgSettingsSnapshot.get(SgMirrorOption.EXCLUDE_PATHS, new SgSettingsType[0]);
        String[] stringArray5 = (String[])sgSettingsSnapshot.get(SgMirrorOption.EXCLUDE_BRANCHES, new SgSettingsType[0]);
        String[] stringArray6 = (String[])sgSettingsSnapshot.get(SgMirrorOption.INCLUDE_PATHS, new SgSettingsType[0]);
        if (stringArray2 != null) {
            g2.g(n.F);
            for (String string2 : stringArray2) {
                g2.c(n.F, string2);
            }
        }
        if (stringArray3 != null) {
            g2.g(n.G);
            for (String string2 : stringArray3) {
                g2.c(n.G, string2);
            }
        }
        if (stringArray != null) {
            g2.g(n.H);
            for (String string2 : stringArray) {
                g2.c(n.H, string2);
            }
        }
        if (stringArray5 != null) {
            g2.g(n.J);
            for (String string2 : stringArray5) {
                g2.c(n.J, string2);
            }
        }
        if (stringArray4 != null) {
            g2.g(n.N);
            for (String string2 : stringArray4) {
                g2.c(n.N, string2);
            }
        }
        if (stringArray6 != null) {
            g2.g(n.M);
            for (String string2 : stringArray6) {
                g2.c(n.M, string2);
            }
        }
        this.applyExtraConfigOptions(g2, (String)sgSettingsSnapshot.get(SgMirrorOption.CONFIG, new SgSettingsType[0]));
    }

    private void applyExtraConfigOptions(org.tmatesoft.translator.b.g g2, String string) {
        if (string == null) {
            return;
        }
        Config config = new Config();
        try {
            config.fromText(string);
        }
        catch (ConfigInvalidException configInvalidException) {
            this.getLogger().error("failed to parse configuration: " + configInvalidException.getMessage(), (Throwable)configInvalidException);
            return;
        }
        for (String string2 : config.getSections()) {
            HashSet hashSet = new HashSet(config.getSubsections(string2));
            hashSet.add(null);
            for (String string3 : hashSet) {
                for (String string4 : config.getNames(string2, string3)) {
                    String[] stringArray = config.getStringList(string2, string3, string4);
                    if (stringArray == null) continue;
                    for (String string5 : stringArray) {
                        this.getLogger().info("applying extra configuration option: " + string2 + "." + (String)(string3 != null ? string3 + "." + string4 : string4) + " = " + string5);
                        g2.c(n.b(string2, string3, string4), string5);
                    }
                }
            }
        }
    }

    @Override
    protected void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        String string;
        super.postRunSecurely(sgSettingsSnapshot);
        SgMirrorStartType sgMirrorStartType = (SgMirrorStartType)((Object)this.getUserSettings().get(SgMirrorOption.START_MODE, new SgSettingsType[0]));
        String string2 = string = this.getName().endsWith("-rest") ? "-rest" : "";
        if (sgMirrorStartType == SgMirrorStartType.MIRROR) {
            this.schedule("start" + string);
        } else if (sgMirrorStartType == SgMirrorStartType.IMPORT) {
            this.schedule("start-import" + string);
        }
    }

    private void ensureRepositorySizeIsOk(SgSettings sgSettings) {
        SgLicenseManager sgLicenseManager = this.getMirrorService().getLicenseManager();
        if ((!sgLicenseManager.hasLicense() || sgLicenseManager.isEvaluation()) && sgLicenseManager.isCheckRepositorySize()) {
            this.setProgressMessage("Estimating project size...", 100, new Object[0]);
            long l2 = this.getMirrorService().getSubversionService().computeRevisionsCount(sgSettings, this.createSVNCanceller());
            if (l2 > sgLicenseManager.getEvaluationRepositoryRevisionsLimit()) {
                throw new SgException("EVALUATION_REVISION_COUNT_EXCEEDED?revisionCount=" + l2);
            }
        }
    }

    private void generateLegacyAuthorsMapping(SVNRepository sVNRepository, String string, String string2, File file) {
        sVNRepository.setCanceller(this.createSVNCanceller());
        this.getMirrorService().getAuthorsService().generateAuthorsMapping(sVNRepository, string, string2, file);
    }

    private ISVNCanceller createSVNCanceller() {
        return () -> {
            try {
                this.checkCancelled();
            }
            catch (a a2) {
                throw new SVNCancelException();
            }
        };
    }

    @Override
    public void rollbackSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        m m2 = this.getRepositoryArea();
        File file = m2.i();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.equals(m2.l())) continue;
                C.b(file2);
            }
        }
    }

    @Override
    protected EnumSet getApplicableStages() {
        return EnumSet.of(SgMirrorStage.INITIAL);
    }

    private void reportProgress(String string) {
        this.reportProgress(string, 0);
    }

    private void reportProgress(String string, int n2) {
        if (this.lastMessage != null && this.lastMessage.equals(string) && this.lastPercentage == (long)n2) {
            return;
        }
        this.lastPercentage = n2;
        this.lastMessage = string;
        this.setProgressMessage(string, n2, new Object[0]);
    }

    private void reportDone() {
        this.reportProgress("", 100);
    }

    private int computePercentage(long l2, long l3) {
        if (l2 >= l3) {
            return 100;
        }
        return (int)((double)l2 / (double)l3 * 100.0);
    }

    @Override
    public void historyFetchStarted(g g2) {
        this.reportProgress("Fetching SVN history...");
    }

    @Override
    public void historyEntryFetched(g g2, long l2, long l3, long l4) {
        this.reportProgress("Fetching SVN history...", this.computePercentage(l3, l4));
    }

    @Override
    public void historyFetchCompleted(g g2) {
        this.reportDone();
    }

    @Override
    public void historyArrangementStarted(g g2) {
        this.reportProgress("Growing trees...");
    }

    @Override
    public void historyEntryArranged(g g2, long l2, long l3) {
        this.reportProgress("Growing trees...", this.computePercentage(l2, l3));
    }

    @Override
    public void historyArrangementCompleted(g g2) {
        this.reportDone();
    }

    @Override
    public void pathsDiscoveryStarted() {
        this.reportProgress("Combing beards...");
    }

    @Override
    public void pathsDiscovered(long l2, long l3) {
        this.reportProgress("Combing beards...", this.computePercentage(l2, l3));
    }

    @Override
    public void pathsDiscoveryCompleted() {
        this.reportDone();
    }

    @Override
    public void pegLookupStarted() {
        this.reportProgress("Detecting peg location...", 100);
    }

    @Override
    public void pegLookupCompleted(e e2) {
        this.reportDone();
    }

    @Override
    public void originLookupStarted() {
        this.reportProgress("Detecting project origin...", 100);
    }

    @Override
    public void originLookupCompleted(e e2) {
        this.reportDone();
    }

    @Override
    public void layoutBuildingStarted(l l2) {
        this.reportProgress("Building branches layouts...");
    }

    @Override
    public void layoutBuilt(l l2, long l3, long l4) {
        this.reportProgress("Building branches layouts...", this.computePercentage(l3, l4));
    }

    @Override
    public void layoutBuildingCompleted(l l2) {
        this.reportDone();
    }

    @Override
    public void configurationLayoutGenerationStarted() {
        this.reportProgress("Generating SVN to Git mapping...", 100);
    }

    @Override
    public void configurationLayoutGenerationCompleted() {
        this.reportDone();
    }

    static /* synthetic */ void access$000(SgConfigureTask sgConfigureTask, String string, int n2, Object[] objectArray) {
        sgConfigureTask.setProgressMessage(string, n2, objectArray);
    }

    static /* synthetic */ void access$100(SgConfigureTask sgConfigureTask, String string, int n2, Object[] objectArray) {
        sgConfigureTask.setProgressMessage(string, n2, objectArray);
    }
}

