/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsEditor;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgBootstrapSchedule;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorTask;
import org.tmatesoft.subgit.stash.mirror.util.SgFileUtil;
import org.tmatesoft.subgit.stash.mirror.util.SgPerformanceOption;
import org.tmatesoft.subgit.stash.mirror.util.SgRepositoryFilter;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;
import org.tmatesoft.translator.b.e;
import org.tmatesoft.translator.util.u;

public class SgBootstrapTask
extends SgMirrorTask {
    private final SgMirrorService mirrorService;
    private final SgBootstrapSchedule schedule;
    private SgMirrorStage stage;

    public SgBootstrapTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, escalatedSecurityContext);
        this.mirrorService = sgMirrorService;
        this.schedule = this.getParameters() instanceof SgBootstrapSchedule ? (SgBootstrapSchedule)super.getParameters() : null;
    }

    @Override
    public boolean shouldCancel(SgTask sgTask) {
        return this.schedule != null && (sgTask.getState() == SgTaskState.PENDING || !sgTask.isStarted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.runSecurely(sgSettingsSnapshot);
        boolean bl2 = this.getParameters() == SgTaskScheduler.REFRESH_BOOTSTRAP;
        this.stage = (SgMirrorStage)((Object)sgSettingsSnapshot.get(SgMirrorOption.STAGE, new SgSettingsType[0]));
        if (((SgMirrorScope)this.getScope()).isGlobal() && !bl2) {
            this.mirrorService.setLogLevel((String)sgSettingsSnapshot.get(SgMirrorOption.LOG_LEVEL, new SgSettingsType[0]));
            if (this.stage != SgMirrorStage.NO_LICENSE) {
                this.initDefaultSettings((SgMirrorScope)this.getScope(), sgSettingsSnapshot);
                SgPerformanceOption sgPerformanceOption = (SgPerformanceOption)((Object)this.mirrorService.createSettings(SgMirrorScope.global()).get(SgMirrorOption.MIRROR_TRACKING_MODE, new SgSettingsType[0]));
                try {
                    this.getScheduler().setUpdateParentScopes(false);
                    this.bootstrapRepositories((SgMirrorScope)this.getScope(), sgPerformanceOption);
                }
                finally {
                    this.getScheduler().setUpdateParentScopes(true);
                }
            }
        }
    }

    private void initDefaultSettings(SgMirrorScope sgMirrorScope, SgSettingsSnapshot sgSettingsSnapshot) {
        SgSettingsEditor sgSettingsEditor = sgSettingsSnapshot.editor();
        if (sgMirrorScope.isGlobal()) {
            this.configureThreadPools(sgSettingsSnapshot);
            if (sgSettingsSnapshot.get(SgMirrorOption.CORE_DEFAULT_DOMAIN, sgMirrorScope.getSettingsType()) == null) {
                sgSettingsEditor.set(SgMirrorOption.CORE_DEFAULT_DOMAIN, this.mirrorService.getAuthorsService().findDefaultDomain());
            }
            File file = this.mirrorService.getAuthorsService().getLegacyGlobalAuthorsFile();
            File file2 = this.mirrorService.getAuthorsService().getGlobalAuthorsFile();
            File file3 = new File(this.mirrorService.getStorageService().getHomeDir().toFile(), "subgit/passwd");
            File file4 = new File(this.mirrorService.getStorageService().getDataDir().toFile(), "subgit/passwd");
            this.moveLegacyFileToShared(file, file2);
            this.moveLegacyFileToShared(file3, file4);
            if (!SgFileUtil.isFileExistsAndReadable(file2)) {
                String string = u.a().f("authors");
                String string2 = e.a(string != null ? string : "");
                SgTextUtil.writeTextFileContents(file2, string2 + "#", this.getLogger());
            }
        }
        sgSettingsEditor.save();
    }

    private void moveLegacyFileToShared(File file, File file2) {
        if (SgFileUtil.isFileExistsAndReadable(file) && !SgFileUtil.isFileExistsAndReadable(file2)) {
            this.getLogger().info("copying legacy file from: " + String.valueOf(file.toPath()));
            this.getLogger().info("to: " + String.valueOf(file2.toPath()));
            try {
                Files.copy(file.toPath(), file2.toPath(), new CopyOption[0]);
            }
            catch (IOException iOException) {
                this.getLogger().info(iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    @Override
    protected void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        if (((SgMirrorScope)this.getScope()).isRepository()) {
            if (this.stage == SgMirrorStage.LEGACY || this.stage == SgMirrorStage.INSTALLED) {
                long l2 = this.schedule == null ? -1L : this.schedule.nextTime(sgSettingsSnapshot);
                this.schedule("verify", l2);
            } else if (this.stage == SgMirrorStage.PENDING_METADATA_MOVE) {
                this.getScheduler().schedule((SgMirrorScope)this.getScope(), "move-metadata", -1L, this.schedule);
            }
        }
    }

    private void bootstrapRepositories(SgMirrorScope sgMirrorScope, SgPerformanceOption sgPerformanceOption) {
        Project project;
        int n2 = this.computeNumberOfRepositories(sgMirrorScope);
        if (n2 == 0) {
            return;
        }
        if (sgMirrorScope.isProject()) {
            project = this.mirrorService.getProjectService().getById(sgMirrorScope.getProjectId());
            if (project == null || project.getKey() == null) {
                return;
            }
        } else {
            project = null;
        }
        PageRequestImpl pageRequestImpl = new PageRequestImpl(0, 0x100000);
        int n3 = 0;
        while (pageRequestImpl != null) {
            Page page = project != null ? this.mirrorService.getRepositoryService().findByProjectKey(project.getKey(), (PageRequest)pageRequestImpl) : this.mirrorService.getRepositoryService().findAll((PageRequest)pageRequestImpl);
            for (Repository repository : page.getValues()) {
                float f2 = (float)(++n3) / (float)n2 * 100.0f;
                SgMirrorScope sgMirrorScope2 = SgMirrorScope.forRepository(repository);
                this.setProgressMessage("Processing %s / %s (%s of %s)...", (int)f2, repository.getProject().getName(), repository.getName(), n3, n2);
                if (!this.isInterestingRepository(sgMirrorScope2, repository, sgPerformanceOption)) continue;
                this.getLogger().info("repository [R-" + repository.getId() + "] considered interesting", (Object)repository.getId());
                this.getScheduler().bootstrap(sgMirrorScope2, -1L, this.getParameters());
            }
            if (page.getIsLastPage()) break;
            pageRequestImpl = page.getNextPageRequest();
        }
    }

    private int computeNumberOfRepositories(SgMirrorScope sgMirrorScope) {
        Project project;
        this.getLogger().info("computing total number of repositories in " + String.valueOf(sgMirrorScope));
        this.setProgressMessage("Computing number of repositories...", 100, new Object[0]);
        if (sgMirrorScope.isProject()) {
            project = this.mirrorService.getProjectService().getById(sgMirrorScope.getProjectId());
            if (project == null || project.getKey() == null) {
                return 0;
            }
        } else {
            project = null;
        }
        PageRequestImpl pageRequestImpl = new PageRequestImpl(0, 0x100000);
        int n2 = 0;
        while (pageRequestImpl != null) {
            Page page = project != null ? this.mirrorService.getRepositoryService().findByProjectKey(project.getKey(), (PageRequest)pageRequestImpl) : this.mirrorService.getRepositoryService().findAll((PageRequest)pageRequestImpl);
            n2 += page.getSize();
            if (page.getIsLastPage()) break;
            pageRequestImpl = page.getNextPageRequest();
        }
        this.getLogger().info("total number of repositories in " + String.valueOf(sgMirrorScope) + " : " + n2);
        return n2;
    }

    private boolean isInterestingRepository(SgMirrorScope sgMirrorScope, Repository repository, SgPerformanceOption sgPerformanceOption) {
        block5: {
            if (repository == null) {
                return false;
            }
            try {
                if (sgPerformanceOption == SgPerformanceOption.TRACK_ACTIVE) {
                    if (this.isActiveMirror(repository)) {
                        return (Boolean)this.mirrorService.createSettings(sgMirrorScope).get(SgMirrorOption.PAUSED, new SgSettingsType[0]) == false;
                    }
                    break block5;
                }
                return this.isRelatedToSubGit(repository);
            }
            catch (Throwable throwable) {
                this.getLogger().info(throwable.getMessage(), throwable);
            }
        }
        return false;
    }

    private boolean isActiveMirror(Repository repository) {
        boolean bl2 = SgRepositoryFilter.isActiveMirror(this.mirrorService.getMetadataDirectory(repository));
        if (bl2) {
            return true;
        }
        return SgRepositoryFilter.isActiveMirror(this.mirrorService.getRepositoryDirectoryOrNull(repository));
    }

    private boolean isRelatedToSubGit(Repository repository) {
        boolean bl2 = SgRepositoryFilter.isRelatedToSubGit(this.mirrorService.getMetadataDirectory(repository));
        if (bl2) {
            return true;
        }
        return SgRepositoryFilter.isRelatedToSubGit(this.mirrorService.getRepositoryDirectoryOrNull(repository));
    }
}

