/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.util.SgSchedulerOptions;

public class SgBootstrapSchedule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AtomicLong time = new AtomicLong(0L);
    private final AtomicInteger butchCounter = new AtomicInteger(0);

    public static SgBootstrapSchedule scheduled() {
        return new SgBootstrapSchedule();
    }

    private SgBootstrapSchedule() {
    }

    public synchronized long nextTime(SgSettings sgSettings) {
        int n2;
        SgSchedulerOptions sgSchedulerOptions = (SgSchedulerOptions)sgSettings.get(SgMirrorOption.SCHEDULER_OPTIONS, new SgSettingsType[0]);
        if (this.time.get() == 0L) {
            long l2 = System.currentTimeMillis();
            this.time.set(l2 + (long)(sgSchedulerOptions.getInitialDelay() * 1000));
        }
        if ((n2 = this.butchCounter.incrementAndGet()) == sgSchedulerOptions.getMaxRunnersCount()) {
            this.butchCounter.set(0);
            return this.time.getAndAdd(sgSchedulerOptions.getInitialInterval() * 1000);
        }
        return this.time.get();
    }
}

