/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.tasks;

import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import java.io.File;
import java.io.Serializable;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsEditor;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgBootstrapSchedule;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorTask;
import org.tmatesoft.subgit.stash.mirror.util.SgBackup;
import org.tmatesoft.subgit.stash.mirror.util.SgPerformanceOption;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;

public class SgApplyTask
extends SgMirrorTask {
    private final SgMirrorService mirrorService;
    private final SgBackup backup;
    private SgPerformanceOption oldTrackingMode;
    private SgPerformanceOption newTrackingMode;

    SgApplyTask(SgTaskScheduler sgTaskScheduler, String string, SgMirrorScope sgMirrorScope, long l2, Serializable serializable, SgMirrorService sgMirrorService, EscalatedSecurityContext escalatedSecurityContext) {
        super(sgTaskScheduler, string, sgMirrorScope, l2, serializable, escalatedSecurityContext);
        this.mirrorService = sgMirrorService;
        this.backup = new SgBackup();
    }

    @Override
    public boolean shouldCancel(SgTask sgTask) {
        return false;
    }

    @Override
    protected void runSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.runSecurely(sgSettingsSnapshot);
        if (((SgMirrorScope)this.getScope()).isGlobal()) {
            File file = this.mirrorService.getAuthorsService().getGlobalAuthorsFile();
            this.backup.backup(file);
            this.oldTrackingMode = (SgPerformanceOption)((Object)sgSettingsSnapshot.get(SgMirrorOption.MIRROR_TRACKING_MODE, new SgSettingsType[0]));
            this.newTrackingMode = (SgPerformanceOption)((Object)this.getUserSettings().get(SgMirrorOption.MIRROR_TRACKING_MODE, new SgSettingsType[0]));
            this.mirrorService.setLogLevel((String)this.getUserSettings().get(SgMirrorOption.LOG_LEVEL, new SgSettingsType[0]));
            String string = (String)this.getUserSettings().get(SgMirrorOption.AUTHORS, new SgSettingsType[0]);
            SgTextUtil.writeTextFileContents(file, string, this.getLogger());
            this.configureThreadPools(this.getUserSettings());
            SgSettingsEditor sgSettingsEditor = this.getSettingsEditor();
            if (this.getUserSettings().get(SgMirrorOption.CORE_DEFAULT_DOMAIN, new SgSettingsType[0]) == null) {
                sgSettingsEditor.set(SgMirrorOption.CORE_DEFAULT_DOMAIN, this.mirrorService.getAuthorsService().findDefaultDomain());
            }
            sgSettingsEditor.set(this.getUserSettings(), SgMirrorOption.USER).save();
            this.backup.delete();
        }
    }

    @Override
    public void rollback(SgSettingsSnapshot sgSettingsSnapshot) {
        this.backup.restore();
        super.rollback(sgSettingsSnapshot);
    }

    @Override
    protected void postRunSecurely(SgSettingsSnapshot sgSettingsSnapshot) {
        super.postRunSecurely(sgSettingsSnapshot);
        if (this.oldTrackingMode != this.newTrackingMode) {
            if (this.newTrackingMode == SgPerformanceOption.TRACK_ACTIVE) {
                this.getLogger().info("scheduling scopes refresh due to performance mode change");
                this.getScheduler().refresh();
            } else {
                this.getLogger().info("scheduling scopes bootstrap due to performance mode change");
                this.getScheduler().bootstrap(SgMirrorScope.global(), SgBootstrapSchedule.scheduled());
            }
        }
    }
}

