/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.svn;

import com.a.a.a.b.k;
import com.a.a.a.d.au;
import com.atlassian.bitbucket.server.StorageService;
import java.io.File;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgCredentials;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.svn.SgAuthenticationManagerProvider;
import org.tmatesoft.subgit.stash.mirror.svn.SgConnectionTest;
import org.tmatesoft.subgit.stash.mirror.svn.SgConnectionTest$Builder;
import org.tmatesoft.subgit.stash.mirror.svn.SgSubversionService$Node;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.translator.m.d.c;

public class SgSubversionService {
    private final StorageService storageService;
    private final Logger log;

    public SgSubversionService(StorageService storageService, SgLoggerFactory sgLoggerFactory) {
        this.storageService = storageService;
        this.log = sgLoggerFactory.getLogger("svn");
    }

    public SgConnectionTest testConnection(SgSettings sgSettings) {
        SgConnectionTest$Builder sgConnectionTest$Builder = SgConnectionTest.builder();
        try {
            SgAuthenticationManagerProvider sgAuthenticationManagerProvider = this.createAuthenticationProvider(sgSettings);
            SgSubversionService.testReadAccess(sgAuthenticationManagerProvider);
            sgConnectionTest$Builder.setIsReadAccess(true);
            try {
                SgSubversionService.testWriteAccess(sgAuthenticationManagerProvider);
                sgConnectionTest$Builder.setIsWriteAccess(true);
            }
            catch (SVNException sVNException) {
                sgConnectionTest$Builder.setIsWriteAccess(false);
                sgConnectionTest$Builder.setError(this.getErrorMessage(sVNException));
                this.log.debug("Connection write access test failed", (Throwable)sVNException);
            }
            catch (Throwable throwable) {
                sgConnectionTest$Builder.setIsWriteAccess(false);
                sgConnectionTest$Builder.setError(this.getErrorMessage(throwable));
                this.log.error("Connection write access test failed unexpectedly", throwable);
            }
        }
        catch (SVNException sVNException) {
            sgConnectionTest$Builder.setError(this.getErrorMessage(sVNException));
            this.log.debug("Connection read access test failed", (Throwable)sVNException);
        }
        catch (Throwable throwable) {
            sgConnectionTest$Builder.setError(this.getErrorMessage(throwable));
            this.log.error("Connection read access test failed unexpectedly", throwable);
        }
        return sgConnectionTest$Builder.build();
    }

    public long computeRevisionsCount(SgSettings sgSettings, ISVNCanceller iSVNCanceller) {
        SgAuthenticationManagerProvider sgAuthenticationManagerProvider = this.createAuthenticationProvider(sgSettings);
        au au2 = sgAuthenticationManagerProvider.getUrl();
        SVNRepository sVNRepository = SVNRepositoryFactory.create(au2.h());
        sVNRepository.setAuthenticationManager(sgAuthenticationManagerProvider.getAuthenticationManager());
        sVNRepository.setTunnelProvider(sgAuthenticationManagerProvider.getTunnelProvider());
        sVNRepository.setCanceller(iSVNCanceller);
        long l2 = -1L;
        try {
            l2 = sVNRepository.getLatestRevision();
            this.log.info("Running get-locations-segments to estimate project revisions count");
            List list = sVNRepository.getLocationSegments("", l2, l2, 0L);
            if (list.isEmpty() || Math.max(((SVNLocationSegment)list.get(0)).getEndRevision(), ((SVNLocationSegment)list.get(0)).getStartRevision()) != l2) {
                this.log.info("No sane segments received, falling back to legacy log method");
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED));
            }
            this.log.info("estimated revisions count: " + Math.abs(((SVNLocationSegment)list.get(0)).getStartRevision() - ((SVNLocationSegment)list.get(0)).getEndRevision()));
            long l3 = Math.abs(((SVNLocationSegment)list.get(0)).getStartRevision() - ((SVNLocationSegment)list.get(0)).getEndRevision());
            return l3;
        }
        catch (SVNException sVNException) {
            this.log.info(sVNException.getMessage(), (Throwable)sVNException);
            this.log.info("Running log to estimate project revisions count");
            if (l2 >= 0L && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                long[] lArray = new long[]{0L};
                sVNRepository.log(new String[0], l2, 0L, false, true, sVNLogEntry -> {
                    lArray[0] = lArray[0] + 1L;
                });
                this.log.info("estimated revisions count: " + lArray[0]);
                long l4 = lArray[0];
                return l4;
            }
            throw sVNException;
        }
        finally {
            sVNRepository.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testWriteAccess(SgAuthenticationManagerProvider sgAuthenticationManagerProvider) {
        au au2 = sgAuthenticationManagerProvider.getUrl();
        SVNRepository sVNRepository = SVNRepositoryFactory.create(au2.h());
        sVNRepository.setAuthenticationManager(sgAuthenticationManagerProvider.getAuthenticationManager());
        sVNRepository.setTunnelProvider(sgAuthenticationManagerProvider.getTunnelProvider());
        ISVNEditor iSVNEditor = null;
        try {
            iSVNEditor = sVNRepository.getCommitEditor("test", null);
            iSVNEditor.openRoot(-1L);
            iSVNEditor.changeDirProperty("svnmirror:test", SVNPropertyValue.create("svnmirror:test"));
        }
        finally {
            if (iSVNEditor != null) {
                iSVNEditor.abortEdit();
            }
            sVNRepository.closeSession();
        }
    }

    private static void testReadAccess(SgAuthenticationManagerProvider sgAuthenticationManagerProvider) {
        SVNRepository sVNRepository = SVNRepositoryFactory.create(sgAuthenticationManagerProvider.getUrl().h());
        sVNRepository.setAuthenticationManager(sgAuthenticationManagerProvider.getAuthenticationManager());
        sVNRepository.setTunnelProvider(sgAuthenticationManagerProvider.getTunnelProvider());
        try {
            sVNRepository.info("", -1L);
        }
        finally {
            sVNRepository.closeSession();
        }
    }

    public SgAuthenticationManagerProvider createAuthenticationProvider(SgSettings sgSettings) {
        return this.createAuthenticationProvider(sgSettings, null);
    }

    public SgAuthenticationManagerProvider createAuthenticationProvider(SgSettings sgSettings, Logger logger) {
        File file;
        au au2;
        String string = (String)sgSettings.get(SgMirrorOption.SVN_URL, new SgSettingsType[0]);
        if (string == null) {
            throw new SgException("Missing URL");
        }
        try {
            au2 = au.b(string);
        }
        catch (k k2) {
            throw SgException.wrap(k2);
        }
        File file2 = new File(this.storageService.getDataDir().toFile(), "subgit/passwd");
        if (sgSettings.get(SgMirrorOption.METADATA_PATH, new SgSettingsType[0]) != null) {
            c c2 = c.b((File)sgSettings.get(SgMirrorOption.METADATA_PATH, new SgSettingsType[0]));
            file = c2.A();
        } else {
            file = null;
        }
        return new SgAuthenticationManagerProvider(logger != null ? logger : this.log, au2, this.getDefaultCachePath(), file2, file, (SgCredentials)sgSettings.get(SgMirrorOption.CREDENTIALS, new SgSettingsType[0]), (Integer)sgSettings.get(SgMirrorOption.SVN_CONNECT_TIMEOUT, new SgSettingsType[0]), (Integer)sgSettings.get(SgMirrorOption.SVN_READ_TIMEOUT, new SgSettingsType[0]));
    }

    public String getErrorMessage(Throwable throwable) {
        return SgTextUtil.formatErrorMessage(throwable);
    }

    public SgSubversionService$Node[] loadNodes(SgSettings sgSettings) {
        TreeSet treeSet = new TreeSet();
        if (sgSettings.get(SgMirrorOption.SVN_URL, new SgSettingsType[0]) == null) {
            return new SgSubversionService$Node[0];
        }
        SgAuthenticationManagerProvider sgAuthenticationManagerProvider = this.createAuthenticationProvider(sgSettings);
        SVNRepository sVNRepository = null;
        try {
            sVNRepository = SVNRepositoryFactory.create(sgAuthenticationManagerProvider.getUrl().h());
            sVNRepository.setAuthenticationManager(sgAuthenticationManagerProvider.getAuthenticationManager());
            sVNRepository.setTunnelProvider(sgAuthenticationManagerProvider.getTunnelProvider());
            sVNRepository.getDir("", -1L, null, 1, sVNDirEntry -> {
                if (sVNDirEntry.getKind() == SVNNodeKind.DIR) {
                    treeSet.add(new SgSubversionService$Node(sVNDirEntry.getName()));
                }
            });
        }
        catch (SVNException sVNException) {
            throw SgException.wrap(sVNException);
        }
        finally {
            if (sVNRepository != null) {
                sVNRepository.closeSession();
            }
        }
        return treeSet.toArray(new SgSubversionService$Node[0]);
    }

    public File getDefaultCachePath() {
        return SVNWCUtil.getDefaultConfigurationDirectory();
    }
}

