/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.svn;

import com.a.a.a.d.au;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.TrileadAgentProxy;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgCredentials;
import org.tmatesoft.subgit.stash.mirror.SgCredentials$Type;
import org.tmatesoft.subgit.stash.mirror.svn.SgAuthenticationManagerProvider$1;
import org.tmatesoft.subgit.stash.mirror.svn.SgAuthenticationManagerProvider$2;
import org.tmatesoft.subgit.stash.mirror.svn.SgAuthenticationManagerProvider$AuthenticationManagerWrapper;
import org.tmatesoft.subgit.stash.mirror.svn.SgAuthenticationManagerProvider$ExplicitAuthenticationManager;
import org.tmatesoft.subgit.stash.mirror.svn.SgAuthenticationManagerProvider$NonInteractiveAuthenticationStorageOptions;
import org.tmatesoft.subgit.stash.mirror.util.SgFileUtil;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorage;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorageOptions;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.translator.b.d;
import org.tmatesoft.translator.m.a.h;
import org.tmatesoft.translator.util.f;

public class SgAuthenticationManagerProvider
extends org.tmatesoft.translator.m.a.d {
    private static final ISVNAuthenticationStorageOptions NON_INTERACTIVE_AUTH_STORAGE_OPTIONS = new SgAuthenticationManagerProvider$NonInteractiveAuthenticationStorageOptions();
    private final File globalPasswordsPath;
    private final File repositoryPasswordsPath;
    private final SgCredentials credentials;
    private final int connectTimeout;
    private final int readTimeout;
    private final au url;
    private final Logger log;
    private final File cachePath;
    private final ISVNTunnelProvider tunnelProvider;
    private String currentUser;

    public SgAuthenticationManagerProvider(Logger logger, au au2, File file, File file2, File file3, SgCredentials sgCredentials, int n2, int n3) {
        super(null, new d(), null, null, n2, n3, au2, SgAuthenticationManagerProvider.createEmptyOptions(), null);
        this.log = logger;
        this.url = au2;
        this.globalPasswordsPath = file2;
        this.repositoryPasswordsPath = file3;
        this.credentials = sgCredentials;
        this.cachePath = sgCredentials.getCachePath() != null ? sgCredentials.getCachePath() : file;
        this.connectTimeout = n2;
        this.readTimeout = n3;
        this.tunnelProvider = new DefaultSVNOptions(this.cachePath, true);
    }

    public au getUrl() {
        return this.url;
    }

    @Override
    public boolean setCurrentUser(String string) {
        this.currentUser = string;
        return super.setCurrentUser(string);
    }

    @Override
    public boolean setCurrentUserToDefault() {
        return super.setCurrentUserToDefault();
    }

    @Override
    @Nullable
    public ISVNAuthenticationManager getAuthenticationManager() {
        Object object;
        ArrayList<SVNAuthentication> arrayList;
        block20: {
            SVNURL sVNURL = this.url.h();
            this.log.info("svn authentication manager for ''{}''", (Object)sVNURL);
            if (this.credentials.isUseCache()) {
                this.log.info("  subversion credentials cache at '" + String.valueOf(this.cachePath) + "'");
                SgAuthenticationManagerProvider$1 sgAuthenticationManagerProvider$1 = new SgAuthenticationManagerProvider$1(this, this.cachePath, false, null, null, null, null);
                sgAuthenticationManagerProvider$1.setAuthenticationStorageOptions(NON_INTERACTIVE_AUTH_STORAGE_OPTIONS);
                sgAuthenticationManagerProvider$1.setRuntimeStorage(SgAuthenticationManagerProvider.createRuntimeStorage());
                return new SgAuthenticationManagerProvider$AuthenticationManagerWrapper(sgAuthenticationManagerProvider$1, this.currentUser);
            }
            boolean bl2 = sVNURL.getProtocol().endsWith("+ssh");
            arrayList = new ArrayList<SVNAuthentication>();
            char[] cArray = this.credentials.getPassphrase();
            char[] cArray2 = this.credentials.getPassword();
            char[] cArray3 = this.credentials.getSslPassword();
            String string = this.credentials.getUserName();
            if (this.currentUser != null || string != null) {
                arrayList.add(SVNUserNameAuthentication.newInstance(this.currentUser != null ? this.currentUser : string, false, sVNURL, false));
                this.log.info("  added user name credentials: " + (this.currentUser != null ? this.currentUser : string));
            }
            if (string != null && !"".equals(string)) {
                this.log.info("  explicit user name credentials: " + string);
            } else {
                this.log.info("  empty user name explicit credentials");
            }
            if (this.credentials.getType() == SgCredentials$Type.SIMPLE) {
                if (bl2) {
                    arrayList.add(SVNSSHAuthentication.newInstance(string, cArray2, this.url.g() ? this.url.e() : 22, false, sVNURL, false));
                } else {
                    this.addPasswordCredentials(sVNURL, arrayList, string, cArray2);
                }
            } else if (this.credentials.getType() == SgCredentials$Type.SSL) {
                if (string != null && !"".equals(string)) {
                    this.addPasswordCredentials(sVNURL, arrayList, string, cArray3);
                    this.log.info("  added password credentials for SSL: " + string);
                } else {
                    this.log.info("  skipping password credentials for SSL, empty username");
                }
                if (this.credentials.getSslCertValue() != null) {
                    arrayList.add(SVNSSLAuthentication.newInstance(this.credentials.getSslCertValue(), cArray, false, sVNURL, false));
                    this.log.info("  explicit SSL certificate credentials");
                }
            } else if (this.credentials.getType() == SgCredentials$Type.SSH) {
                if (this.credentials.isUseSshAgent()) {
                    try {
                        object = ConnectorFactory.getDefault().createConnector();
                        if (object != null) {
                            TrileadAgentProxy trileadAgentProxy = new TrileadAgentProxy((Connector)object);
                            arrayList.add(SVNSSHAuthentication.newInstance(string, trileadAgentProxy, this.url.g() ? this.url.e() : 22, sVNURL, false));
                            this.log.info("  explicit SSH agent credentials");
                            break block20;
                        }
                        this.log.info("  failed to create SSH agent connection");
                    }
                    catch (AgentProxyException agentProxyException) {
                        this.log.info(agentProxyException.getMessage(), (Throwable)agentProxyException);
                    }
                } else if (this.credentials.getSshKeyValue() != null) {
                    object = new String(this.credentials.getSshKeyValue(), StandardCharsets.UTF_8).toCharArray();
                    arrayList.add(SVNSSHAuthentication.newInstance(string, (char[])object, cArray, this.url.g() ? this.url.e() : 22, false, sVNURL, false));
                    this.log.info("  explicit SSH key credentials");
                }
            }
        }
        object = new DefaultSVNAuthenticationManager(this.cachePath, false, null, (char[])null, null, null);
        ((DefaultSVNAuthenticationManager)object).setRuntimeStorage(SgAuthenticationManagerProvider.createRuntimeStorage());
        ((DefaultSVNAuthenticationManager)object).setAuthenticationStorageOptions(NON_INTERACTIVE_AUTH_STORAGE_OPTIONS);
        return new SgAuthenticationManagerProvider$ExplicitAuthenticationManager(this, arrayList, (DefaultSVNAuthenticationManager)object);
    }

    private void addPasswordCredentials(SVNURL sVNURL, List list, String string, char[] cArray) {
        Map map = this.loadPasswords(new HashMap());
        if (this.currentUser != null && !this.currentUser.trim().isEmpty()) {
            char[] cArray2 = (char[])map.get(this.currentUser);
            if (cArray2 != null) {
                list.add(SVNPasswordAuthentication.newInstance(this.currentUser, cArray2, false, sVNURL, false));
                this.log.info("  explicit password credentials for user '" + this.currentUser + "'");
            }
            list.add(SVNPasswordAuthentication.newInstance(string, cArray, false, sVNURL, false));
            this.log.info("  explicit password credentials for user '" + string + "'");
            for (String string2 : map.keySet()) {
                list.add(SVNPasswordAuthentication.newInstance(string2, (char[])map.get(string2), false, sVNURL, false));
                this.log.info("  explicit password credentials for user '" + string2 + "'");
            }
        } else {
            list.add(SVNPasswordAuthentication.newInstance(string, cArray, false, sVNURL, false));
            for (String string3 : map.keySet()) {
                list.add(SVNPasswordAuthentication.newInstance(string3, (char[])map.get(string3), false, sVNURL, false));
            }
        }
    }

    @Override
    public ISVNTunnelProvider getTunnelProvider() {
        return this.tunnelProvider;
    }

    private static h createEmptyOptions() {
        return new h(null, null, null, null, true, true, SgAuthenticationManagerProvider.createRuntimeStorage(), new HashMap(), new HashMap());
    }

    private static ISVNAuthenticationStorage createRuntimeStorage() {
        return new SgAuthenticationManagerProvider$2();
    }

    private Map loadPasswords(Map map) {
        Map map2;
        if (SgFileUtil.isFileExistsAndReadable(this.globalPasswordsPath)) {
            try {
                map2 = org.tmatesoft.translator.m.a.d.loadPasswordsFromFile(this.globalPasswordsPath);
                map.putAll(map2);
            }
            catch (f f2) {
                this.log.info("failed to load global passwords file: " + f2.getMessage());
            }
        }
        if (SgFileUtil.isFileExistsAndReadable(this.repositoryPasswordsPath)) {
            try {
                map2 = org.tmatesoft.translator.m.a.d.loadPasswordsFromFile(this.repositoryPasswordsPath);
                map.putAll(map2);
            }
            catch (f f3) {
                this.log.info("failed to load local passwords file: " + f3.getMessage());
            }
        }
        return map;
    }
}

