/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.settings;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.subgit.stash.mirror.settings.SgGsonSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSetting;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;

public class SgStashSettings
extends SgGsonSettings {
    private static final long serialVersionUID = 1L;
    private final PluginSettings settings;
    private final String systemPropertyKey;
    private Map valueCache = new HashMap();

    public SgStashSettings(SgSettingsType sgSettingsType, PluginSettings pluginSettings, String string, SgSettings sgSettings, Gson gson) {
        super(sgSettingsType, sgSettings, gson);
        this.settings = pluginSettings;
        this.systemPropertyKey = string;
    }

    @Override
    protected boolean doSetValue(SgSetting sgSetting, String string) {
        String string2 = System.getProperty(this.getSystemPropertyKey(sgSetting));
        if (string2 != null && string2.equals(string)) {
            return true;
        }
        if (string == null) {
            this.valueCache.remove(sgSetting.getSettingsKey());
            this.settings.remove(sgSetting.getSettingsKey());
        } else {
            this.valueCache.put(sgSetting.getSettingsKey(), string);
            this.settings.put(sgSetting.getSettingsKey(), (Object)string);
        }
        return true;
    }

    @Override
    protected String doGetValue(SgSetting sgSetting) {
        if (this.valueCache.containsKey(sgSetting.getSettingsKey())) {
            return (String)this.valueCache.get(sgSetting.getSettingsKey());
        }
        String string = System.getProperty(this.getSystemPropertyKey(sgSetting));
        String string2 = string != null ? (sgSetting.getType() == String.class ? this.getGson().toJson((Object)string, (Type)((Object)String.class)) : string) : (String)this.settings.get(sgSetting.getSettingsKey());
        this.valueCache.put(sgSetting.getSettingsKey(), string2);
        return string2;
    }

    private String getSystemPropertyKey(SgSetting sgSetting) {
        return this.systemPropertyKey != null && !"G".equals(this.systemPropertyKey) ? sgSetting.getSystemPropertyName(this.systemPropertyKey) : sgSetting.getGlobalSystemPropertyName();
    }
}

