/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.settings;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonService;
import org.tmatesoft.subgit.stash.mirror.settings.SgConfigSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgDefaultSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.settings.SgStashSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgValuesSettings;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;

public class SgSettingsService {
    private static final SgSettings DEFAULT_SETTINGS = new SgDefaultSettings(SgSettingsType.DEFAULTS);
    private static final String SETTINGS_KEY_PREFIX = "org.tmatesoft.subgit";
    private final PluginSettingsFactory settingsFactory;
    private final SgJsonService jsonService;
    private final Map stashSettings;

    public SgSettingsService(PluginSettingsFactory pluginSettingsFactory, SgJsonService sgJsonService) {
        this.settingsFactory = pluginSettingsFactory;
        this.jsonService = sgJsonService;
        this.stashSettings = new HashMap();
    }

    private PluginSettings createSettingsForKey(String string) {
        return this.settingsFactory.createSettingsForKey(string);
    }

    public SgSettings createDefaultSettings() {
        return DEFAULT_SETTINGS;
    }

    public SgSettings createValuesSettings(SgSettingsType sgSettingsType, SgSettings sgSettings, Map map) {
        return new SgValuesSettings(sgSettingsType, sgSettings, map);
    }

    public SgSettings createConfigSettings(SgSettingsType sgSettingsType, SgSettings sgSettings, String string) {
        SgConfigSettings sgConfigSettings = new SgConfigSettings(sgSettingsType, sgSettings, this.jsonService.getGson());
        sgConfigSettings.load(string);
        return sgConfigSettings;
    }

    public synchronized SgSettings createStashSettings(SgSettingsType sgSettingsType, SgSettings sgSettings, Object object) {
        SgSettings sgSettings2;
        String string = object.toString();
        String string2 = "org.tmatesoft.subgit." + string;
        WeakReference weakReference = (WeakReference)this.stashSettings.get(string2);
        SgSettings sgSettings3 = sgSettings2 = weakReference != null ? (SgSettings)weakReference.get() : null;
        if (sgSettings2 == null) {
            sgSettings2 = this.doCreateStashSettings(sgSettingsType, sgSettings, string2, string);
            this.stashSettings.put(string2, new WeakReference<SgSettings>(sgSettings2));
        }
        return sgSettings2;
    }

    private SgSettings doCreateStashSettings(SgSettingsType sgSettingsType, SgSettings sgSettings, String string, String string2) {
        PluginSettings pluginSettings = this.createSettingsForKey(string);
        return new SgStashSettings(sgSettingsType, pluginSettings, string2, sgSettings, this.jsonService.getEncryptedGson());
    }

    public SgSettings createSettingsForScope(SgMirrorScope sgMirrorScope) {
        SgSettings sgSettings;
        if (sgMirrorScope.isGlobal()) {
            sgSettings = this.createDefaultSettings();
        } else if (sgMirrorScope.isProject()) {
            sgSettings = this.createSettingsForScope(SgMirrorScope.global());
        } else {
            SgMirrorScope sgMirrorScope2 = SgMirrorScope.forProjectId(sgMirrorScope.getProjectId());
            sgSettings = this.createSettingsForScope(sgMirrorScope2);
        }
        return this.createStashSettings(sgMirrorScope.getSettingsType(), sgSettings, sgMirrorScope);
    }
}

